package org.cloudfoundry.operations.domains;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request options for the create shared domain operation
 */
@Generated(from = "_CreateSharedDomainRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateSharedDomainRequest
    extends org.cloudfoundry.operations.domains._CreateSharedDomainRequest {
  private final String domain;
  private final @Nullable String routerGroup;

  private CreateSharedDomainRequest(CreateSharedDomainRequest.Builder builder) {
    this.domain = builder.domain;
    this.routerGroup = builder.routerGroup;
  }

  /**
   * The domain name
   */
  @Override
  public String getDomain() {
    return domain;
  }

  /**
   * The router group name
   */
  @Override
  public @Nullable String getRouterGroup() {
    return routerGroup;
  }

  /**
   * This instance is equal to all instances of {@code CreateSharedDomainRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateSharedDomainRequest
        && equalTo((CreateSharedDomainRequest) another);
  }

  private boolean equalTo(CreateSharedDomainRequest another) {
    return domain.equals(another.domain)
        && Objects.equals(routerGroup, another.routerGroup);
  }

  /**
   * Computes a hash code from attributes: {@code domain}, {@code routerGroup}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + domain.hashCode();
    h += (h << 5) + Objects.hashCode(routerGroup);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateSharedDomainRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateSharedDomainRequest{"
        + "domain=" + domain
        + ", routerGroup=" + routerGroup
        + "}";
  }

  /**
   * Creates a builder for {@link CreateSharedDomainRequest CreateSharedDomainRequest}.
   * <pre>
   * CreateSharedDomainRequest.builder()
   *    .domain(String) // required {@link CreateSharedDomainRequest#getDomain() domain}
   *    .routerGroup(String | null) // nullable {@link CreateSharedDomainRequest#getRouterGroup() routerGroup}
   *    .build();
   * </pre>
   * @return A new CreateSharedDomainRequest builder
   */
  public static CreateSharedDomainRequest.Builder builder() {
    return new CreateSharedDomainRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateSharedDomainRequest CreateSharedDomainRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateSharedDomainRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DOMAIN = 0x1L;
    private long initBits = 0x1L;

    private String domain;
    private String routerGroup;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateSharedDomainRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateSharedDomainRequest instance) {
      return from((_CreateSharedDomainRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateSharedDomainRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateSharedDomainRequest instance) {
      Objects.requireNonNull(instance, "instance");
      domain(instance.getDomain());
      String routerGroupValue = instance.getRouterGroup();
      if (routerGroupValue != null) {
        routerGroup(routerGroupValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSharedDomainRequest#getDomain() domain} attribute.
     * @param domain The value for domain 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder domain(String domain) {
      this.domain = Objects.requireNonNull(domain, "domain");
      initBits &= ~INIT_BIT_DOMAIN;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateSharedDomainRequest#getRouterGroup() routerGroup} attribute.
     * @param routerGroup The value for routerGroup (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routerGroup(@Nullable String routerGroup) {
      this.routerGroup = routerGroup;
      return this;
    }

    /**
     * Builds a new {@link CreateSharedDomainRequest CreateSharedDomainRequest}.
     * @return An immutable instance of CreateSharedDomainRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateSharedDomainRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateSharedDomainRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DOMAIN) != 0) attributes.add("domain");
      return "Cannot build CreateSharedDomainRequest, some of required attributes are not set " + attributes;
    }
  }
}
