package org.cloudfoundry.operations.spaces;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request options for the get space operation
 */
@Generated(from = "_GetSpaceRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetSpaceRequest extends org.cloudfoundry.operations.spaces._GetSpaceRequest {
  private final String name;
  private final @Nullable Boolean securityGroupRules;

  private GetSpaceRequest(GetSpaceRequest.Builder builder) {
    this.name = builder.name;
    this.securityGroupRules = builder.securityGroupRules;
  }

  /**
   * The name of the space
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * Include Security Group Rules information
   */
  @Override
  public @Nullable Boolean getSecurityGroupRules() {
    return securityGroupRules;
  }

  /**
   * This instance is equal to all instances of {@code GetSpaceRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetSpaceRequest
        && equalTo((GetSpaceRequest) another);
  }

  private boolean equalTo(GetSpaceRequest another) {
    return name.equals(another.name)
        && Objects.equals(securityGroupRules, another.securityGroupRules);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code securityGroupRules}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(securityGroupRules);
    return h;
  }

  /**
   * Prints the immutable value {@code GetSpaceRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetSpaceRequest{"
        + "name=" + name
        + ", securityGroupRules=" + securityGroupRules
        + "}";
  }

  /**
   * Creates a builder for {@link GetSpaceRequest GetSpaceRequest}.
   * <pre>
   * GetSpaceRequest.builder()
   *    .name(String) // required {@link GetSpaceRequest#getName() name}
   *    .securityGroupRules(Boolean | null) // nullable {@link GetSpaceRequest#getSecurityGroupRules() securityGroupRules}
   *    .build();
   * </pre>
   * @return A new GetSpaceRequest builder
   */
  public static GetSpaceRequest.Builder builder() {
    return new GetSpaceRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetSpaceRequest GetSpaceRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetSpaceRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String name;
    private Boolean securityGroupRules;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetSpaceRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetSpaceRequest instance) {
      return from((_GetSpaceRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetSpaceRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetSpaceRequest instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      Boolean securityGroupRulesValue = instance.getSecurityGroupRules();
      if (securityGroupRulesValue != null) {
        securityGroupRules(securityGroupRulesValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetSpaceRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link GetSpaceRequest#getSecurityGroupRules() securityGroupRules} attribute.
     * @param securityGroupRules The value for securityGroupRules (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupRules(@Nullable Boolean securityGroupRules) {
      this.securityGroupRules = securityGroupRules;
      return this;
    }

    /**
     * Builds a new {@link GetSpaceRequest GetSpaceRequest}.
     * @return An immutable instance of GetSpaceRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetSpaceRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetSpaceRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build GetSpaceRequest, some of required attributes are not set " + attributes;
    }
  }
}
