/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.tools.pushapps;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.applications.ApplicationHealthCheck;
import org.cloudfoundry.operations.applications.PushApplicationRequest;
import org.cloudfoundry.tools.pushapps.config.AppConfig;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/cloudfoundry/tools/pushapps/PushApplication;", "", "cloudFoundryOperations", "Lorg/cloudfoundry/operations/CloudFoundryOperations;", "appConfig", "Lorg/cloudfoundry/tools/pushapps/config/AppConfig;", "(Lorg/cloudfoundry/operations/CloudFoundryOperations;Lorg/cloudfoundry/tools/pushapps/config/AppConfig;)V", "generatePushAppAction", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "setOptionalBuilderParams", "Lorg/cloudfoundry/operations/applications/PushApplicationRequest$Builder;", "builder", "push-apps"})
public final class PushApplication {
    private final CloudFoundryOperations cloudFoundryOperations;
    private final AppConfig appConfig;

    @NotNull
    public final Mono<Void> generatePushAppAction() {
        PushApplicationRequest.Builder builder;
        PushApplicationRequest.Builder builder2 = builder = PushApplicationRequest.builder().name(this.appConfig.getName()).path(new File(this.appConfig.getPath()).toPath()).noRoute(Boolean.valueOf(this.appConfig.getNoRoute())).noStart(Boolean.valueOf(true));
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"builder");
        builder = this.setOptionalBuilderParams(builder2);
        PushApplicationRequest pushAppRequest = builder.build();
        Mono mono = this.cloudFoundryOperations.applications().push(pushAppRequest);
        Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"cloudFoundryOperations\n \u2026    .push(pushAppRequest)");
        return mono;
    }

    private final PushApplicationRequest.Builder setOptionalBuilderParams(PushApplicationRequest.Builder builder) {
        PushApplicationRequest pushApplicationRequest = builder.build();
        PushApplicationRequest.Builder newBuilder = PushApplicationRequest.builder().from(pushApplicationRequest);
        if (this.appConfig.getBuildpack() != null) {
            newBuilder.buildpack(this.appConfig.getBuildpack());
        }
        if (this.appConfig.getCommand() != null) {
            newBuilder.command(this.appConfig.getCommand());
        }
        if (this.appConfig.getInstances() != null) {
            newBuilder.instances(this.appConfig.getInstances());
        }
        if (this.appConfig.getDiskQuota() != null) {
            newBuilder.diskQuota(this.appConfig.getDiskQuota());
        }
        if (this.appConfig.getMemory() != null) {
            newBuilder.memory(this.appConfig.getMemory());
        }
        if (this.appConfig.getNoHostname() != null) {
            newBuilder.noHostname(this.appConfig.getNoHostname());
        }
        if (this.appConfig.getTimeout() != null) {
            newBuilder.timeout(this.appConfig.getTimeout());
        }
        if (this.appConfig.getDomain() != null) {
            newBuilder.domain(this.appConfig.getDomain());
        }
        if (this.appConfig.getHealthCheckType() != null) {
            newBuilder.healthCheckType(ApplicationHealthCheck.from((String)this.appConfig.getHealthCheckType()));
        }
        PushApplicationRequest.Builder builder2 = newBuilder;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"newBuilder");
        return builder2;
    }

    public PushApplication(@NotNull CloudFoundryOperations cloudFoundryOperations, @NotNull AppConfig appConfig) {
        Intrinsics.checkParameterIsNotNull((Object)cloudFoundryOperations, (String)"cloudFoundryOperations");
        Intrinsics.checkParameterIsNotNull((Object)appConfig, (String)"appConfig");
        this.cloudFoundryOperations = cloudFoundryOperations;
        this.appConfig = appConfig;
    }
}

