/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.adapter.impl;

import com.google.common.base.Preconditions;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.gmaven.adapter.ResourceLoader;
import org.codehaus.gmaven.adapter.ShellRunner;
import org.codehaus.gmaven.adapter.impl.GroovyRuntimeImpl;
import org.codehaus.groovy.tools.shell.Groovysh;
import org.codehaus.groovy.tools.shell.IO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellRunnerImpl
implements ShellRunner {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final GroovyRuntimeImpl runtime;

    ShellRunnerImpl(GroovyRuntimeImpl runtime) {
        this.runtime = (GroovyRuntimeImpl)Preconditions.checkNotNull((Object)runtime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ClassLoader classLoader, ResourceLoader resourceLoader, Map<String, Object> context, @Nullable Map<String, Object> options) throws Exception {
        Preconditions.checkNotNull((Object)classLoader);
        Preconditions.checkNotNull((Object)resourceLoader);
        Preconditions.checkNotNull(context);
        this.log.trace("Running; class-loader: {}, resource-loader: {}, context: {}", new Object[]{classLoader, resourceLoader, context});
        GroovyClassLoader gcl = this.runtime.createGroovyClassLoader(classLoader, resourceLoader);
        Binding binding = this.runtime.createBinding(context);
        Groovysh shell = new Groovysh((ClassLoader)gcl, binding, new IO());
        if (options != null) {
            this.configureOptions(shell, options);
        }
        try {
            shell.run(new String[0]);
        }
        finally {
            gcl.clearCache();
        }
    }

    private void configureOptions(Groovysh shell, Map<String, Object> options) {
    }
}

