/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.antlr;

import java.util.List;

public class LocationSupport {
    private static final int[] NO_LINE_ENDINGS = new int[0];
    public static final LocationSupport NO_LOCATIONS = new LocationSupport();
    private final int[] lineEndings;

    public LocationSupport() {
        this.lineEndings = NO_LINE_ENDINGS;
    }

    public LocationSupport(int[] lineEndings) {
        this.lineEndings = lineEndings;
    }

    public LocationSupport(List<StringBuffer> lines) {
        this.lineEndings = lines != null ? this.processLineEndings(lines) : NO_LINE_ENDINGS;
    }

    private int[] processLineEndings(List<? extends CharSequence> lines) {
        int[] newLineEndings = new int[lines.size() + 1];
        int total = 0;
        int current = 1;
        for (CharSequence charSequence : lines) {
            newLineEndings[current++] = total += charSequence.length();
        }
        return newLineEndings;
    }

    public int findOffset(int row, int col) {
        return row <= this.lineEndings.length && row > 0 ? this.lineEndings[row - 1] + col - 1 : 0;
    }

    public int getEnd() {
        return this.lineEndings.length > 0 ? this.lineEndings[this.lineEndings.length - 1] : 0;
    }

    public int getEndColumn() {
        if (this.lineEndings.length > 1) {
            return this.lineEndings[this.lineEndings.length - 1] - this.lineEndings[this.lineEndings.length - 2];
        }
        if (this.lineEndings.length > 0) {
            return this.lineEndings[0];
        }
        return 0;
    }

    public int getEndLine() {
        return this.lineEndings.length > 0 ? this.lineEndings.length - 1 : 0;
    }

    public int[] getRowCol(int offset) {
        int i = 1;
        while (i < this.lineEndings.length) {
            if (this.lineEndings[i] > offset) {
                return new int[]{i, offset - this.lineEndings[i - 1] + 1};
            }
            ++i;
        }
        throw new RuntimeException("Location is after end of document.  Offset : " + offset);
    }

    public boolean isPopulated() {
        return this.lineEndings.length > 0;
    }
}

