/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.eclipse.jdt.groovy.search.VariableScope;

public class AssignmentStorer {
    public void storeAssignment(BinaryExpression assign, VariableScope scope, ClassNode rhsType) {
        if (assign instanceof DeclarationExpression) {
            DeclarationExpression decl = (DeclarationExpression)assign;
            if (decl.isMultipleAssignmentDeclaration()) {
                TupleExpression tuple = (TupleExpression)decl.getLeftExpression();
                this.handleMultiAssignment(scope, rhsType, decl, tuple);
            } else {
                VariableExpression var = decl.getVariableExpression();
                scope.addVariable(var.getName(), this.findVariableType(var, rhsType), null);
            }
        } else if (this.isInterestingOperation(assign)) {
            Expression lhs = assign.getLeftExpression();
            if (lhs instanceof TupleExpression) {
                TupleExpression tuple = (TupleExpression)lhs;
                this.handleMultiAssignment(scope, rhsType, assign, tuple);
            } else {
                this.handleSingleAssignment(lhs, scope, rhsType);
            }
        }
    }

    public void storeField(FieldNode node, VariableScope scope) {
        Expression init = node.getInitialExpression();
        if (!this.isObjectType(init)) {
            scope.addVariable(node.getName(), init.getType(), node.getDeclaringClass());
        }
    }

    public void storeImport(ImportNode node, VariableScope scope) {
        block6: {
            List<MethodNode> methods;
            ClassNode type;
            block5: {
                type = node.getType();
                if (!node.isStar() || type == null) break block5;
                List<FieldNode> fields = type.getFields();
                for (FieldNode field : fields) {
                    if (!field.isStatic()) continue;
                    scope.addVariable(field.getName(), field.getType(), type);
                }
                List<MethodNode> methods2 = node.getType().getMethods();
                for (MethodNode method : methods2) {
                    if (!method.isStatic()) continue;
                    scope.addVariable(method.getName(), method.getReturnType(), type);
                }
                break block6;
            }
            String fieldName = node.getFieldName();
            if (!node.isStatic() || type == null || fieldName == null) break block6;
            String alias = node.getAlias() != null ? node.getAlias() : fieldName;
            FieldNode field = type.getField(fieldName);
            if (field != null) {
                scope.addVariable(alias, field.getType(), type);
            }
            if ((methods = type.getDeclaredMethods(fieldName)) != null) {
                for (MethodNode method : methods) {
                    scope.addVariable(alias, method.getReturnType(), type);
                }
            }
        }
    }

    private void handleMultiAssignment(VariableScope scope, ClassNode objectExpressionType, BinaryExpression binaryExpr, TupleExpression tuple) {
        ClassNode maybeType = this.findComponentType(objectExpressionType);
        ListExpression rhs = binaryExpr.getRightExpression() instanceof ListExpression ? (ListExpression)binaryExpr.getRightExpression() : null;
        List<Expression> lhsExprs = tuple == null ? Collections.EMPTY_LIST : tuple.getExpressions();
        List<Expression> rhsExprs = rhs == null ? Collections.EMPTY_LIST : rhs.getExpressions();
        int i = 0;
        int lhsSize = lhsExprs.size();
        int rhsSize = rhsExprs.size();
        while (i < lhsSize) {
            ClassNode rhsType;
            Expression lhsExpr = lhsExprs.get(i);
            ClassNode classNode = rhsType = i < rhsSize ? rhsExprs.get(i).getType() : maybeType;
            if (lhsExpr instanceof VariableExpression) {
                VariableExpression var = (VariableExpression)lhsExpr;
                scope.addVariable(var.getName(), this.findVariableType(var, rhsType), null);
            }
            ++i;
        }
    }

    protected void handleSingleAssignment(Expression lhs, VariableScope scope, ClassNode rhsType) {
        if (lhs instanceof PropertyExpression) {
            lhs = ((PropertyExpression)lhs).getProperty();
            this.handleSingleAssignment(lhs, scope, rhsType);
        } else if (lhs instanceof VariableExpression) {
            VariableExpression var = (VariableExpression)lhs;
            if (scope.inScriptRunMethod() || scope.getEnclosingClosure() != null) {
                scope.updateOrAddVariable(var.getName(), this.findVariableType(var, rhsType), this.findDeclaringType(var));
            } else {
                scope.updateVariable(var.getName(), this.findVariableType(var, rhsType), this.findDeclaringType(var));
            }
            scope.getWormhole().put("lhs", lhs);
        } else if (lhs instanceof ConstantExpression) {
            scope.getWormhole().put("lhs", lhs);
        }
    }

    private boolean isInterestingOperation(BinaryExpression assign) {
        switch (assign.getOperation().getType()) {
            case 100: {
                return true;
            }
        }
        return false;
    }

    private boolean isObjectType(Expression init) {
        return init == null || VariableScope.OBJECT_CLASS_NODE.equals(init.getType());
    }

    private ClassNode findComponentType(ClassNode objectExpressionType) {
        if (objectExpressionType == null) {
            return VariableScope.OBJECT_CLASS_NODE;
        }
        return VariableScope.extractElementType(objectExpressionType);
    }

    private ClassNode findDeclaringType(VariableExpression var) {
        if (var.getAccessedVariable() instanceof AnnotatedNode) {
            return ((AnnotatedNode)((Object)var.getAccessedVariable())).getDeclaringClass();
        }
        return null;
    }

    private ClassNode findVariableType(VariableExpression var, ClassNode rhsType) {
        ClassNode varType = var.getOriginType();
        if (varType == null) {
            varType = var.getType();
        }
        if (varType != null && !VariableScope.isVoidOrObject(varType)) {
            return varType;
        }
        if (rhsType != null && !VariableScope.isVoidOrObject(rhsType)) {
            return rhsType;
        }
        return VariableScope.OBJECT_CLASS_NODE;
    }
}

