/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ClasspathJep247
extends ClasspathLocation {
    private FileSystem fs = null;
    private String release = null;
    private String[] subReleases = null;
    private Path releasePath = null;
    private File file = null;
    private Set<String> packageCache;

    public ClasspathJep247(File jdkHome, String release, AccessRuleSet accessRuleSet) {
        super(accessRuleSet, null);
        this.release = release;
        this.file = jdkHome;
    }

    @Override
    public List<FileSystem.Classpath> fetchLinkedJars(FileSystem.ClasspathSectionProblemReporter problemReporter) {
        return null;
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName) {
        return this.findClass(typeName, qualifiedPackageName, moduleName, qualifiedBinaryFileName, false);
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly) {
        if (!this.isPackage(qualifiedPackageName, moduleName)) {
            return null;
        }
        try {
            ClassFileReader reader = null;
            byte[] content = null;
            qualifiedBinaryFileName = qualifiedBinaryFileName.replace(".class", ".sig");
            if (this.subReleases != null && this.subReleases.length > 0) {
                String[] stringArray = this.subReleases;
                int n = this.subReleases.length;
                int n2 = 0;
                while (n2 < n) {
                    String rel = stringArray[n2];
                    Path p = this.fs.getPath(rel, qualifiedBinaryFileName);
                    if (!Files.exists(p, new LinkOption[0]) || (content = Files.readAllBytes(p)) == null) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            } else {
                content = Files.readAllBytes(this.fs.getPath(this.release, qualifiedBinaryFileName));
            }
            if (content != null) {
                reader = new ClassFileReader(content, qualifiedBinaryFileName.toCharArray());
                return new NameEnvironmentAnswer(reader, this.fetchAccessRestriction(qualifiedBinaryFileName), null);
            }
        }
        catch (ClassFormatException classFormatException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean hasAnnotationFileFor(String qualifiedTypeName) {
        return false;
    }

    @Override
    public char[][][] findTypeNames(String qualifiedPackageName, String moduleName) {
        return null;
    }

    @Override
    public void initialize() throws IOException {
        if (this.release == null) {
            return;
        }
        Path filePath = this.file.toPath().resolve("lib").resolve("ct.sym");
        URI t = filePath.toUri();
        if (!Files.exists(filePath, new LinkOption[0])) {
            return;
        }
        URI uri = URI.create("jar:file:" + t.getPath());
        try {
            this.fs = FileSystems.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
            // empty catch block
        }
        if (this.fs == null) {
            HashMap env = new HashMap();
            this.fs = FileSystems.newFileSystem(uri, env);
        }
        this.releasePath = this.fs.getPath("", new String[0]);
        if (!Files.exists(this.fs.getPath(this.release, new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException("release " + this.release + " is not found in the system");
        }
    }

    void acceptModule(ClassFileReader reader) {
    }

    protected void addToPackageCache(String packageName, boolean endsWithSep) {
        if (this.packageCache.contains(packageName)) {
            return;
        }
        this.packageCache.add(packageName);
    }

    @Override
    public synchronized char[][] getModulesDeclaringPackage(String qualifiedPackageName, String moduleName) {
        if (this.packageCache != null) {
            return this.singletonModuleNameIf(this.packageCache.contains(qualifiedPackageName));
        }
        this.packageCache = new HashSet<String>(41);
        this.packageCache.add(Util.EMPTY_STRING);
        ArrayList<String> sub = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.releasePath);){
                for (Path subdir : stream) {
                    String rel = subdir.getFileName().toString();
                    if (!rel.contains(this.release)) continue;
                    sub.add(rel);
                    Files.walkFileTree(subdir, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                            if (dir.getNameCount() <= 1) {
                                return FileVisitResult.CONTINUE;
                            }
                            Path relative = dir.subpath(1, dir.getNameCount());
                            ClasspathJep247.this.addToPackageCache(relative.toString(), false);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(Path f, BasicFileAttributes attrs) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFileFailed(Path f, IOException exc) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.subReleases = sub.toArray(new String[sub.size()]);
        return this.singletonModuleNameIf(this.packageCache.contains(qualifiedPackageName));
    }

    @Override
    public boolean hasCompilationUnit(String qualifiedPackageName, String moduleName) {
        return false;
    }

    @Override
    public void reset() {
        try {
            this.fs.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return "Classpath for JEP 247 for JDK " + this.file.getPath();
    }

    @Override
    public char[] normalizedPath() {
        if (this.normalizedPath == null) {
            String path2 = this.getPath();
            char[] rawName = path2.toCharArray();
            if (File.separatorChar == '\\') {
                CharOperation.replace(rawName, '\\', '/');
            }
            this.normalizedPath = CharOperation.subarray(rawName, 0, CharOperation.lastIndexOf('.', rawName));
        }
        return this.normalizedPath;
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            try {
                this.path = this.file.getCanonicalPath();
            }
            catch (IOException e) {
                this.path = this.file.getAbsolutePath();
            }
        }
        return this.path;
    }

    @Override
    public int getMode() {
        return 2;
    }

    @Override
    public IModule getModule() {
        return null;
    }
}

