/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.util;

import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.core.util.Util;

public class CompilerUtils {
    public static final int IsGrails = 1;
    public static final int InvokeDynamic = 2;

    public static void configureOptionsBasedOnNature(CompilerOptions options, IJavaProject javaProject) {
        if (javaProject == null) {
            options.buildGroovyFiles = 1;
            options.groovyFlags = 0;
            return;
        }
        IProject project = javaProject.getProject();
        try {
            if (CompilerUtils.isGroovyNaturedProject(project)) {
                options.groovyExcludeGlobalASTScan = project.getLocation().toOSString();
                options.groovyProjectName = project.getName();
                options.storeAnnotations = true;
                options.buildGroovyFiles = 2;
                options.groovyFlags = CompilerUtils.isProbablyGrailsProject(project) ? 1 : 0;
            } else {
                options.buildGroovyFiles = 1;
                options.groovyFlags = 0;
            }
        }
        catch (CoreException e) {
            options.buildGroovyFiles = 1;
            options.groovyFlags = 0;
        }
    }

    public static void configureOptionsBasedOnNature(Map<String, String> options, IJavaProject javaProject) {
        IProject project = javaProject.getProject();
        try {
            if (CompilerUtils.isGroovyNaturedProject(project)) {
                options.put("org.eclipse.jdt.core.compiler.groovy.groovyServiceScanExclude", project.getLocation().toOSString());
                options.put("org.eclipse.jdt.core.compiler.groovy.groovyProjectName", javaProject.getElementName());
                options.put("org.eclipse.jdt.core.compiler.groovy.buildGroovyFiles", "enabled");
                if (CompilerUtils.isProbablyGrailsProject(project)) {
                    options.put("org.eclipse.jdt.core.compiler.groovy.projectFlags", Integer.toString(1));
                } else {
                    options.put("org.eclipse.jdt.core.compiler.groovy.projectFlags", "0");
                }
            } else {
                options.put("org.eclipse.jdt.core.compiler.groovy.buildGroovyFiles", "disabled");
                options.put("org.eclipse.jdt.core.compiler.groovy.projectFlags", "0");
            }
        }
        catch (CoreException e) {
            Util.log(e, "configureOptionsBasedOnNature failed");
            options.put("org.eclipse.jdt.core.compiler.groovy.buildGroovyFiles", "disabled");
            options.put("org.eclipse.jdt.core.compiler.groovy.projectFlags", "0");
        }
    }

    private static boolean isGroovyNaturedProject(IProject project) throws CoreException {
        return project.hasNature("org.eclipse.jdt.groovy.core.groovyNature");
    }

    private static boolean isProbablyGrailsProject(IProject project) {
        try {
            IFolder folder = project.getFolder("grails-app");
            return folder.exists();
        }
        catch (Exception e) {
            return false;
        }
    }
}

