/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.LinkedHashSet;
import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.eclipse.jdt.groovy.search.VariableScope;

public enum AccessorSupport {
    GETTER("get"),
    SETTER("set"),
    ISSER("is"),
    NONE("");

    private final String prefix;

    private AccessorSupport(String prefix) {
        this.prefix = prefix;
    }

    public boolean isAccessor() {
        return this != NONE;
    }

    public boolean isAccessorKind(MethodNode node, boolean isCategory) {
        int args = isCategory ? 1 : 0;
        ClassNode returnType = node.getReturnType();
        switch (this) {
            case GETTER: {
                return (node.getParameters() == null || node.getParameters().length == args) && !returnType.equals(VariableScope.VOID_CLASS_NODE);
            }
            case SETTER: {
                return node.getParameters() != null && node.getParameters().length == args + 1 && (returnType.equals(VariableScope.VOID_CLASS_NODE) || returnType.equals(VariableScope.OBJECT_CLASS_NODE));
            }
            case ISSER: {
                return !isCategory && (node.getParameters() == null || node.getParameters().length == args) && returnType.equals(ClassHelper.boolean_TYPE);
            }
        }
        return false;
    }

    public String createAccessorName(String name) {
        if (!name.startsWith(AccessorSupport.GETTER.prefix) && !name.startsWith(AccessorSupport.SETTER.prefix) && name.length() > 0) {
            return String.valueOf(this.prefix) + Character.toUpperCase(name.charAt(0)) + (name.length() > 1 ? name.substring(1) : "");
        }
        return null;
    }

    public static AccessorSupport findAccessorKind(MethodNode node, boolean isCategory) {
        AccessorSupport accessor = AccessorSupport.create(node.getName(), isCategory);
        return accessor.isAccessorKind(node, isCategory) ? accessor : NONE;
    }

    public static MethodNode findAccessorMethodForPropertyName(String name, ClassNode declaringType, boolean isCategory) {
        return AccessorSupport.findAccessorMethodForPropertyName(name, declaringType, isCategory, GETTER, ISSER, SETTER);
    }

    public static MethodNode findAccessorMethodForPropertyName(String name, ClassNode declaringType, boolean isCategory, AccessorSupport ... kinds) {
        if (name != null && name.length() > 0 && kinds != null && kinds.length > 0) {
            String suffix = MetaClassHelper.capitalize(name);
            AccessorSupport[] accessorSupportArray = kinds;
            int n = kinds.length;
            int n2 = 0;
            while (n2 < n) {
                AccessorSupport kind = accessorSupportArray[n2];
                if (kind != NONE) {
                    String methodName = String.valueOf(kind.prefix) + suffix;
                    MethodNode meth = AccessorSupport.findAccessorMethodForMethodName(methodName, declaringType, isCategory, kind);
                    if (meth != null) {
                        return meth;
                    }
                    if (declaringType.isInterface() || declaringType.isAbstract()) {
                        LinkedHashSet<ClassNode> faces = new LinkedHashSet<ClassNode>();
                        VariableScope.findAllInterfaces(declaringType, faces, true);
                        faces.remove(declaringType);
                        for (ClassNode face : faces) {
                            meth = AccessorSupport.findAccessorMethodForMethodName(methodName, face, isCategory, kind);
                            if (meth == null) continue;
                            return meth;
                        }
                        if (!isCategory && kind == GETTER && methodName.equals("getClass")) {
                            return ClassHelper.OBJECT_TYPE.getMethod("getClass", Parameter.EMPTY_ARRAY);
                        }
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    private static MethodNode findAccessorMethodForMethodName(String name, ClassNode declaringType, boolean isCategory, AccessorSupport kind) {
        List<MethodNode> methods = declaringType.getMethods(name);
        for (MethodNode meth : methods) {
            if (kind != AccessorSupport.findAccessorKind(meth, isCategory)) continue;
            return meth;
        }
        return null;
    }

    public static boolean isGetter(MethodNode node) {
        return !node.isVoidMethod() && node.getParameters().length == 0 && (node.getName().startsWith("get") && node.getName().length() > 3 || node.getName().startsWith("is") && node.getName().length() > 2);
    }

    public static boolean isSetter(MethodNode node) {
        return node.getParameters().length == 1 && node.getName().startsWith("set") && node.getName().length() > 3;
    }

    public static AccessorSupport create(String methodName, boolean isCategory) {
        AccessorSupport accessor = NONE;
        if (!isCategory && methodName.length() > 2 && methodName.startsWith("is") && Character.isUpperCase(methodName.charAt(2))) {
            accessor = ISSER;
        }
        if (!accessor.isAccessor() && methodName.length() > 3 && (methodName.startsWith("get") || methodName.startsWith("set")) && Character.isUpperCase(methodName.charAt(3))) {
            accessor = methodName.charAt(0) == 'g' ? GETTER : SETTER;
        }
        return accessor;
    }
}

