/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.classgen.asm.OptimizingStatementWriter;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTMethodNode;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.AccessorSupport;
import org.eclipse.jdt.groovy.search.GenericsMapper;
import org.eclipse.jdt.groovy.search.ITypeLookupExtension;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.compiler.lookup.LazilyResolvedMethodBinding;

public class SimpleTypeLookup
implements ITypeLookupExtension {
    protected GroovyCompilationUnit unit;
    protected static final AccessorSupport[] READER = new AccessorSupport[]{AccessorSupport.GETTER, AccessorSupport.ISSER};
    protected static final AccessorSupport[] WRITER = new AccessorSupport[]{AccessorSupport.SETTER};

    @Override
    public void initialize(GroovyCompilationUnit unit, VariableScope topLevelScope) {
        this.unit = unit;
    }

    @Override
    public TypeLookupResult lookupType(Expression node, VariableScope scope, ClassNode objectExpressionType) {
        return this.lookupType(node, scope, objectExpressionType, false);
    }

    @Override
    public TypeLookupResult lookupType(Expression node, VariableScope scope, ClassNode objectExpressionType, boolean isStaticObjectExpression) {
        TypeLookupResult.TypeConfidence[] confidence = new TypeLookupResult.TypeConfidence[]{TypeLookupResult.TypeConfidence.EXACT};
        if (ClassHelper.isPrimitiveType(objectExpressionType)) {
            objectExpressionType = ClassHelper.getWrapper(objectExpressionType);
        }
        ClassNode declaringType = objectExpressionType != null ? objectExpressionType : this.findDeclaringType(node, scope, confidence);
        TypeLookupResult result = this.findType(node, declaringType, scope, confidence[0], isStaticObjectExpression || objectExpressionType == null && scope.isStatic(), objectExpressionType == null);
        return result;
    }

    @Override
    public TypeLookupResult lookupType(FieldNode node, VariableScope scope) {
        return new TypeLookupResult(node.getType(), node.getDeclaringClass(), node, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    @Override
    public TypeLookupResult lookupType(MethodNode node, VariableScope scope) {
        return new TypeLookupResult(node.getReturnType(), node.getDeclaringClass(), node, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    @Override
    public TypeLookupResult lookupType(AnnotationNode node, VariableScope scope) {
        ClassNode baseType = node.getClassNode();
        return new TypeLookupResult(baseType, baseType, baseType, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    @Override
    public TypeLookupResult lookupType(ImportNode node, VariableScope scope) {
        ClassNode baseType = node.getType();
        if (baseType != null) {
            return new TypeLookupResult(baseType, baseType, baseType, TypeLookupResult.TypeConfidence.EXACT, scope);
        }
        return new TypeLookupResult(VariableScope.OBJECT_CLASS_NODE, VariableScope.OBJECT_CLASS_NODE, VariableScope.OBJECT_CLASS_NODE, TypeLookupResult.TypeConfidence.INFERRED, scope);
    }

    @Override
    public TypeLookupResult lookupType(ClassNode node, VariableScope scope) {
        ClassNode resultType;
        if (node instanceof InnerClassNode && !node.isRedirectNode()) {
            resultType = node.getSuperClass();
            if (resultType.getName().equals(VariableScope.OBJECT_CLASS_NODE.getName()) && node.getInterfaces().length > 0) {
                resultType = node.getInterfaces()[0];
            }
        } else {
            resultType = node;
        }
        return new TypeLookupResult(resultType, resultType, node, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    @Override
    public TypeLookupResult lookupType(Parameter node, VariableScope scope) {
        VariableScope.VariableInfo info = scope.lookupNameInCurrentScope(node.getName());
        ClassNode type = info != null ? info.type : node.getType();
        return new TypeLookupResult(type, scope.getEnclosingTypeDeclaration(), node, TypeLookupResult.TypeConfidence.EXACT, scope);
    }

    @Override
    public void lookupInBlock(BlockStatement node, VariableScope scope) {
    }

    protected ClassNode findDeclaringType(Expression node, VariableScope scope, TypeLookupResult.TypeConfidence[] confidence) {
        Variable var;
        if (node instanceof ClassExpression || node instanceof ConstructorCallExpression) {
            return node.getType();
        }
        if (node instanceof FieldExpression) {
            return ((FieldExpression)node).getField().getDeclaringClass();
        }
        if (node instanceof StaticMethodCallExpression) {
            return ((StaticMethodCallExpression)node).getOwnerType();
        }
        if (node instanceof ConstantExpression && scope.isMethodCall()) {
            ClassNode ownerType = scope.getEnclosingClosure() != null ? SimpleTypeLookup.getBaseDeclaringType(scope.getOwner()) : scope.getEnclosingTypeDeclaration();
            return ownerType;
        }
        if (node instanceof VariableExpression && (var = ((VariableExpression)node).getAccessedVariable()) != null && !(var instanceof Parameter) && !(var instanceof VariableExpression)) {
            ClassNode ownerType = scope.getEnclosingClosure() != null ? SimpleTypeLookup.getBaseDeclaringType(scope.getOwner()) : scope.getEnclosingTypeDeclaration();
            return ownerType;
        }
        return VariableScope.OBJECT_CLASS_NODE;
    }

    protected TypeLookupResult findType(Expression node, ClassNode declaringType, VariableScope scope, TypeLookupResult.TypeConfidence confidence, boolean isStaticObjectExpression, boolean isPrimaryExpression) {
        MethodNode target;
        if (scope.isMethodCall() && (target = SimpleTypeLookup.getMethodTarget(node)) != null) {
            return new TypeLookupResult(target.getReturnType(), target.getDeclaringClass(), target, confidence, scope);
        }
        if (node instanceof VariableExpression) {
            return this.findTypeForVariable((VariableExpression)node, scope, confidence, declaringType);
        }
        if (node instanceof ConstantExpression && isPrimaryExpression && scope.isMethodCall()) {
            VariableExpression expr = new VariableExpression(new DynamicVariable(node.getText(), false));
            TypeLookupResult result = this.findTypeForVariable(expr, scope, confidence, declaringType);
            if (SimpleTypeLookup.isCompatible((AnnotatedNode)result.declaration, isStaticObjectExpression)) {
                return result;
            }
            if (isStaticObjectExpression) {
                return this.findTypeForVariable(expr, scope, confidence, VariableScope.newClassClassNode(declaringType));
            }
        }
        ClassNode nodeType = node.getType();
        if (node instanceof ConstantExpression) {
            if (!isPrimaryExpression) {
                if (scope.getEnclosingNode() instanceof AttributeExpression) {
                    ClassNode clazz = !isStaticObjectExpression ? declaringType : declaringType.getGenericsTypes()[0].getType();
                    FieldNode field = clazz.getDeclaredField(node.getText());
                    if (SimpleTypeLookup.isCompatible(field, isStaticObjectExpression)) {
                        return new TypeLookupResult(field.getType(), clazz, field, TypeLookupResult.TypeConfidence.EXACT, scope);
                    }
                    return new TypeLookupResult(VariableScope.VOID_CLASS_NODE, clazz, null, TypeLookupResult.TypeConfidence.UNKNOWN, scope);
                }
                return this.findTypeForNameWithKnownObjectExpression(node.getText(), nodeType, declaringType, scope, confidence, isStaticObjectExpression, isPrimaryExpression, scope.getWormhole().remove("lhs") == node);
            }
            ConstantExpression cexp = (ConstantExpression)node;
            if (cexp.isNullExpression()) {
                return new TypeLookupResult(VariableScope.VOID_CLASS_NODE, null, null, confidence, scope);
            }
            if (cexp.isTrueExpression() || cexp.isFalseExpression()) {
                return new TypeLookupResult(VariableScope.BOOLEAN_CLASS_NODE, null, null, confidence, scope);
            }
            if (cexp.isEmptyStringExpression() || VariableScope.STRING_CLASS_NODE.equals(nodeType)) {
                return new TypeLookupResult(VariableScope.STRING_CLASS_NODE, null, node, confidence, scope);
            }
            if (ClassHelper.isNumberType(nodeType) || VariableScope.BIG_DECIMAL_CLASS.equals(nodeType) || VariableScope.BIG_INTEGER_CLASS.equals(nodeType)) {
                return new TypeLookupResult(ClassHelper.isPrimitiveType(nodeType) ? ClassHelper.getWrapper(nodeType) : nodeType, null, null, confidence, scope);
            }
            return new TypeLookupResult(nodeType, null, null, TypeLookupResult.TypeConfidence.UNKNOWN, scope);
        }
        if (node instanceof BooleanExpression) {
            return new TypeLookupResult(VariableScope.BOOLEAN_CLASS_NODE, null, null, confidence, scope);
        }
        if (node instanceof GStringExpression) {
            return new TypeLookupResult(VariableScope.STRING_CLASS_NODE, null, null, confidence, scope);
        }
        if (node instanceof BitwiseNegationExpression) {
            ClassNode type = ((BitwiseNegationExpression)node).getExpression().getType();
            if (VariableScope.STRING_CLASS_NODE.equals(type)) {
                return new TypeLookupResult(VariableScope.PATTERN_CLASS_NODE, null, null, confidence, scope);
            }
            return new TypeLookupResult(type, null, null, confidence, scope);
        }
        if (node instanceof ClosureExpression && VariableScope.isPlainClosure(nodeType)) {
            ClassNode returnType = (ClassNode)node.getNodeMetaData("returnType");
            if (returnType != null && !VariableScope.isVoidOrObject(returnType)) {
                GroovyUtils.updateClosureWithInferredTypes(nodeType, returnType, ((ClosureExpression)node).getParameters());
            }
        } else {
            if (node instanceof ClassExpression) {
                ClassNode classType = VariableScope.newClassClassNode(node.getType());
                classType.setSourcePosition(node);
                return new TypeLookupResult(classType, null, node.getType(), TypeLookupResult.TypeConfidence.EXACT, scope);
            }
            if (node instanceof ConstructorCallExpression) {
                ConstructorCallExpression constructorCall = (ConstructorCallExpression)node;
                MethodNode constructorDecl = scope.getEnclosingMethodDeclaration();
                if (constructorCall.isThisCall()) {
                    declaringType = constructorDecl != null ? constructorDecl.getDeclaringClass() : scope.getEnclosingTypeDeclaration();
                } else if (constructorCall.isSuperCall()) {
                    declaringType = constructorDecl != null ? constructorDecl.getDeclaringClass().getUnresolvedSuperClass() : scope.getEnclosingTypeDeclaration();
                }
                List<ConstructorNode> declaredConstructors = declaringType.getDeclaredConstructors();
                if (constructorCall.getArguments() instanceof ArgumentListExpression && declaredConstructors.size() > 1) {
                    ArrayList<ConstructorNode> looseMatches = new ArrayList<ConstructorNode>();
                    List<ClassNode> callTypes = scope.getMethodCallArgumentTypes();
                    for (ConstructorNode ctor : declaredConstructors) {
                        if (callTypes.size() != ctor.getParameters().length) continue;
                        if (Boolean.TRUE.equals(SimpleTypeLookup.isTypeCompatible(callTypes, ctor.getParameters()))) {
                            return new TypeLookupResult(nodeType, declaringType, ctor, confidence, scope);
                        }
                        looseMatches.add(ctor);
                    }
                    if (!looseMatches.isEmpty()) {
                        declaredConstructors = looseMatches;
                    }
                }
                ClassNode declaration = !declaredConstructors.isEmpty() ? (ASTNode)declaredConstructors.get(0) : declaringType;
                return new TypeLookupResult(nodeType, declaringType, declaration, confidence, scope);
            }
            if (node instanceof StaticMethodCallExpression) {
                String methodName = ((StaticMethodCallExpression)node).getMethod();
                ClassNode ownerType = ((StaticMethodCallExpression)node).getOwnerType();
                LinkedList<MethodNode> candidates = new LinkedList<MethodNode>();
                if (!ownerType.isInterface()) {
                    candidates.addAll(ownerType.getMethods(methodName));
                } else {
                    LinkedHashSet<ClassNode> faces = new LinkedHashSet<ClassNode>();
                    VariableScope.findAllInterfaces(ownerType, faces, false);
                    for (ClassNode face : faces) {
                        candidates.addAll(face.getMethods(methodName));
                    }
                }
                Iterator it = candidates.iterator();
                while (it.hasNext()) {
                    if (((MethodNode)it.next()).isStatic()) continue;
                    it.remove();
                }
                if (!candidates.isEmpty()) {
                    MethodNode closestMatch;
                    if (scope.isMethodCall()) {
                        closestMatch = this.findMethodDeclaration0(candidates, scope.getMethodCallArgumentTypes(), isStaticObjectExpression);
                        confidence = TypeLookupResult.TypeConfidence.INFERRED;
                    } else {
                        closestMatch = (MethodNode)candidates.get(0);
                        confidence = TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
                    }
                    return new TypeLookupResult(closestMatch.getReturnType(), closestMatch.getDeclaringClass(), closestMatch, confidence, scope);
                }
            }
        }
        if (!(node instanceof TupleExpression) && nodeType.equals(VariableScope.OBJECT_CLASS_NODE)) {
            confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
        }
        return new TypeLookupResult(nodeType, declaringType, null, confidence, scope);
    }

    protected TypeLookupResult findTypeForNameWithKnownObjectExpression(String name, ClassNode type, ClassNode declaringType, VariableScope scope, TypeLookupResult.TypeConfidence confidence, boolean isStaticObjectExpression, boolean isPrimaryExpression, boolean isLhsExpression) {
        ClassNode typeParam;
        VariableScope.VariableInfo variableInfo;
        ClassNode realDeclaringType;
        TypeLookupResult.TypeConfidence confidence0 = confidence;
        boolean isFieldAccessDirect = SimpleTypeLookup.isThisObjectExpression(scope) ? scope.isFieldAccessDirect() : false;
        ASTNode declaration = this.findDeclaration(name, declaringType, isLhsExpression, isStaticObjectExpression, isFieldAccessDirect, scope.getMethodCallArgumentTypes());
        if (declaration != null) {
            type = SimpleTypeLookup.getTypeFromDeclaration(declaration, declaringType);
            realDeclaringType = SimpleTypeLookup.getDeclaringTypeFromDeclaration(declaration, declaringType);
        } else if ("this".equals(name)) {
            type = realDeclaringType = declaringType.getGenericsTypes()[0].getType();
            declaration = realDeclaringType;
        } else if (isPrimaryExpression && (variableInfo = scope.lookupName(name)) != null) {
            type = variableInfo.type;
            realDeclaringType = variableInfo.declaringType;
            declaration = this.findDeclaration(name, realDeclaringType, isLhsExpression, isStaticObjectExpression, false, scope.getMethodCallArgumentTypes());
            if (declaration == null) {
                declaration = variableInfo.declaringType;
            }
        } else if ("call".equals(name)) {
            realDeclaringType = VariableScope.CLOSURE_CLASS_NODE;
            declaration = realDeclaringType.getMethods("call").get(0);
        } else {
            realDeclaringType = declaringType;
            confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
        }
        if (declaration != null) {
            if (!VariableScope.CLASS_CLASS_NODE.equals(realDeclaringType) && !VariableScope.CLASS_CLASS_NODE.equals(type)) {
                if (declaration instanceof FieldNode) {
                    if (isStaticObjectExpression && !((FieldNode)declaration).isStatic()) {
                        confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                    }
                } else if (declaration instanceof PropertyNode) {
                    FieldNode underlyingField = ((PropertyNode)declaration).getField();
                    if (underlyingField != null) {
                        if (isStaticObjectExpression && !underlyingField.isStatic()) {
                            confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                        }
                    } else if (isStaticObjectExpression && !((PropertyNode)declaration).isStatic()) {
                        confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                    }
                } else if (declaration instanceof MethodNode) {
                    if (isStaticObjectExpression && !((MethodNode)declaration).isStatic()) {
                        confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                    } else if (SimpleTypeLookup.isLooseMatch(scope.getMethodCallArgumentTypes(), ((MethodNode)declaration).getParameters())) {
                        confidence = TypeLookupResult.TypeConfidence.LOOSELY_INFERRED;
                    }
                }
            } else if (VariableScope.CLASS_CLASS_NODE.equals(realDeclaringType) && declaration instanceof MethodNode && isStaticObjectExpression && !((MethodNode)declaration).isStatic() && SimpleTypeLookup.isLooseMatch(scope.getMethodCallArgumentTypes(), ((MethodNode)declaration).getParameters())) {
                confidence = TypeLookupResult.TypeConfidence.UNKNOWN;
            }
        }
        if (confidence == TypeLookupResult.TypeConfidence.UNKNOWN && VariableScope.CLASS_CLASS_NODE.equals(realDeclaringType) && realDeclaringType.isUsingGenerics() && !VariableScope.CLASS_CLASS_NODE.equals(typeParam = realDeclaringType.getGenericsTypes()[0].getType()) && !VariableScope.OBJECT_CLASS_NODE.equals(typeParam)) {
            return this.findTypeForNameWithKnownObjectExpression(name, type, typeParam, scope, confidence0, isStaticObjectExpression, isPrimaryExpression, isLhsExpression);
        }
        return new TypeLookupResult(type, realDeclaringType, declaration, confidence, scope);
    }

    protected TypeLookupResult findTypeForVariable(VariableExpression var, VariableScope scope, TypeLookupResult.TypeConfidence confidence, ClassNode declaringType) {
        boolean direct;
        ASTNode decl = var;
        ClassNode type = var.getType();
        TypeLookupResult.TypeConfidence newConfidence = confidence;
        Variable accessedVar = var.getAccessedVariable();
        VariableScope.VariableInfo variableInfo = scope.lookupName(var.getName());
        int resolveStrategy = scope.getEnclosingClosureResolveStrategy();
        boolean bl = direct = accessedVar instanceof AnnotatedNode && declaringType.equals(((AnnotatedNode)((Object)accessedVar)).getDeclaringClass());
        if (accessedVar instanceof FieldNode && (!direct || !scope.isFieldAccessDirect()) || direct && resolveStrategy != 0 && resolveStrategy != 2) {
            accessedVar = new DynamicVariable(var.getName(), scope.isStatic());
        }
        if (accessedVar instanceof ASTNode) {
            decl = (ASTNode)((Object)accessedVar);
            if (decl instanceof FieldNode || decl instanceof MethodNode || decl instanceof PropertyNode) {
                declaringType = ((AnnotatedNode)decl).getDeclaringClass();
                type = SimpleTypeLookup.getTypeFromDeclaration(decl, declaringType);
                variableInfo = null;
            }
        } else if (accessedVar instanceof DynamicVariable) {
            ASTNode candidate = this.findDeclarationForDynamicVariable(var, SimpleTypeLookup.getMorePreciseType(declaringType, variableInfo), scope, resolveStrategy);
            if (candidate != null) {
                decl = candidate;
                declaringType = SimpleTypeLookup.getDeclaringTypeFromDeclaration(decl, variableInfo != null ? variableInfo.declaringType : VariableScope.OBJECT_CLASS_NODE);
                type = SimpleTypeLookup.getTypeFromDeclaration(decl, declaringType);
            } else {
                newConfidence = TypeLookupResult.TypeConfidence.UNKNOWN;
                type = VariableScope.OBJECT_CLASS_NODE;
                if (variableInfo != null && !scope.inScriptRunMethod()) {
                    variableInfo = null;
                }
            }
        }
        if (variableInfo != null && !(decl instanceof MethodNode)) {
            type = variableInfo.type;
            if (VariableScope.isThisOrSuper(var)) {
                decl = type;
            }
            declaringType = SimpleTypeLookup.getMorePreciseType(declaringType, variableInfo);
            newConfidence = TypeLookupResult.TypeConfidence.findLessPrecise(confidence, TypeLookupResult.TypeConfidence.INFERRED);
        }
        return new TypeLookupResult(type, declaringType, decl, newConfidence, scope);
    }

    protected ASTNode findDeclarationForDynamicVariable(VariableExpression var, ClassNode owner, VariableScope scope, int resolveStrategy) {
        boolean isLhsExpr;
        ASTNode candidate = null;
        List<ClassNode> callArgs = scope.getMethodCallArgumentTypes();
        boolean bl = isLhsExpr = scope.getWormhole().remove("lhs") == var;
        if (resolveStrategy == 1 || resolveStrategy == 3) {
            candidate = this.findDeclaration(var.getName(), scope.getDelegate(), isLhsExpr, false, false, callArgs);
        }
        if (candidate == null && resolveStrategy < 3) {
            VariableScope outer = (VariableScope)owner.getNodeMetaData("outer.scope");
            if (outer != null) {
                VariableScope.CallAndType cat;
                if (isLhsExpr) {
                    scope.getWormhole().put("lhs", var);
                }
                int enclosingResolveStrategy = (cat = outer.getEnclosingMethodCallExpression()) == null ? 0 : cat.getResolveStrategy(outer.getEnclosingClosure());
                candidate = this.findDeclarationForDynamicVariable(var, SimpleTypeLookup.getBaseDeclaringType(outer.getOwner()), outer, enclosingResolveStrategy);
            } else {
                candidate = this.findDeclaration(var.getName(), owner, isLhsExpr, scope.isOwnerStatic(), scope.isFieldAccessDirect(), callArgs);
            }
            if (candidate == null && resolveStrategy < 1 && scope.getEnclosingClosure() != null) {
                candidate = this.findDeclaration(var.getName(), scope.getDelegate(), isLhsExpr, false, false, callArgs);
            }
        }
        if (!(candidate != null || resolveStrategy > 1 && resolveStrategy != 4 || resolveStrategy <= 0 && scope.getEnclosingClosure() == null)) {
            candidate = this.findDeclaration(var.getName(), VariableScope.CLOSURE_CLASS_NODE, isLhsExpr, false, false, callArgs);
        }
        return candidate;
    }

    protected ASTNode findDeclaration(String name, ClassNode declaringType, boolean isLhsExpression, boolean isStaticExpression, boolean directFieldAccess, List<ClassNode> methodCallArgumentTypes) {
        ASTNode declaration;
        MethodNode method;
        if (declaringType.isArray()) {
            if (name.equals("length")) {
                return SimpleTypeLookup.createLengthField(declaringType);
            }
            return this.findDeclaration(name, VariableScope.OBJECT_CLASS_NODE, isLhsExpression, isStaticExpression, directFieldAccess, methodCallArgumentTypes);
        }
        if (methodCallArgumentTypes != null && SimpleTypeLookup.isCompatible(method = this.findMethodDeclaration(name, declaringType, methodCallArgumentTypes, isStaticExpression), isStaticExpression)) {
            return method;
        }
        MethodNode accessor = AccessorSupport.findAccessorMethodForPropertyName(name, declaringType, false, !isLhsExpression ? READER : WRITER);
        if (!(accessor == null || SimpleTypeLookup.isSynthetic(accessor) || accessor.isStatic() != isStaticExpression || directFieldAccess && declaringType.equals(accessor.getDeclaringClass()))) {
            return accessor;
        }
        LinkedHashSet<ClassNode> typeHierarchy = new LinkedHashSet<ClassNode>();
        VariableScope.createTypeHierarchy(declaringType, typeHierarchy, true);
        for (ClassNode type : typeHierarchy) {
            PropertyNode property = type.getProperty(name);
            if (!SimpleTypeLookup.isCompatible(property, isStaticExpression)) continue;
            return property;
        }
        FieldNode field = declaringType.getField(name);
        if (SimpleTypeLookup.isCompatible(field, isStaticExpression)) {
            return field;
        }
        typeHierarchy.clear();
        VariableScope.findAllInterfaces(declaringType, typeHierarchy, true);
        for (ClassNode type : typeHierarchy) {
            if (type == declaringType || (field = type.getField(name)) == null || !field.isFinal() || !field.isStatic()) continue;
            return field;
        }
        if (SimpleTypeLookup.isCompatible(accessor, isStaticExpression)) {
            return accessor;
        }
        if (SimpleTypeLookup.getBaseDeclaringType(declaringType).getOuterClass() != null && (declaration = this.findDeclaration(name, SimpleTypeLookup.getBaseDeclaringType(declaringType).getOuterClass(), isLhsExpression, isStaticExpression |= (declaringType.getModifiers() & 8) != 0, directFieldAccess, methodCallArgumentTypes)) != null) {
            return declaration;
        }
        if (methodCallArgumentTypes == null) {
            return this.findMethodDeclaration(name, declaringType, methodCallArgumentTypes, isStaticExpression);
        }
        return null;
    }

    protected MethodNode findMethodDeclaration(String name, ClassNode declaringType, List<ClassNode> argumentTypes, boolean isStaticExpression) {
        if (!declaringType.isInterface() && !declaringType.isAbstract()) {
            List<MethodNode> candidates = declaringType.getMethods(name);
            if (!candidates.isEmpty()) {
                return this.findMethodDeclaration0(candidates, argumentTypes, isStaticExpression);
            }
            return null;
        }
        LinkedHashSet<ClassNode> types = new LinkedHashSet<ClassNode>();
        if (!declaringType.isInterface()) {
            types.add(declaringType);
        }
        VariableScope.findAllInterfaces(declaringType, types, true);
        types.add(VariableScope.OBJECT_CLASS_NODE);
        MethodNode outerCandidate = null;
        for (ClassNode type : types) {
            MethodNode innerCandidate = null;
            List<MethodNode> candidates = type.getMethods(name);
            if (!candidates.isEmpty()) {
                innerCandidate = this.findMethodDeclaration0(candidates, argumentTypes, isStaticExpression);
                if (outerCandidate == null) {
                    outerCandidate = innerCandidate;
                }
            }
            if (innerCandidate == null || argumentTypes == null) continue;
            Parameter[] methodParameters = innerCandidate.getParameters();
            if (argumentTypes.isEmpty() && methodParameters.length == 0) {
                return innerCandidate;
            }
            if (argumentTypes.size() != methodParameters.length) continue;
            outerCandidate = innerCandidate;
            Boolean suitable = SimpleTypeLookup.isTypeCompatible(argumentTypes, methodParameters);
            if (Boolean.FALSE.equals(suitable) || !Boolean.TRUE.equals(suitable)) continue;
            return innerCandidate;
        }
        return outerCandidate;
    }

    protected MethodNode findMethodDeclaration0(List<MethodNode> candidates, List<ClassNode> argumentTypes, boolean isStaticExpression) {
        int argumentCount = argumentTypes == null ? -1 : argumentTypes.size();
        Predicate<MethodNode> compatible = mn -> !isStaticExpression || mn.isStatic();
        MethodNode closestMatch = candidates.stream().filter(compatible).findFirst().orElse(candidates.get(0));
        for (MethodNode candidate : candidates) {
            Parameter[] parameters = candidate.getParameters();
            if (parameters.length == 0 && argumentCount == 0) {
                return candidate.getOriginal();
            }
            if (parameters.length != argumentCount) continue;
            Boolean suitable = SimpleTypeLookup.isTypeCompatible(argumentTypes, parameters);
            if (Boolean.TRUE.equals(suitable)) {
                return candidate.getOriginal();
            }
            if (Boolean.FALSE.equals(suitable) && closestMatch.getParameters().length == argumentCount) continue;
            closestMatch = candidate.getOriginal();
        }
        return closestMatch;
    }

    protected static ASTNode createLengthField(ClassNode declaringType) {
        FieldNode lengthField = new FieldNode("length", 1, VariableScope.INTEGER_CLASS_NODE, declaringType, null);
        lengthField.setType(VariableScope.INTEGER_CLASS_NODE);
        lengthField.setDeclaringClass(declaringType);
        return lengthField;
    }

    protected static ClassNode getBaseDeclaringType(ClassNode declaringType) {
        ClassNode typeParam;
        if (VariableScope.CLASS_CLASS_NODE.equals(declaringType) && !VariableScope.CLASS_CLASS_NODE.equals(typeParam = declaringType.getGenericsTypes()[0].getType()) && !VariableScope.OBJECT_CLASS_NODE.equals(typeParam)) {
            declaringType = typeParam;
        }
        return declaringType;
    }

    protected static MethodNode getMethodTarget(Expression expr) {
        if (expr instanceof MethodCallExpression) {
            MethodNode target = ((MethodCallExpression)expr).getMethodTarget();
            return target;
        }
        OptimizingStatementWriter.StatementMeta meta = (OptimizingStatementWriter.StatementMeta)expr.getNodeMetaData(OptimizingStatementWriter.StatementMeta.class);
        if (meta != null) {
            MethodNode target = (MethodNode)ReflectionUtils.getPrivateField(OptimizingStatementWriter.StatementMeta.class, "target", meta);
            return target;
        }
        return null;
    }

    protected static ClassNode getMorePreciseType(ClassNode declaringType, VariableScope.VariableInfo info) {
        ClassNode maybeDeclaringType;
        ClassNode classNode = maybeDeclaringType = info != null ? info.declaringType : VariableScope.OBJECT_CLASS_NODE;
        if (maybeDeclaringType.equals(VariableScope.OBJECT_CLASS_NODE) && !VariableScope.OBJECT_CLASS_NODE.equals(declaringType)) {
            return declaringType;
        }
        return maybeDeclaringType;
    }

    protected static ClassNode getTypeFromDeclaration(ASTNode declaration, ClassNode resolvedType) {
        ClassNode typeOfDeclaration;
        FieldNode field;
        if (declaration instanceof PropertyNode && (field = ((PropertyNode)declaration).getField()) != null) {
            declaration = field;
        }
        if (declaration instanceof FieldNode) {
            FieldNode fieldNode = (FieldNode)declaration;
            typeOfDeclaration = fieldNode.getType();
            if (VariableScope.OBJECT_CLASS_NODE.equals(typeOfDeclaration) && fieldNode.hasInitialExpression()) {
                typeOfDeclaration = fieldNode.getInitialExpression().getType();
            }
        } else {
            typeOfDeclaration = declaration instanceof MethodNode ? ((MethodNode)declaration).getReturnType() : (declaration instanceof Expression ? ((Expression)declaration).getType() : VariableScope.OBJECT_CLASS_NODE);
        }
        return typeOfDeclaration;
    }

    protected static ClassNode getDeclaringTypeFromDeclaration(ASTNode declaration, ClassNode resolvedTypeOfDeclaration) {
        ClassNode typeOfDeclaration = declaration instanceof FieldNode ? ((FieldNode)declaration).getDeclaringClass() : (declaration instanceof MethodNode ? ((MethodNode)declaration).getDeclaringClass() : (declaration instanceof PropertyNode ? ((PropertyNode)declaration).getDeclaringClass() : VariableScope.OBJECT_CLASS_NODE));
        if (typeOfDeclaration.getName().equals(resolvedTypeOfDeclaration.getName())) {
            return resolvedTypeOfDeclaration;
        }
        return typeOfDeclaration;
    }

    protected static boolean isThisObjectExpression(VariableScope scope) {
        VariableExpression objExp;
        ASTNode node = scope.getEnclosingNode();
        return node instanceof PropertyExpression && ((PropertyExpression)node).getObjectExpression() instanceof VariableExpression && (objExp = (VariableExpression)((PropertyExpression)node).getObjectExpression()).isThisExpression();
    }

    protected static boolean isCompatible(AnnotatedNode declaration, boolean isStaticExpression) {
        if (declaration != null) {
            boolean isStatic = false;
            if (declaration instanceof FieldNode) {
                isStatic = ((FieldNode)declaration).isStatic();
            } else if (declaration instanceof MethodNode) {
                isStatic = ((MethodNode)declaration).isStatic();
            } else if (declaration instanceof PropertyNode) {
                isStatic = ((PropertyNode)declaration).isStatic();
            }
            if (!isStaticExpression || isStatic || VariableScope.CLASS_CLASS_NODE.equals(declaration.getDeclaringClass()) || VariableScope.OBJECT_CLASS_NODE.equals(declaration.getDeclaringClass())) {
                return true;
            }
        }
        return false;
    }

    protected static boolean isSynthetic(MethodNode method) {
        return method.isSynthetic() || method.getDeclaringClass().equals(VariableScope.CLOSURE_CLASS_NODE) || method instanceof JDTMethodNode && ((JDTMethodNode)method).getJdtBinding() instanceof LazilyResolvedMethodBinding;
    }

    protected static boolean isLooseMatch(List<ClassNode> arguments, Parameter[] parameters) {
        ClassNode lastType;
        int argCount;
        int n = argCount = arguments == null ? -1 : arguments.size();
        if (parameters.length != argCount && (!GenericsMapper.isVargs(parameters) || parameters.length - 1 != argCount && parameters.length >= argCount)) {
            return true;
        }
        return argCount > 0 && arguments.get(argCount - 1).equals(VariableScope.CLOSURE_CLASS_NODE) && !(lastType = GroovyUtils.getBaseType(parameters[parameters.length - 1].getType())).equals(VariableScope.CLOSURE_CLASS_NODE);
    }

    protected static Boolean isTypeCompatible(List<ClassNode> arguments, Parameter[] parameters) {
        Boolean result = Boolean.TRUE;
        int i = 0;
        int n = parameters.length;
        while (i < n) {
            ClassNode parameter = parameters[i].getType();
            ClassNode argument = arguments.get(i);
            Boolean partialResult = SimpleTypeLookup.isTypeCompatible(argument, parameter);
            if (partialResult == null) {
                result = null;
            } else if (!partialResult.booleanValue()) {
                result = Boolean.FALSE;
                break;
            }
            ++i;
        }
        return result;
    }

    protected static Boolean isTypeCompatible(ClassNode source, ClassNode target) {
        Boolean result = Boolean.TRUE;
        if (!target.equals(source) && (source != VariableScope.NULL_TYPE || target.isPrimitive())) {
            result = !GroovyUtils.isAssignable(source, target) ? Boolean.FALSE : null;
        }
        return result;
    }
}

