/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;

class JrtFileSystem {
    private final Map<String, String> packageToModule = new HashMap<String, String>();
    private final Map<String, List<String>> packageToModules = new HashMap<String, List<String>>();
    FileSystem jrtSystem = null;

    public JrtFileSystem(File jrt) throws IOException {
        this.initialize(jrt);
    }

    void initialize(File jrt) throws IOException {
        URL jrtPath = null;
        String jdkHome = null;
        if (jrt.toString().endsWith("jrt-fs.jar")) {
            jrtPath = jrt.toPath().toUri().toURL();
            jdkHome = jrt.getParentFile().getParent();
        } else {
            jdkHome = jrt.toPath().toString();
            jrtPath = Paths.get(jdkHome, "lib", "jrt-fs.jar").toUri().toURL();
        }
        JRTUtil.MODULE_TO_LOAD = System.getProperty("modules.to.load");
        String javaVersion = System.getProperty("java.version");
        if (javaVersion != null && javaVersion.startsWith("1.8")) {
            JRTUtil.MODULE_TO_LOAD = System.getProperty("modules.to.load");
            URLClassLoader loader = new URLClassLoader(new URL[]{jrtPath});
            HashMap env = new HashMap();
            this.jrtSystem = FileSystems.newFileSystem(JRTUtil.JRT_URI, env, (ClassLoader)loader);
        } else {
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("java.home", jdkHome);
            this.jrtSystem = FileSystems.newFileSystem(JRTUtil.JRT_URI, env);
        }
        this.walkModuleImage(null, true, 0);
    }

    public List<String> getModulesDeclaringPackage(String qualifiedPackageName, String moduleName) {
        List<String> list;
        qualifiedPackageName = qualifiedPackageName.replace('.', '/');
        String module = this.packageToModule.get(qualifiedPackageName);
        if (moduleName == null) {
            if (module == null) {
                return null;
            }
            if (module == "MU") {
                return this.packageToModules.get(qualifiedPackageName);
            }
            return Collections.singletonList(module);
        }
        if (module != null && (module == "MU" ? (list = this.packageToModules.get(qualifiedPackageName)).contains(moduleName) : module.equals(moduleName))) {
            return Collections.singletonList(moduleName);
        }
        return null;
    }

    public String[] getModules(String fileName) {
        int idx = fileName.lastIndexOf(47);
        String pack = null;
        pack = idx != -1 ? fileName.substring(0, idx) : "";
        String module = this.packageToModule.get(pack);
        if (module != null) {
            if (module == "MU") {
                List<String> list = this.packageToModules.get(pack);
                return list.toArray(new String[list.size()]);
            }
            return new String[]{module};
        }
        return JRTUtil.DEFAULT_MODULE;
    }

    public boolean hasClassFile(String qualifiedPackageName, String module) {
        if (module == null) {
            return false;
        }
        String knownModule = this.packageToModule.get(qualifiedPackageName);
        if (knownModule == null || knownModule != "MU" && !knownModule.equals(module)) {
            return false;
        }
        Path packagePath = this.jrtSystem.getPath("/modules", module, qualifiedPackageName);
        if (!Files.exists(packagePath, new LinkOption[0])) {
            return false;
        }
        try {
            return Files.list(packagePath).anyMatch(filePath -> filePath.toString().endsWith(".class") || filePath.toString().endsWith(".CLASS"));
        }
        catch (IOException e) {
            return false;
        }
    }

    public InputStream getContentFromJrt(String fileName, String module) throws IOException {
        String[] modules;
        if (module != null) {
            return Files.newInputStream(this.jrtSystem.getPath("/modules", module, fileName), new OpenOption[0]);
        }
        String[] stringArray = modules = this.getModules(fileName);
        if (modules.length != 0) {
            String mod = stringArray[0];
            return Files.newInputStream(this.jrtSystem.getPath("/modules", mod, fileName), new OpenOption[0]);
        }
        return null;
    }

    private ClassFileReader getClassfile(String fileName) throws IOException, ClassFormatException {
        String[] modules = this.getModules(fileName);
        byte[] content = null;
        String module = null;
        String[] stringArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            String mod = stringArray[n2];
            content = JRTUtil.safeReadBytes(this.jrtSystem.getPath("/modules", mod, fileName));
            if (content != null) {
                module = mod;
                break;
            }
            ++n2;
        }
        if (content != null) {
            ClassFileReader reader = new ClassFileReader(content, fileName.toCharArray());
            reader.moduleName = module.toCharArray();
            return reader;
        }
        return null;
    }

    byte[] getClassfileContent(String fileName, String module) throws IOException, ClassFormatException {
        byte[] content = null;
        if (module != null) {
            content = this.getClassfileBytes(fileName, new String(module.toCharArray()));
        } else {
            String[] modules;
            String[] stringArray = modules = this.getModules(fileName);
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                String mod = stringArray[n2];
                content = JRTUtil.safeReadBytes(this.jrtSystem.getPath("/modules", mod, fileName));
                if (content != null) break;
                ++n2;
            }
        }
        return content;
    }

    private byte[] getClassfileBytes(String fileName, String module) throws IOException, ClassFormatException {
        return JRTUtil.safeReadBytes(this.jrtSystem.getPath("/modules", module, fileName));
    }

    public ClassFileReader getClassfile(String fileName, String module) throws IOException, ClassFormatException {
        ClassFileReader reader = null;
        if (module == null) {
            reader = this.getClassfile(fileName);
        } else {
            byte[] content = this.getClassfileBytes(fileName, module);
            if (content != null) {
                reader = new ClassFileReader(content, fileName.toCharArray());
                reader.moduleName = module.toCharArray();
            }
        }
        return reader;
    }

    public ClassFileReader getClassfile(String fileName, IModule module) throws IOException, ClassFormatException {
        ClassFileReader reader = null;
        if (module == null) {
            reader = this.getClassfile(fileName);
        } else {
            byte[] content = this.getClassfileBytes(fileName, new String(module.name()));
            if (content != null) {
                reader = new ClassFileReader(content, fileName.toCharArray());
            }
        }
        return reader;
    }

    void walkModuleImage(final JRTUtil.JrtFileVisitor<Path> visitor, boolean visitPackageMapping, final int notify) throws IOException {
        Iterable<Path> roots = this.jrtSystem.getRootDirectories();
        for (Path path : roots) {
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                    for (final Path subdir : stream) {
                        if (subdir.toString().equals("/modules")) {
                            if (visitPackageMapping) continue;
                            Files.walkFileTree(subdir, (FileVisitor<? super Path>)new JRTUtil.AbstractFileVisitor<Path>(){

                                @Override
                                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                    int count = dir.getNameCount();
                                    if (count == 2) {
                                        Path mod = dir.getName(1);
                                        if (JRTUtil.MODULE_TO_LOAD != null && JRTUtil.MODULE_TO_LOAD.length() > 0 && JRTUtil.MODULE_TO_LOAD.indexOf(mod.toString()) == -1) {
                                            return FileVisitResult.SKIP_SUBTREE;
                                        }
                                        return (notify & JRTUtil.NOTIFY_MODULES) == 0 ? FileVisitResult.CONTINUE : visitor.visitModule(mod);
                                    }
                                    if (dir == subdir || count < 3 || (notify & JRTUtil.NOTIFY_PACKAGES) == 0) {
                                        return FileVisitResult.CONTINUE;
                                    }
                                    return visitor.visitPackage(dir.subpath(2, count), dir.getName(1), attrs);
                                }

                                @Override
                                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                    if ((notify & JRTUtil.NOTIFY_FILES) == 0) {
                                        return FileVisitResult.CONTINUE;
                                    }
                                    int count = file.getNameCount();
                                    if (count == 3) {
                                        JrtFileSystem.this.cachePackage("", file.getName(1).toString());
                                    }
                                    return visitor.visitFile(file.subpath(2, file.getNameCount()), file.getName(1), attrs);
                                }
                            });
                            continue;
                        }
                        if (!visitPackageMapping) continue;
                        Files.walkFileTree(subdir, (FileVisitor<? super Path>)new JRTUtil.AbstractFileVisitor<Path>(){

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                Path relative = subdir.relativize(file);
                                JrtFileSystem.this.cachePackage(relative.getParent().toString(), relative.getFileName().toString());
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    void cachePackage(String packageName, String module) {
        packageName = packageName.intern();
        module = module.intern();
        String current = this.packageToModule.get(packageName = packageName.replace('.', '/'));
        if (current == null) {
            this.packageToModule.put(packageName, module);
        } else {
            if (current == module || current.equals(module)) {
                return;
            }
            if (current == "MU") {
                List<String> list = this.packageToModules.get(packageName);
                if (!list.contains(module)) {
                    if ("java.base" == module || "java.base".equals(module)) {
                        list.add(0, "java.base");
                    } else {
                        list.add(module);
                    }
                }
            } else {
                String first = current;
                this.packageToModule.put(packageName, "MU");
                ArrayList<String> list = new ArrayList<String>();
                if ("java.base" == current || "java.base".equals(current)) {
                    list.add(first);
                    list.add(module);
                } else {
                    list.add(module);
                    list.add(first);
                }
                this.packageToModules.put(packageName, list);
            }
        }
    }
}

