/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.LinkedHashSet;
import java.util.stream.Stream;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.GenericsMapper;
import org.eclipse.jdt.groovy.search.SimpleTypeLookup;
import org.eclipse.jdt.groovy.search.VariableScope;

public enum AccessorSupport {
    GETTER("get"),
    SETTER("set"),
    ISSER("is"),
    NONE("");

    private final String prefix;

    private AccessorSupport(String prefix) {
        this.prefix = prefix;
    }

    public boolean isAccessor() {
        return this != NONE;
    }

    public boolean isAccessorKind(MethodNode node, boolean isCategory) {
        Parameter[] parameters = node.getParameters();
        switch (this) {
            case GETTER: {
                return (parameters == null || parameters.length == (!isCategory ? 0 : 1)) && !node.isVoidMethod();
            }
            case SETTER: {
                return parameters != null && parameters.length == (!isCategory ? 1 : 2) && (!isCategory || !GenericsMapper.isVargs(parameters));
            }
            case ISSER: {
                return (parameters == null || parameters.length == (!isCategory ? 0 : 1)) && ClassHelper.boolean_TYPE == ClassHelper.getUnwrapper(node.getReturnType());
            }
        }
        return false;
    }

    public String createAccessorName(String name) {
        if (this.isAccessor() && !name.isEmpty() && !name.startsWith(AccessorSupport.GETTER.prefix) && !name.startsWith(AccessorSupport.SETTER.prefix)) {
            return String.valueOf(this.prefix) + Character.toUpperCase(name.charAt(0)) + (name.length() > 1 ? name.substring(1) : "");
        }
        return null;
    }

    public static AccessorSupport create(String methodName, boolean isCategory) {
        AccessorSupport accessor = NONE;
        AccessorSupport[] accessorSupportArray = AccessorSupport.values();
        int n = accessorSupportArray.length;
        int n2 = 0;
        while (n2 < n) {
            AccessorSupport kind = accessorSupportArray[n2];
            if (kind.isAccessor() && methodName.startsWith(kind.prefix) && methodName.length() > kind.prefix.length() && Character.isUpperCase(methodName.charAt(kind.prefix.length()))) {
                accessor = kind;
                break;
            }
            ++n2;
        }
        return accessor;
    }

    public static AccessorSupport findAccessorKind(MethodNode node, boolean isCategory) {
        AccessorSupport accessor = AccessorSupport.create(node.getName(), isCategory);
        return accessor.isAccessorKind(node, isCategory) ? accessor : NONE;
    }

    public static MethodNode findAccessorMethodForPropertyName(String name, ClassNode declaringType, boolean isCategory) {
        return AccessorSupport.findAccessorMethodForPropertyName(name, declaringType, isCategory, GETTER, ISSER, SETTER);
    }

    public static MethodNode findAccessorMethodForPropertyName(String name, ClassNode declaringType, boolean isCategory, AccessorSupport ... kinds) {
        return AccessorSupport.findAccessorMethodsForPropertyName(name, declaringType, isCategory, kinds).findFirst().orElse(null);
    }

    public static Stream<MethodNode> findAccessorMethodsForPropertyName(String name, ClassNode declaringType, boolean isCategory, AccessorSupport ... kinds) {
        Stream<MethodNode> methods = Stream.empty();
        if (name != null && name.length() > 0 && kinds != null && kinds.length > 0) {
            String suffix = MetaClassHelper.capitalize(name);
            AccessorSupport[] accessorSupportArray = kinds;
            int n = kinds.length;
            int n2 = 0;
            while (n2 < n) {
                AccessorSupport kind = accessorSupportArray[n2];
                if (kind != NONE) {
                    String methodName = String.valueOf(kind.prefix) + suffix;
                    methods = Stream.concat(methods, AccessorSupport.findAccessorMethodsForMethodName(methodName, declaringType, isCategory, kind));
                    if (declaringType.isAbstract() || declaringType.isInterface() || GroovyUtils.implementsTrait(declaringType)) {
                        LinkedHashSet<ClassNode> faces = new LinkedHashSet<ClassNode>();
                        VariableScope.findAllInterfaces(declaringType, faces, true);
                        faces.remove(declaringType);
                        for (ClassNode face : faces) {
                            methods = Stream.concat(methods, AccessorSupport.findAccessorMethodsForMethodName(methodName, face, isCategory, kind));
                        }
                        if (!isCategory && kind == GETTER && "getClass".equals(methodName)) {
                            methods = Stream.concat(methods, Stream.of(ClassHelper.OBJECT_TYPE.getMethod("getClass", Parameter.EMPTY_ARRAY)));
                        }
                    }
                }
                ++n2;
            }
        }
        return methods;
    }

    private static Stream<MethodNode> findAccessorMethodsForMethodName(String name, ClassNode declaringType, boolean isCategory, AccessorSupport kind) {
        return SimpleTypeLookup.getMethods(name, declaringType).stream().filter(meth -> kind == AccessorSupport.findAccessorKind(meth, isCategory));
    }

    public static boolean isGetter(MethodNode node) {
        return !node.isVoidMethod() && node.getParameters().length == 0 && (node.getName().startsWith("get") && node.getName().length() > 3 || node.getName().startsWith("is") && node.getName().length() > 2);
    }

    public static boolean isSetter(MethodNode node) {
        return node.getParameters().length == 1 && node.getName().startsWith("set") && node.getName().length() > 3;
    }
}

