/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler;

import groovy.lang.GroovyClassLoader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.xbean.classloader.NonLockingJarFileClassLoader;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.runtime.m12n.ExtensionModuleScanner;
import org.codehaus.groovy.runtime.m12n.SimpleExtensionModule;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyParser;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;

public final class GroovyClassLoaderFactory {
    private static Map<String, Map.Entry<IClasspathEntry[], GroovyClassLoader[]>> projectClassLoaderCache = new ConcurrentHashMap<String, Map.Entry<IClasspathEntry[], GroovyClassLoader[]>>();
    private GroovyClassLoader batchLoader;
    private final CompilerOptions compilerOptions;
    private final LookupEnvironment lookupEnvironment;
    private static final boolean NONLOCKING = Boolean.getBoolean("greclipse.nonlocking");

    static {
        if (NONLOCKING) {
            System.out.println("property set: greclipse.nonlocking: will try to avoid locking jars");
        }
    }

    public static void clearCache() {
        projectClassLoaderCache.clear();
    }

    public static void clearCache(String projectName) {
        Map.Entry<IClasspathEntry[], GroovyClassLoader[]> entry = projectClassLoaderCache.remove(projectName);
        if (entry != null) {
            Stream.of(entry.getValue()).filter(Objects::nonNull).forEach(GroovyClassLoaderFactory::close);
        }
    }

    private static void close(ClassLoader classLoader) {
        if (classLoader instanceof Closeable) {
            try {
                ((Closeable)((Object)classLoader)).close();
            }
            catch (IOException e) {
                Util.log(e);
            }
        }
        if (classLoader instanceof GroovyClassLoader) {
            ((GroovyClassLoader)classLoader).clearCache();
        }
        if (classLoader.getParent() instanceof URLClassLoader) {
            GroovyClassLoaderFactory.close(classLoader.getParent());
        }
    }

    public GroovyClassLoaderFactory(CompilerOptions compilerOptions, Object requestor) {
        this.compilerOptions = compilerOptions;
        this.lookupEnvironment = requestor instanceof Compiler ? ((Compiler)requestor).lookupEnvironment : null;
    }

    public GroovyClassLoader[] getGroovyClassLoaders(CompilerConfiguration compilerConfiguration) {
        if (this.compilerOptions.groovyProjectName == null) {
            return this.getBatchGroovyClassLoaders(compilerConfiguration);
        }
        return this.getProjectGroovyClassLoaders(compilerConfiguration);
    }

    private GroovyClassLoader[] getBatchGroovyClassLoaders(CompilerConfiguration compilerConfiguration) {
        if (this.batchLoader == null && this.lookupEnvironment != null) {
            try {
                FileSystem.Classpath[] classpaths;
                INameEnvironment nameEnvironment = this.lookupEnvironment.nameEnvironment;
                if (nameEnvironment.getClass().getName().endsWith("tests.compiler.regression.InMemoryNameEnvironment")) {
                    nameEnvironment = ((INameEnvironment[])ReflectionUtils.getPrivateField(nameEnvironment.getClass(), "classLibs", nameEnvironment))[0];
                }
                if (nameEnvironment instanceof FileSystem && (classpaths = (FileSystem.Classpath[])ReflectionUtils.getPrivateField(FileSystem.class, "classpaths", nameEnvironment)) != null) {
                    this.batchLoader = new GroovyClassLoader();
                    FileSystem.Classpath[] classpathArray = classpaths;
                    int n = classpaths.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FileSystem.Classpath classpath = classpathArray[n2];
                        this.batchLoader.addClasspath(classpath.getPath());
                        ++n2;
                    }
                }
            }
            catch (Exception e) {
                Util.log(e, "Unexpected problem computing classpath for batch compiler");
            }
        }
        return new GroovyClassLoader[]{new GrapeAwareGroovyClassLoader(this.batchLoader, compilerConfiguration), this.batchLoader};
    }

    private GroovyClassLoader[] getProjectGroovyClassLoaders(CompilerConfiguration compilerConfiguration) {
        String projectName = this.compilerOptions.groovyProjectName;
        IProject project = GroovyClassLoaderFactory.findProject(projectName);
        try {
            IJavaProject javaProject = JavaCore.create(project);
            Object[] classpathEntries = javaProject.exists() ? javaProject.getResolvedClasspath(true) : new IClasspathEntry[]{};
            Map.Entry entry = projectClassLoaderCache.computeIfAbsent(projectName, arg_0 -> GroovyClassLoaderFactory.lambda$2(javaProject, (IClasspathEntry[])classpathEntries, compilerConfiguration, arg_0));
            if (Arrays.equals(classpathEntries, (Object[])entry.getKey())) {
                return (GroovyClassLoader[])entry.getValue();
            }
            projectClassLoaderCache.remove(projectName);
            return this.getProjectGroovyClassLoaders(compilerConfiguration);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to bootstrap GroovyClassLoaders for project '" + projectName + "'", e);
        }
    }

    private static IProject findProject(String projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    private static void calculateClasspath(IJavaProject javaProject, Set<String> classPaths, Set<String> xformPaths) {
        try {
            IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)javaProject);
            Arrays.sort(entries, Comparator.comparing(IRuntimeClasspathEntry::getType));
            IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IRuntimeClasspathEntry unresolved = iRuntimeClasspathEntryArray[n2];
                Set<String> paths = unresolved.getType() == 4 ? classPaths : xformPaths;
                IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray2 = GroovyClassLoaderFactory.resolveRuntimeClasspathEntry(unresolved, javaProject);
                int n3 = iRuntimeClasspathEntryArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IRuntimeClasspathEntry resolved = iRuntimeClasspathEntryArray2[n4];
                    paths.add(GroovyClassLoaderFactory.getAbsoluteLocation(resolved));
                    ++n4;
                }
                ++n2;
            }
            classPaths.addAll(xformPaths);
            assert (classPaths.stream().allMatch(path -> new File((String)path).isAbsolute()));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry classpathEntry, IJavaProject javaProject) throws Exception {
        return (IRuntimeClasspathEntry[])ReflectionUtils.throwableExecutePrivateMethod(JavaRuntime.class, "resolveRuntimeClasspathEntry", new Class[]{IRuntimeClasspathEntry.class, IJavaProject.class}, JavaRuntime.class, new Object[]{classpathEntry, javaProject});
    }

    private static String getAbsoluteLocation(IRuntimeClasspathEntry classpathEntry) {
        String location = classpathEntry.getLocation();
        Path path = new Path(location);
        if (!path.toFile().exists()) {
            IProject project = GroovyClassLoaderFactory.findProject(path.segment(0));
            IResource resource = path.segmentCount() == 1 ? project : project.getFile(path.removeFirstSegments(1));
            IPath rawLocation = resource.getRawLocation();
            if (rawLocation != null) {
                location = rawLocation.toOSString();
            } else if (resource.getLocation() != null) {
                location = resource.getLocation().toOSString();
            }
        }
        return location;
    }

    private static URLClassLoader newClassLoader(Set<String> classpath, ClassLoader parent) {
        URL[] urls = (URL[])classpath.stream().map(file -> {
            try {
                return new File((String)file).toURI().toURL();
            }
            catch (MalformedURLException ignore) {
                return null;
            }
        }).filter(Objects::nonNull).toArray(URL[]::new);
        if (NONLOCKING) {
            if (parent == null) {
                parent = URLClassLoader.newInstance(new URL[0], null);
            }
            return new NonLockingJarFileClassLoader("GDT non-locking loader", urls, parent);
        }
        return URLClassLoader.newInstance(urls, parent);
    }

    private static /* synthetic */ Map.Entry lambda$2(IJavaProject iJavaProject, IClasspathEntry[] iClasspathEntryArray, CompilerConfiguration compilerConfiguration, String key) {
        LinkedHashSet<String> classPaths = new LinkedHashSet<String>();
        LinkedHashSet<String> xformPaths = new LinkedHashSet<String>();
        if (iJavaProject.exists()) {
            GroovyClassLoaderFactory.calculateClasspath(iJavaProject, classPaths, xformPaths);
        }
        if (GroovyLogManager.manager.hasLoggers()) {
            GroovyLogManager.manager.log(TraceCategory.AST_TRANSFORM, "Transform classpath: " + String.join((CharSequence)File.pathSeparator, xformPaths));
        }
        ClassLoader parentClassLoader = null;
        if (classPaths.stream().anyMatch(path -> path.endsWith("jrt-fs.jar"))) {
            parentClassLoader = GroovyParser.class.getClassLoader();
        }
        return new AbstractMap.SimpleEntry<IClasspathEntry[], GroovyClassLoader[]>(iClasspathEntryArray, new GroovyClassLoader[]{new GrapeAwareGroovyClassLoader(GroovyClassLoaderFactory.newClassLoader(classPaths, parentClassLoader), compilerConfiguration), new GroovyClassLoader(GroovyClassLoaderFactory.newClassLoader(xformPaths, GroovyParser.class.getClassLoader()))});
    }

    public static class GrapeAwareGroovyClassLoader
    extends GroovyClassLoader {
        public boolean grabbed;
        private volatile Set<Class> defaultCategories;
        private volatile Set<Class> defaultStaticCategories;

        public GrapeAwareGroovyClassLoader(ClassLoader parent, CompilerConfiguration config) {
            super(parent, config);
        }

        @Override
        public void addURL(URL url) {
            this.grabbed = true;
            super.addURL(url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<Class> getDefaultCategories() {
            if (this.defaultCategories == null) {
                GrapeAwareGroovyClassLoader grapeAwareGroovyClassLoader = this;
                synchronized (grapeAwareGroovyClassLoader) {
                    block7: {
                        if (this.defaultCategories == null) {
                            LinkedHashSet<Class> objectCategories = new LinkedHashSet<Class>();
                            LinkedHashSet<Class> staticCategories = new LinkedHashSet<Class>();
                            try {
                                Class<?> dgm2 = this.loadClass("org.codehaus.groovy.runtime.DefaultGroovyMethods");
                                Class<?> dgsm = this.loadClass("org.codehaus.groovy.runtime.DefaultGroovyStaticMethods");
                                Collections.addAll(objectCategories, (Class[])dgm2.getField("DGM_LIKE_CLASSES").get(dgm2));
                                staticCategories.add(dgsm);
                                new ExtensionModuleScanner(module -> {
                                    if (module instanceof SimpleExtensionModule) {
                                        objectCategories.addAll(((SimpleExtensionModule)module).getInstanceMethodsExtensionClasses());
                                        staticCategories.addAll(((SimpleExtensionModule)module).getStaticMethodsExtensionClasses());
                                    }
                                }, this).scanClasspathModules();
                                objectCategories.addAll(staticCategories);
                                this.defaultCategories = objectCategories;
                                this.defaultStaticCategories = staticCategories;
                            }
                            catch (Exception e) {
                                this.defaultCategories = Collections.EMPTY_SET;
                                this.defaultStaticCategories = Collections.EMPTY_SET;
                                if (!GroovyLogManager.manager.hasLoggers()) break block7;
                                GroovyLogManager.manager.log(TraceCategory.CLASSPATH, "Failed to find Default Groovy Methods with " + this + "\n\t" + e.getMessage());
                            }
                        }
                    }
                }
            }
            return Collections.unmodifiableSet(this.defaultCategories);
        }

        public boolean isDefaultStaticCategory(String name) {
            if (this.defaultStaticCategories == null) {
                this.getDefaultCategories();
            }
            return this.defaultStaticCategories.stream().map(Class::getName).anyMatch(name::equals);
        }
    }
}

