/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.core.internal.dtree.DeltaDataTree;
import org.eclipse.core.internal.events.AutoBuildJob;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.internal.events.BuildContext;
import org.eclipse.core.internal.events.BuilderPersistentInfo;
import org.eclipse.core.internal.events.GraphProcessor;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.InternalBuilder;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.events.ResourceComparator;
import org.eclipse.core.internal.events.ResourceDelta;
import org.eclipse.core.internal.events.ResourceDeltaFactory;
import org.eclipse.core.internal.events.ResourceStats;
import org.eclipse.core.internal.resources.ComputeProjectOrder;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.WorkManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IBuildContext;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class BuildManager
implements ICoreConstants,
IManager,
ILifecycleListener {
    private static final String BUILDER_INIT = "BuilderInitInfo";
    private static final int TOTAL_BUILD_WORK = 100000;
    final AutoBuildJob autoBuildJob;
    private final Set<IProject> builtProjects = Collections.synchronizedSet(new HashSet());
    protected final Set<InternalBuilder> currentBuilders;
    private DeltaDataTree currentDelta;
    private ElementTree currentLastBuiltTree;
    private ElementTree currentTree;
    private final DeltaCache<IResourceDelta> deltaCache = new DeltaCache();
    private final DeltaCache<DeltaDataTree> deltaTreeCache = new DeltaCache();
    private ILock lock;
    private boolean rebuildRequested = false;
    private final Bundle systemBundle = Platform.getBundle("org.eclipse.osgi");
    private Object builderInitializationLock = new Object();
    private long timeStamp = -1L;
    private long overallTimeStamp = -1L;
    private Workspace workspace;

    public BuildManager(Workspace workspace, ILock workspaceLock) {
        this.workspace = workspace;
        this.currentBuilders = Collections.synchronizedSet(new HashSet());
        this.autoBuildJob = new AutoBuildJob(workspace);
        this.lock = workspaceLock;
        InternalBuilder.buildManager = this;
    }

    private void basicBuild(int trigger, IncrementalProjectBuilder builder, Map<String, String> args, MultiStatus status, IProgressMonitor monitor) {
        IncrementalProjectBuilder currentBuilder = builder;
        try {
            ISchedulingRule rule;
            int depth;
            boolean clean;
            block37: {
                this.currentBuilders.add(currentBuilder);
                currentBuilder.clearLastBuiltStateRequests();
                clean = trigger == 15;
                this.currentLastBuiltTree = currentBuilder.getLastBuiltTree();
                boolean isBuilding = builder.getCommand().isBuilding(trigger);
                if (!clean && this.currentLastBuiltTree == null) {
                    if (trigger == 9 && !isBuilding) {
                        return;
                    }
                    trigger = 6;
                    boolean bl = isBuilding = isBuilding || builder.getCommand().isBuilding(trigger);
                }
                if (!isBuilding) {
                    if (clean) {
                        currentBuilder.setLastBuiltTree(null);
                    }
                    return;
                }
                this.currentTree = trigger == 6 || clean ? null : this.workspace.getElementTree();
                depth = -1;
                rule = null;
                try {
                    if (this.needsBuild(currentBuilder, trigger)) break block37;
                    monitor.beginTask("", 1);
                    monitor.done();
                    if (depth >= 0) {
                        this.getWorkManager().endUnprotected(depth);
                    }
                    if (rule != null) {
                        Job.getJobManager().endRule(rule);
                    }
                    if (clean || currentBuilder.wasForgetStateRequested()) {
                        currentBuilder.setLastBuiltTree(null);
                    } else if (currentBuilder.wasRememberStateRequested()) {
                        if (trigger == 6) {
                            currentBuilder.setLastBuiltTree(null);
                        }
                    } else {
                        ElementTree lastTree = this.workspace.getElementTree();
                        lastTree.immutable();
                        currentBuilder.setLastBuiltTree(lastTree);
                    }
                    this.hookEndBuild(builder);
                    return;
                }
                catch (Throwable throwable) {
                    if (depth >= 0) {
                        this.getWorkManager().endUnprotected(depth);
                    }
                    if (rule != null) {
                        Job.getJobManager().endRule(rule);
                    }
                    if (clean || currentBuilder.wasForgetStateRequested()) {
                        currentBuilder.setLastBuiltTree(null);
                    } else if (currentBuilder.wasRememberStateRequested()) {
                        if (trigger == 6) {
                            currentBuilder.setLastBuiltTree(null);
                        }
                    } else {
                        ElementTree lastTree = this.workspace.getElementTree();
                        lastTree.immutable();
                        currentBuilder.setLastBuiltTree(lastTree);
                    }
                    this.hookEndBuild(builder);
                    throw throwable;
                }
            }
            rule = builder.getRule(trigger, args);
            String name = currentBuilder.getLabel();
            String message = name != null ? NLS.bind(Messages.events_invoking_2, name, builder.getProject().getFullPath()) : NLS.bind(Messages.events_invoking_1, builder.getProject().getFullPath());
            monitor.subTask(message);
            this.hookStartBuild(builder, trigger);
            if (rule != null && this.currentTree != null) {
                this.workspace.newWorkingTree();
            }
            depth = this.getWorkManager().beginUnprotected();
            if (rule != null) {
                Job.getJobManager().beginRule(rule, monitor);
                if (this.currentTree != null) {
                    this.currentTree = this.workspace.getElementTree();
                }
            }
            SafeRunner.run(this.getSafeRunnable(currentBuilder, trigger, args, status, monitor));
            if (depth >= 0) {
                this.getWorkManager().endUnprotected(depth);
            }
            if (rule != null) {
                Job.getJobManager().endRule(rule);
            }
            if (clean || currentBuilder.wasForgetStateRequested()) {
                currentBuilder.setLastBuiltTree(null);
            } else if (currentBuilder.wasRememberStateRequested()) {
                if (trigger == 6) {
                    currentBuilder.setLastBuiltTree(null);
                }
            } else {
                ElementTree lastTree = this.workspace.getElementTree();
                lastTree.immutable();
                currentBuilder.setLastBuiltTree(lastTree);
            }
            this.hookEndBuild(builder);
        }
        finally {
            this.currentBuilders.remove(currentBuilder);
            this.currentTree = null;
            this.currentLastBuiltTree = null;
            this.currentDelta = null;
        }
    }

    protected void basicBuild(IBuildConfiguration buildConfiguration, int trigger, IBuildContext context, ICommand[] commands, MultiStatus status, IProgressMonitor monitor) {
        try {
            int i = 0;
            while (i < commands.length) {
                this.checkCanceled(trigger, monitor);
                BuildCommand command = (BuildCommand)commands[i];
                IProgressMonitor sub = Policy.subMonitorFor(monitor, 1);
                IncrementalProjectBuilder builder = this.getBuilder(buildConfiguration, command, i, status, context);
                if (builder != null) {
                    this.basicBuild(trigger, builder, command.getArguments(false), status, sub);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
    }

    private IStatus basicBuild(IBuildConfiguration buildConfiguration, int trigger, IBuildContext context, IProgressMonitor monitor) {
        try {
            this.hookStartBuild(new IBuildConfiguration[]{buildConfiguration}, trigger);
            MultiStatus status = new MultiStatus("org.eclipse.core.resources", 566, Messages.events_errors, null);
            this.basicBuild(buildConfiguration, trigger, context, status, monitor);
            MultiStatus multiStatus = status;
            return multiStatus;
        }
        finally {
            this.hookEndBuild(trigger);
        }
    }

    private void basicBuild(final IBuildConfiguration buildConfiguration, final int trigger, final IBuildContext context, final MultiStatus status, final IProgressMonitor monitor) {
        try {
            final IProject project = buildConfiguration.getProject();
            final ICommand[] commands = project.isAccessible() ? ((Project)project).internalGetDescription().getBuildSpec(false) : null;
            int work = commands == null ? 0 : commands.length;
            monitor.beginTask(NLS.bind(Messages.events_building_1, project.getFullPath()), work);
            if (work == 0) {
                return;
            }
            ISafeRunnable code = new ISafeRunnable(){

                @Override
                public void handleException(Throwable e) {
                    if (e instanceof OperationCanceledException) {
                        if (Policy.DEBUG_BUILD_INVOKING) {
                            Policy.debug("Build canceled");
                        }
                        throw (OperationCanceledException)e;
                    }
                    String errorText = e.getMessage();
                    if (errorText == null) {
                        errorText = NLS.bind(Messages.events_unknown, e.getClass().getName(), project.getName());
                    }
                    status.add(new Status(2, "org.eclipse.core.resources", 566, errorText, e));
                }

                @Override
                public void run() throws Exception {
                    BuildManager.this.basicBuild(buildConfiguration, trigger, context, commands, status, monitor);
                }
            };
            SafeRunner.run(code);
        }
        finally {
            monitor.done();
        }
    }

    private IStatus basicBuild(IBuildConfiguration buildConfiguration, int trigger, String builderName, Map<String, String> args, IProgressMonitor monitor) {
        IProject project = buildConfiguration.getProject();
        monitor = Policy.monitorFor(monitor);
        try {
            String message = NLS.bind(Messages.events_building_1, project.getFullPath());
            monitor.beginTask(message, 1);
            try {
                this.hookStartBuild(new IBuildConfiguration[]{buildConfiguration}, trigger);
                MultiStatus status = new MultiStatus("org.eclipse.core.resources", 566, Messages.events_errors, null);
                ICommand command = this.getCommand(project, builderName, args);
                try {
                    BuildContext context = new BuildContext(buildConfiguration);
                    IncrementalProjectBuilder builder = this.getBuilder(buildConfiguration, command, -1, status, context);
                    if (builder != null) {
                        this.basicBuild(trigger, builder, args, status, Policy.subMonitorFor(monitor, 1));
                    }
                }
                catch (CoreException e) {
                    status.add(e.getStatus());
                }
                MultiStatus multiStatus = status;
                this.hookEndBuild(trigger);
                return multiStatus;
            }
            catch (Throwable throwable) {
                this.hookEndBuild(trigger);
                throw throwable;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void basicBuildLoop(IBuildConfiguration[] configs, IBuildConfiguration[] requestedConfigs, int trigger, MultiStatus status, IProgressMonitor monitor) {
        int projectWork = configs.length > 0 ? 100000 / configs.length : 0;
        int maxIterations = this.workspace.getDescription().getMaxBuildIterations();
        if (maxIterations <= 0) {
            maxIterations = 1;
        }
        this.rebuildRequested = true;
        int iter = 0;
        while (this.rebuildRequested && iter < maxIterations) {
            this.rebuildRequested = false;
            this.builtProjects.clear();
            IBuildConfiguration[] iBuildConfigurationArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildConfiguration config = iBuildConfigurationArray[n2];
                if (config.getProject().isAccessible()) {
                    BuildContext context = new BuildContext(config, requestedConfigs, configs);
                    this.basicBuild(config, trigger, context, status, Policy.subMonitorFor(monitor, projectWork));
                    this.builtProjects.add(config.getProject());
                }
                ++n2;
            }
            trigger = 10;
            ++iter;
        }
    }

    public IStatus build(IBuildConfiguration[] configs, IBuildConfiguration[] requestedConfigs, int trigger, IProgressMonitor monitor) {
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(Messages.events_building_0, 100000);
            try {
                this.hookStartBuild(configs, trigger);
                MultiStatus status = new MultiStatus("org.eclipse.core.resources", 75, Messages.events_errors, null);
                this.basicBuildLoop(configs, requestedConfigs, trigger, status, monitor);
                MultiStatus multiStatus = status;
                this.hookEndBuild(trigger);
                return multiStatus;
            }
            catch (Throwable throwable) {
                this.hookEndBuild(trigger);
                throw throwable;
            }
        }
        finally {
            this.endBuild(trigger, monitor);
        }
    }

    public IStatus buildParallel(ComputeProjectOrder.Digraph<IBuildConfiguration> configs, IBuildConfiguration[] requestedConfigs, int trigger, JobGroup buildJobGroup, IProgressMonitor monitor) {
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(Messages.events_building_0, 100000);
            try {
                this.builtProjects.clear();
                this.hookStartBuild((IBuildConfiguration[])configs.vertexList.stream().map(vertex -> (IBuildConfiguration)vertex.id).toArray(IBuildConfiguration[]::new), trigger);
                MultiStatus status = new MultiStatus("org.eclipse.core.resources", 75, Messages.events_errors, null);
                this.parallelBuildLoop(configs, requestedConfigs, trigger, buildJobGroup, status, monitor);
                MultiStatus multiStatus = status;
                this.hookEndBuild(trigger);
                return multiStatus;
            }
            catch (Throwable throwable) {
                this.hookEndBuild(trigger);
                throw throwable;
            }
        }
        finally {
            this.endBuild(trigger, monitor);
        }
    }

    private void endBuild(int trigger, IProgressMonitor monitor) {
        boolean cancelledBuild = monitor.isCanceled();
        monitor.done();
        if (trigger == 10 || trigger == 6) {
            this.autoBuildJob.avoidBuild();
        } else if (cancelledBuild) {
            this.autoBuildJob.avoidBuildIfNotInterrupted();
        }
    }

    private void parallelBuildLoop(ComputeProjectOrder.Digraph<IBuildConfiguration> configs, IBuildConfiguration[] requestedConfigs, int trigger, JobGroup buildJobGroup, MultiStatus status, IProgressMonitor monitor) {
        int projectWork = configs.vertexList.size() > 0 ? 100000 / configs.vertexList.size() : 0;
        this.builtProjects.clear();
        GraphProcessor<IBuildConfiguration> graphProcessor = new GraphProcessor<IBuildConfiguration>(configs, IBuildConfiguration.class, (config, graphCrawler) -> {
            BuildContext context = new BuildContext((IBuildConfiguration)config, requestedConfigs, (IBuildConfiguration[])graphCrawler.getSequentialOrder());
            try {
                this.workspace.prepareOperation(null, monitor);
                this.workspace.beginOperation(false);
                this.basicBuild((IBuildConfiguration)config, trigger, context, status, Policy.subMonitorFor(monitor, projectWork));
                this.workspace.endOperation(null, false);
                this.builtProjects.add(config.getProject());
            }
            catch (CoreException ex) {
                status.add(new Status(4, "org.eclipse.core.resources", ex.getMessage(), ex));
            }
        }, buildJobGroup);
        graphProcessor.processGraphWithParallelJobs();
        try {
            Job.getJobManager().join(graphProcessor, monitor);
        }
        catch (InterruptedException | OperationCanceledException e) {
            status.add(new Status(4, "org.eclipse.core.resources", e.getMessage(), e));
        }
    }

    public IStatus build(IBuildConfiguration buildConfiguration, int trigger, String builderName, Map<String, String> args, IProgressMonitor monitor) {
        monitor = Policy.monitorFor(monitor);
        if (builderName == null) {
            BuildContext context = new BuildContext(buildConfiguration);
            return this.basicBuild(buildConfiguration, trigger, context, monitor);
        }
        return this.basicBuild(buildConfiguration, trigger, builderName, args, monitor);
    }

    private void checkCanceled(int trigger, IProgressMonitor monitor) {
        if (this.systemBundle.getState() == 16) {
            throw new OperationCanceledException();
        }
        Policy.checkCanceled(monitor);
        if (trigger != 9) {
            return;
        }
        if (this.autoBuildJob.isInterrupted()) {
            throw new OperationCanceledException();
        }
    }

    public ArrayList<BuilderPersistentInfo> createBuildersPersistentInfo(IProject project) throws CoreException {
        ArrayList<BuilderPersistentInfo> oldInfos = this.getBuildersPersistentInfo(project);
        ProjectDescription desc = ((Project)project).internalGetDescription();
        ICommand[] commands = desc.getBuildSpec(false);
        if (commands.length == 0) {
            return null;
        }
        IBuildConfiguration[] configs = project.getBuildConfigs();
        ArrayList<BuilderPersistentInfo> newInfos = new ArrayList<BuilderPersistentInfo>(commands.length * configs.length);
        int i = 0;
        while (i < commands.length) {
            BuildCommand command = (BuildCommand)commands[i];
            String builderName = command.getBuilderName();
            boolean supportsConfigs = command.supportsConfigs();
            int numberConfigs = supportsConfigs ? configs.length : 1;
            int j = 0;
            while (j < numberConfigs) {
                ElementTree oldTree;
                IBuildConfiguration config = configs[j];
                BuilderPersistentInfo info = null;
                IncrementalProjectBuilder builder = ((BuildCommand)commands[i]).getBuilder(config);
                if (builder == null) {
                    if (oldInfos != null) {
                        info = this.getBuilderInfo(oldInfos, builderName, supportsConfigs ? config.getName() : null, i);
                    }
                } else if (!(builder instanceof MissingBuilder) && (oldTree = builder.getLastBuiltTree()) != null) {
                    info = new BuilderPersistentInfo(project.getName(), supportsConfigs ? config.getName() : null, builderName, i);
                    info.setLastBuildTree(oldTree);
                    info.setInterestingProjects(builder.getInterestingProjects());
                }
                if (info != null) {
                    newInfos.add(info);
                }
                ++j;
            }
            ++i;
        }
        return newInfos;
    }

    private String debugBuilder() {
        return this.currentBuilders == null ? "<no builder>" : this.currentBuilders.getClass().getName();
    }

    private String debugProject() {
        if (this.currentBuilders == null) {
            return "<no project>";
        }
        return "[" + this.currentBuilders.stream().map(builder -> builder.getProject().getFullPath().toString()).collect(Collectors.joining(",")) + "]";
    }

    private String debugTrigger(int trigger) {
        switch (trigger) {
            case 6: {
                return "FULL_BUILD";
            }
            case 15: {
                return "CLEAN_BUILD";
            }
        }
        return "INCREMENTAL_BUILD";
    }

    public void endTopLevel(boolean needsBuild) {
        this.autoBuildJob.build(needsBuild);
    }

    private boolean getBooleanAttribute(IConfigurationElement element, String name) {
        String valueString = element.getAttribute(name);
        return valueString != null && valueString.equalsIgnoreCase(Boolean.TRUE.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IncrementalProjectBuilder getBuilder(IBuildConfiguration buildConfiguration, ICommand command, int buildSpecIndex, MultiStatus status) throws CoreException {
        BuildCommand buildCommand = (BuildCommand)command;
        InternalBuilder result = buildCommand.getBuilder(buildConfiguration);
        String builderName = command.getBuilderName();
        IProject project = buildConfiguration.getProject();
        if (result == null) {
            BuilderPersistentInfo info;
            Object object = this.builderInitializationLock;
            synchronized (object) {
                BuilderPersistentInfo builderInitInProgress = this.getBuilderInitInfo(project, builderName);
                if (builderInitInProgress != null) {
                    info = builderInitInProgress;
                } else {
                    info = this.removePersistentBuilderInfo(builderName, buildConfiguration, buildSpecIndex);
                    this.setBuilderInitInfo(project, builderName, info);
                }
            }
            result = buildCommand.getBuilder(buildConfiguration);
            if (result == null) {
                result = this.initializeBuilder(command, builderName, buildConfiguration, info, status);
            }
            object = this.builderInitializationLock;
            synchronized (object) {
                IncrementalProjectBuilder other = buildCommand.getBuilder(buildConfiguration);
                if (other == null) {
                    buildCommand.addBuilder(buildConfiguration, (IncrementalProjectBuilder)result);
                } else {
                    result = other;
                }
                this.setBuilderInitInfo(project, builderName, null);
            }
        }
        result.setBuildConfig(buildConfiguration);
        if (!this.validateNature(result, builderName)) {
            result.setLastBuiltTree(null);
            return null;
        }
        return result;
    }

    private IncrementalProjectBuilder getBuilder(IBuildConfiguration buildConfiguration, ICommand command, int buildSpecIndex, MultiStatus status, IBuildContext context) throws CoreException {
        IncrementalProjectBuilder builder = this.getBuilder(buildConfiguration, command, buildSpecIndex, status);
        if (builder != null) {
            builder.setContext(context);
        }
        return builder;
    }

    private BuilderPersistentInfo getBuilderInfo(ArrayList<BuilderPersistentInfo> infos, String builderName, String configName, int buildSpecIndex) {
        BuilderPersistentInfo nameMatch = null;
        for (BuilderPersistentInfo info : infos) {
            if (!info.getBuilderName().equals(builderName) || info.getConfigName() != null && !info.getConfigName().equals(configName)) continue;
            if (nameMatch == null) {
                nameMatch = info;
            }
            if (buildSpecIndex != -1 && info.getBuildSpecIndex() != -1 && buildSpecIndex != info.getBuildSpecIndex()) continue;
            return info;
        }
        return nameMatch;
    }

    public ArrayList<BuilderPersistentInfo> getBuildersPersistentInfo(IProject project) throws CoreException {
        return (ArrayList)project.getSessionProperty(K_BUILD_LIST);
    }

    private ICommand getCommand(IProject project, String builderName, Map<String, String> args) {
        ICommand[] buildSpec;
        ICommand[] iCommandArray = buildSpec = ((Project)project).internalGetDescription().getBuildSpec(false);
        int n = buildSpec.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand element = iCommandArray[n2];
            if (element.getBuilderName().equals(builderName)) {
                return element;
            }
            ++n2;
        }
        BuildCommand result = new BuildCommand();
        result.setBuilderName(builderName);
        result.setArguments(args);
        return result;
    }

    IResourceDelta getDelta(IProject project) {
        try {
            IResourceDelta resultDelta;
            this.lock.acquire();
            if (this.currentTree == null) {
                if (Policy.DEBUG_BUILD_FAILURE) {
                    Policy.debug("Build: no tree for delta " + this.debugBuilder() + " [" + this.debugProject() + "]");
                }
                return null;
            }
            Set<InternalBuilder> interestedBuilders = this.getInterestedBuilders(project);
            if (interestedBuilders.isEmpty()) {
                if (Policy.DEBUG_BUILD_FAILURE) {
                    Policy.debug("Build: project not interesting for current builders " + this.debugBuilder() + " [" + this.debugProject() + "] " + project.getFullPath());
                }
                return null;
            }
            if (this.currentDelta != null && this.currentDelta.findNodeAt(project.getFullPath()) == null) {
                if (!project.exists()) {
                    return null;
                }
                IResourceDelta iResourceDelta = ResourceDeltaFactory.newEmptyDelta(project);
                return iResourceDelta;
            }
            IResourceDelta iResourceDelta = resultDelta = this.deltaCache.computeIfAbsent(project.getFullPath(), this.currentLastBuiltTree, this.currentTree, () -> {
                long startTime = 0L;
                if (Policy.DEBUG_BUILD_DELTA) {
                    startTime = System.currentTimeMillis();
                    Policy.debug("Computing delta for project: " + project.getName());
                }
                ResourceDelta result = ResourceDeltaFactory.computeDelta(this.workspace, this.currentLastBuiltTree, this.currentTree, project.getFullPath(), -1L);
                if (Policy.DEBUG_BUILD_FAILURE && result == null) {
                    Policy.debug("Build: no delta " + this.debugBuilder() + " [" + this.debugProject() + "] " + project.getFullPath());
                }
                if (Policy.DEBUG_BUILD_DELTA) {
                    Policy.debug("Finished computing delta, time: " + (System.currentTimeMillis() - startTime) + "ms" + result.toDeepDebugString());
                }
                return result;
            });
            return iResourceDelta;
        }
        finally {
            this.lock.release();
        }
    }

    private ISafeRunnable getSafeRunnable(final InternalBuilder currentBuilder, final int trigger, final Map<String, String> args, final MultiStatus status, final IProgressMonitor monitor) {
        return new ISafeRunnable(){

            @Override
            public void handleException(Throwable e) {
                if (e instanceof OperationCanceledException) {
                    if (Policy.DEBUG_BUILD_INVOKING) {
                        Policy.debug("Build canceled");
                    }
                    currentBuilder.forgetLastBuiltState();
                    throw (OperationCanceledException)e;
                }
                String builderName = currentBuilder.getLabel();
                if (builderName == null || builderName.length() == 0) {
                    builderName = currentBuilder.getClass().getName();
                }
                String pluginId = currentBuilder.getPluginId();
                String message = NLS.bind(Messages.events_builderError, builderName, currentBuilder.getProject().getName());
                status.add(new Status(4, pluginId, 75, message, e));
                if (e instanceof CoreException) {
                    status.add(((CoreException)e).getStatus());
                }
            }

            @Override
            public void run() throws Exception {
                IProject[] prereqs = null;
                if (trigger != 15) {
                    prereqs = currentBuilder.build(trigger, args, monitor);
                } else {
                    currentBuilder.clean(monitor);
                }
                if (prereqs == null) {
                    prereqs = new IProject[]{};
                }
                currentBuilder.setInterestingProjects((IProject[])prereqs.clone());
            }
        };
    }

    private WorkManager getWorkManager() {
        try {
            return this.workspace.getWorkManager();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    @Override
    public void handleEvent(LifecycleEvent event) {
        IProject project = null;
        switch (event.kind) {
            case 16: 
            case 64: {
                project = (IProject)event.resource;
                if (!project.isAccessible()) break;
                this.setBuildersPersistentInfo(project, null);
            }
        }
    }

    boolean hasBeenBuilt(IProject project) {
        return this.builtProjects.contains(project);
    }

    private void hookEndBuild(IncrementalProjectBuilder builder) {
        if (ResourceStats.TRACE_BUILDERS) {
            ResourceStats.endBuild();
        }
        if (!Policy.DEBUG_BUILD_INVOKING || this.timeStamp == -1L) {
            return;
        }
        Policy.debug("Builder finished: " + this.toString(builder) + " time: " + (System.currentTimeMillis() - this.timeStamp) + "ms");
        this.timeStamp = -1L;
    }

    private void hookEndBuild(int trigger) {
        this.builtProjects.clear();
        this.deltaCache.flush();
        this.deltaTreeCache.flush();
        if (trigger == 15) {
            this.autoBuildJob.forceBuild();
        }
        if (Policy.DEBUG_BUILD_INVOKING) {
            Policy.debug("Top-level build-end time: " + (System.currentTimeMillis() - this.overallTimeStamp));
            this.overallTimeStamp = -1L;
        }
    }

    private void hookStartBuild(IncrementalProjectBuilder builder, int trigger) {
        if (ResourceStats.TRACE_BUILDERS) {
            ResourceStats.startBuild(builder);
        }
        if (Policy.DEBUG_BUILD_INVOKING) {
            this.timeStamp = System.currentTimeMillis();
            Policy.debug("Invoking (" + this.debugTrigger(trigger) + ") on builder: " + this.toString(builder));
        }
    }

    private void hookStartBuild(IBuildConfiguration[] configs, int trigger) {
        if (Policy.DEBUG_BUILD_STACK) {
            Policy.debug(new RuntimeException("Starting build: " + this.debugTrigger(trigger)));
        }
        if (Policy.DEBUG_BUILD_INVOKING) {
            this.overallTimeStamp = System.currentTimeMillis();
            StringBuilder sb = new StringBuilder("Top-level build-start of: ");
            IBuildConfiguration[] iBuildConfigurationArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildConfiguration config = iBuildConfigurationArray[n2];
                sb.append(config).append(", ");
                ++n2;
            }
            sb.append(this.debugTrigger(trigger));
            Policy.debug(sb.toString());
        }
    }

    private InternalBuilder initializeBuilder(ICommand command, String builderName, IBuildConfiguration buildConfiguration, BuilderPersistentInfo info, MultiStatus status) {
        IProject project = buildConfiguration.getProject();
        IncrementalProjectBuilder builder = null;
        try {
            builder = this.instantiateBuilder(builderName);
        }
        catch (CoreException e) {
            status.add(new ResourceStatus(75, project.getFullPath(), NLS.bind(Messages.events_instantiate_1, builderName), (Throwable)e));
            status.add(e.getStatus());
        }
        if (builder == null) {
            builder = new MissingBuilder(builderName);
        }
        if (info != null) {
            ElementTree tree = info.getLastBuiltTree();
            if (tree != null) {
                builder.setLastBuiltTree(tree);
            }
            builder.setInterestingProjects(info.getInterestingProjects());
        }
        builder.setCommand(command);
        builder.setBuildConfig(buildConfiguration);
        ((InternalBuilder)builder).startupOnInitialize();
        return builder;
    }

    private BuilderPersistentInfo removePersistentBuilderInfo(String builderName, IBuildConfiguration buildConfiguration, int buildSpecIndex) throws CoreException {
        BuilderPersistentInfo info;
        IProject project = buildConfiguration.getProject();
        ArrayList<BuilderPersistentInfo> infos = this.getBuildersPersistentInfo(project);
        if (infos != null && (info = this.getBuilderInfo(infos, builderName, buildConfiguration.getName(), buildSpecIndex)) != null) {
            infos.remove(info);
            if (infos.isEmpty()) {
                this.setBuildersPersistentInfo(project, null);
            }
            return info;
        }
        return null;
    }

    private IncrementalProjectBuilder instantiateBuilder(String builderName) throws CoreException {
        IExtension extension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.resources", "builders", builderName);
        if (extension == null) {
            return null;
        }
        IConfigurationElement[] configs = extension.getConfigurationElements();
        if (configs.length == 0) {
            return null;
        }
        String natureId = null;
        if (this.getBooleanAttribute(configs[0], "hasNature")) {
            String builderId = extension.getUniqueIdentifier();
            natureId = this.workspace.getNatureManager().findNatureForBuilder(builderId);
            if (natureId == null) {
                return null;
            }
        }
        InternalBuilder builder = (InternalBuilder)configs[0].createExecutableExtension("run");
        builder.setPluginId(extension.getContributor().getName());
        builder.setLabel(extension.getLabel());
        builder.setNatureId(natureId);
        builder.setCallOnEmptyDelta(this.getBooleanAttribute(configs[0], "callOnEmptyDelta"));
        return (IncrementalProjectBuilder)builder;
    }

    public void interrupt() {
        this.autoBuildJob.interrupt();
    }

    public boolean isAutobuildBuildPending() {
        return this.autoBuildJob.getState() != 0;
    }

    private boolean isInterestingProject(InternalBuilder currentBuilder, IProject project) {
        IProject[] interestingProjects;
        if (project.equals(currentBuilder.getProject())) {
            return true;
        }
        IProject[] iProjectArray = interestingProjects = currentBuilder.getInterestingProjects();
        int n = interestingProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject interestingProject = iProjectArray[n2];
            if (interestingProject.equals(project)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Set<InternalBuilder> getInterestedBuilders(IProject project) {
        HashSet<InternalBuilder> res = new HashSet<InternalBuilder>();
        for (InternalBuilder builder : this.currentBuilders) {
            if (!this.isInterestingProject(builder, project)) continue;
            res.add(builder);
        }
        return res;
    }

    private boolean needsBuild(InternalBuilder builder, int trigger) {
        IProject[] projects;
        switch (trigger) {
            case 15: {
                return true;
            }
            case 6: {
                return true;
            }
            case 10: {
                for (InternalBuilder currentBuilder : this.currentBuilders) {
                    if (!currentBuilder.callOnEmptyDelta()) continue;
                    return true;
                }
                break;
            }
        }
        ElementTree oldTree = builder.getLastBuiltTree();
        ElementTree newTree = this.workspace.getElementTree();
        long start = System.currentTimeMillis();
        this.currentDelta = this.deltaTreeCache.computeIfAbsent(null, oldTree, newTree, () -> {
            if (Policy.DEBUG_BUILD_NEEDED) {
                String message = "Checking if need to build. Starting delta computation between: " + oldTree.toString() + " and " + newTree.toString();
                Policy.debug(message);
            }
            DeltaDataTree computed = newTree.getDataTree().forwardDeltaWith(oldTree.getDataTree(), ResourceComparator.getBuildComparator());
            if (Policy.DEBUG_BUILD_NEEDED) {
                Policy.debug("End delta computation. (" + (System.currentTimeMillis() - start) + "ms).");
            }
            return computed;
        });
        if (this.currentDelta.findNodeAt(builder.getProject().getFullPath()) != null) {
            if (Policy.DEBUG_BUILD_NEEDED) {
                Policy.debug(String.valueOf(this.toString(builder)) + " needs building because of changes in: " + builder.getProject().getName());
            }
            return true;
        }
        IProject[] iProjectArray = projects = builder.getInterestingProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (this.currentDelta.findNodeAt(project.getFullPath()) != null) {
                if (Policy.DEBUG_BUILD_NEEDED) {
                    Policy.debug(String.valueOf(this.toString(builder)) + " needs building because of changes in: " + project.getName());
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void removeBuilders(IProject project, String builderId) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] oldSpec = desc.getBuildSpec();
        int oldLength = oldSpec.length;
        if (oldLength == 0) {
            return;
        }
        int remaining = 0;
        int i = 0;
        while (i < oldSpec.length) {
            if (oldSpec[i].getBuilderName().equals(builderId)) {
                oldSpec[i] = null;
            } else {
                ++remaining;
            }
            ++i;
        }
        if (remaining == oldSpec.length) {
            return;
        }
        ICommand[] newSpec = new ICommand[remaining];
        int i2 = 0;
        int newIndex = 0;
        while (i2 < oldLength) {
            if (oldSpec[i2] != null) {
                newSpec[newIndex++] = oldSpec[i2];
            }
            ++i2;
        }
        desc.setBuildSpec(newSpec);
        project.setDescription(desc, 0, null);
    }

    void requestRebuild() {
        this.rebuildRequested = true;
    }

    public void setBuildersPersistentInfo(IProject project, List<BuilderPersistentInfo> list) {
        try {
            project.setSessionProperty(K_BUILD_LIST, list);
        }
        catch (CoreException e) {
            this.logProjectAccessError(project, e, "Project missing in setBuildersPersistentInfo");
        }
    }

    private void setBuilderInitInfo(IProject project, String builderName, BuilderPersistentInfo info) {
        try {
            project.setSessionProperty(BuildManager.keyForBuilderInfo(builderName), info);
        }
        catch (CoreException e) {
            this.logProjectAccessError(project, e, "Project missing in setBuilderInitInfo");
        }
    }

    private BuilderPersistentInfo getBuilderInitInfo(IProject project, String builderName) {
        try {
            return (BuilderPersistentInfo)project.getSessionProperty(BuildManager.keyForBuilderInfo(builderName));
        }
        catch (CoreException e) {
            this.logProjectAccessError(project, e, "Project missing in getBuilderInitInfo");
            return null;
        }
    }

    private void logProjectAccessError(IProject project, CoreException e, String message) {
        Policy.log(new ResourceStatus(4, 1, project.getFullPath(), message, (Throwable)e));
    }

    private static QualifiedName keyForBuilderInfo(String builderName) {
        return new QualifiedName("org.eclipse.core.resources", BUILDER_INIT + builderName);
    }

    @Override
    public void shutdown(IProgressMonitor monitor) {
        this.autoBuildJob.cancel();
    }

    @Override
    public void startup(IProgressMonitor monitor) {
        this.workspace.addLifecycleListener(this);
    }

    private String toString(InternalBuilder builder) {
        String name = builder.getClass().getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        if (builder instanceof MissingBuilder) {
            name = String.valueOf(name) + ": '" + ((MissingBuilder)builder).getName() + "'";
        }
        return String.valueOf(name) + "(" + builder.getBuildConfig() + ")";
    }

    private boolean validateNature(InternalBuilder builder, String builderId) throws CoreException {
        String nature = builder.getNatureId();
        if (nature == null) {
            return true;
        }
        IProject project = builder.getProject();
        if (!project.hasNature(nature)) {
            this.removeBuilders(project, builderId);
            return false;
        }
        return project.isNatureEnabled(nature);
    }

    public ISchedulingRule getRule(IBuildConfiguration buildConfiguration, int trigger, String builderName, Map<String, String> buildArgs) {
        IProject project = buildConfiguration.getProject();
        MultiStatus status = new MultiStatus("org.eclipse.core.resources", 566, Messages.events_errors, null);
        if (builderName == null) {
            if (project.isAccessible()) {
                HashSet<ISchedulingRule> rules = new HashSet<ISchedulingRule>();
                ICommand[] commands = ((Project)project).internalGetDescription().getBuildSpec(false);
                boolean hasNullBuildRule = false;
                BuildContext context = new BuildContext(buildConfiguration);
                int i = 0;
                while (i < commands.length) {
                    BuildCommand command = (BuildCommand)commands[i];
                    Map<String, String> allArgs = command.getArguments(true);
                    if (allArgs == null) {
                        allArgs = buildArgs;
                    } else if (buildArgs != null) {
                        allArgs.putAll(buildArgs);
                    }
                    try {
                        IncrementalProjectBuilder builder = this.getBuilder(buildConfiguration, command, i, status, context);
                        if (builder != null) {
                            ISchedulingRule builderRule = builder.getRule(trigger, allArgs);
                            if (builderRule != null) {
                                rules.add(builderRule);
                            } else {
                                hasNullBuildRule = true;
                            }
                        }
                    }
                    catch (CoreException e) {
                        status.add(e.getStatus());
                    }
                    ++i;
                }
                if (rules.isEmpty()) {
                    return null;
                }
                if (!hasNullBuildRule) {
                    return new MultiRule(rules.toArray(new ISchedulingRule[rules.size()]));
                }
            }
        } else {
            ICommand command = this.getCommand(project, builderName, buildArgs);
            HashMap<String, String> allArgs = new HashMap<String, String>();
            if (command.getArguments() != null) {
                allArgs.putAll(command.getArguments());
            }
            if (buildArgs != null) {
                allArgs.putAll(buildArgs);
            }
            try {
                IncrementalProjectBuilder builder = this.getBuilder(buildConfiguration, command, -1, status);
                if (builder != null) {
                    return builder.getRule(trigger, allArgs);
                }
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
        }
        if (!status.isOK()) {
            Policy.log(status);
        }
        return this.workspace.getRoot();
    }

    static class DeltaCache<E> {
        private final Map<IPath, E> deltas = new HashMap<IPath, E>();
        private ElementTree newTree;
        private ElementTree oldTree;

        DeltaCache() {
        }

        public void flush() {
            this.deltas.clear();
            this.oldTree = null;
            this.newTree = null;
        }

        public E computeIfAbsent(IPath project, ElementTree anOldTree, ElementTree aNewTree, Supplier<E> calculator) {
            if (!DeltaCache.areEqual(this.oldTree, anOldTree) || !DeltaCache.areEqual(this.newTree, aNewTree)) {
                this.oldTree = anOldTree;
                this.newTree = aNewTree;
                this.deltas.clear();
            }
            return (E)this.deltas.computeIfAbsent(project, p -> calculator.get());
        }

        private static boolean areEqual(ElementTree cached, ElementTree requested) {
            return !ElementTree.hasChanges(requested, cached, ResourceComparator.getBuildComparator(), true);
        }
    }

    class MissingBuilder
    extends IncrementalProjectBuilder {
        private boolean hasBeenBuilt = false;
        private String name;

        MissingBuilder(String name) {
            this.name = name;
        }

        @Override
        protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) {
            if (!this.hasBeenBuilt && Policy.DEBUG_BUILD_FAILURE) {
                this.hasBeenBuilt = true;
                String msg = NLS.bind(Messages.events_skippingBuilder, this.name, this.getProject().getName());
                Policy.log(2, msg, null);
            }
            return null;
        }

        String getName() {
            return this.name;
        }

        @Override
        public ISchedulingRule getRule(int kind, Map<String, String> args) {
            return null;
        }
    }
}

