/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.jdt.groovy.model.GrabDeclaration;
import org.codehaus.jdt.groovy.model.GrapesContainer;
import org.codehaus.jdt.groovy.model.GrapesContainerInfo;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.core.AnnotatableInfo;
import org.eclipse.jdt.internal.core.CompilationUnitElementInfo;
import org.eclipse.jdt.internal.core.CompilationUnitStructureRequestor;
import org.eclipse.jdt.internal.core.JavaElement;

class GroovyCompilationUnitStructureRequestor
extends CompilationUnitStructureRequestor {
    protected GrapesContainer grapesContainer;
    protected GrapesContainerInfo grapesContainerInfo;

    protected GroovyCompilationUnitStructureRequestor(ICompilationUnit unit, CompilationUnitElementInfo unitInfo, Map newElements) {
        super(unit, unitInfo, newElements);
    }

    @Override
    protected IAnnotation acceptAnnotation(Annotation annotation, AnnotatableInfo parentInfo, JavaElement parentHandle) {
        IAnnotation result = super.acceptAnnotation(annotation, parentInfo, parentHandle);
        if (result.getElementName().endsWith("Grab")) {
            String group = null;
            String module = null;
            String version = null;
            MemberValuePair[] memberValuePairArray = annotation.memberValuePairs();
            int n = memberValuePairArray.length;
            int n2 = 0;
            while (n2 < n) {
                MemberValuePair mvp = memberValuePairArray[n2];
                String key = String.valueOf(mvp.name);
                if (key.equals("group")) {
                    group = mvp.value.toString();
                    group = group.substring(1, group.length() - 1);
                } else if (key.equals("module")) {
                    module = mvp.value.toString();
                    module = module.substring(1, module.length() - 1);
                } else if (key.equals("version")) {
                    version = mvp.value.toString();
                    version = version.substring(1, version.length() - 1);
                }
                ++n2;
            }
            if (group != null && module != null && version != null) {
                if (this.grapesContainer == null) {
                    this.grapesContainer = new GrapesContainer(this.unit);
                    this.grapesContainerInfo = new GrapesContainerInfo();
                    this.children.put(this.grapesContainerInfo, new ArrayList());
                    ((List)this.children.get(this.unitInfo)).add(this.grapesContainer);
                    this.newElements.put(this.grapesContainer, this.grapesContainerInfo);
                }
                ((List)this.children.get(this.grapesContainerInfo)).add(new GrabDeclaration(this.grapesContainer, annotation.sourceStart, annotation.sourceEnd, group, module, version));
            }
        }
        return result;
    }

    @Override
    public void exitCompilationUnit(int unitDeclarationEnd) {
        super.exitCompilationUnit(unitDeclarationEnd);
        if (this.grapesContainerInfo != null) {
            List grapes = (List)this.children.get(this.grapesContainerInfo);
            this.grapesContainerInfo.children = grapes.toArray(new IJavaElement[grapes.size()]);
        }
    }

    protected void setParser(SourceElementParser parser) {
        this.parser = parser;
    }
}

