/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import groovy.lang.DelegatesTo;
import groovy.lang.Tuple;
import groovy.transform.stc.ClosureParams;
import java.beans.Introspector;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImmutableClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.ast.tools.WideningCategories;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.codehaus.groovy.transform.trait.Traits;
import org.codehaus.jdt.groovy.control.EclipseSourceUnit;
import org.codehaus.jdt.groovy.internal.compiler.GroovyClassLoaderFactory;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTMethodNode;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.AccessorSupport;
import org.eclipse.jdt.groovy.search.GenericsMapper;

public class VariableScope
implements Iterable<VariableInfo> {
    public static final ClassNode NULL_TYPE = new ImmutableClassNode((Class)Object.class);
    public static final ClassNode VOID_CLASS_NODE = ClassHelper.VOID_TYPE;
    public static final ClassNode VOID_WRAPPER_CLASS_NODE = ClassHelper.void_WRAPPER_TYPE;
    public static final ClassNode OBJECT_CLASS_NODE = ClassHelper.OBJECT_TYPE;
    public static final ClassNode GROOVY_OBJECT_CLASS_NODE = ClassHelper.GROOVY_OBJECT_TYPE;
    public static final ClassNode GROOVY_SUPPORT_CLASS_NODE = ClassHelper.GROOVY_OBJECT_SUPPORT_TYPE;
    public static final ClassNode CLOSURE_CLASS_NODE = ClassHelper.CLOSURE_TYPE;
    public static final ClassNode ENUMERATION_CLASS_NODE = ClassHelper.make(Enumeration.class);
    public static final ClassNode COLLECTION_CLASS_NODE = ClassHelper.make(Collection.class);
    public static final ClassNode ITERABLE_CLASS_NODE = ClassHelper.make(Iterable.class);
    public static final ClassNode ITERATOR_CLASS_NODE = ClassHelper.Iterator_TYPE;
    public static final ClassNode LIST_CLASS_NODE = ClassHelper.LIST_TYPE;
    public static final ClassNode MAP_CLASS_NODE = ClassHelper.MAP_TYPE;
    public static final ClassNode ENTRY_CLASS_NODE = ClassHelper.make(Map.Entry.class);
    public static final ClassNode RANGE_CLASS_NODE = ClassHelper.RANGE_TYPE;
    public static final ClassNode TUPLE_CLASS_NODE = ClassHelper.make(Tuple.class);
    public static final ClassNode STRING_CLASS_NODE = ClassHelper.STRING_TYPE;
    public static final ClassNode GSTRING_CLASS_NODE = ClassHelper.GSTRING_TYPE;
    public static final ClassNode NUMBER_CLASS_NODE = ClassHelper.Number_TYPE;
    public static final ClassNode BIG_DECIMAL_CLASS = ClassHelper.BigDecimal_TYPE;
    public static final ClassNode BIG_INTEGER_CLASS = ClassHelper.BigInteger_TYPE;
    public static final ClassNode PATTERN_CLASS_NODE = ClassHelper.PATTERN_TYPE;
    public static final ClassNode MATCHER_CLASS_NODE = ClassHelper.make(Matcher.class);
    public static final ClassNode FILE_CLASS_NODE = ClassHelper.make(File.class);
    public static final ClassNode READER_CLASS_NODE = ClassHelper.make(Reader.class);
    public static final ClassNode INPUT_STREAM_CLASS_NODE = ClassHelper.make(InputStream.class);
    public static final ClassNode OUTPUT_STREAM_CLASS_NODE = ClassHelper.make(OutputStream.class);
    public static final ClassNode DATA_INPUT_STREAM_CLASS_NODE = ClassHelper.make(DataInputStream.class);
    public static final ClassNode DATA_OUTPUT_STREAM_CLASS_NODE = ClassHelper.make(DataOutputStream.class);
    public static final ClassNode DELEGATES_TO = ClassHelper.make(DelegatesTo.class);
    public static final ClassNode CLOSURE_PARAMS = ClassHelper.make(ClosureParams.class);
    public static final ClassNode DGM_CLASS_NODE = ClassHelper.make(DefaultGroovyMethods.class);
    public static final ClassNode DGSM_CLASS_NODE = ClassHelper.make(DefaultGroovyStaticMethods.class);
    public static final ClassNode BOOLEAN_CLASS_NODE = ClassHelper.Boolean_TYPE;
    public static final ClassNode CHARACTER_CLASS_NODE = ClassHelper.Character_TYPE;
    public static final ClassNode BYTE_CLASS_NODE = ClassHelper.Byte_TYPE;
    public static final ClassNode INTEGER_CLASS_NODE = ClassHelper.Integer_TYPE;
    public static final ClassNode SHORT_CLASS_NODE = ClassHelper.Short_TYPE;
    public static final ClassNode LONG_CLASS_NODE = ClassHelper.Long_TYPE;
    public static final ClassNode FLOAT_CLASS_NODE = ClassHelper.Float_TYPE;
    public static final ClassNode DOUBLE_CLASS_NODE = ClassHelper.Double_TYPE;
    public static final ClassNode CLASS_CLASS_NODE = VariableScope.initializeProperties(ClassHelper.makeWithoutCaching(Class.class));
    private VariableScope parent;
    private SharedState shared;
    private ASTNode scopeNode;
    private boolean isPrimaryNode;
    private final boolean isStaticScope;
    private ClassNode categoryBeingDeclared;
    private Set<String> dirtyNames;
    private int enclosingCallStackDepth;
    private List<ClassNode> methodCallArgumentTypes;
    private GenericsType[] methodCallGenericsTypes;
    private final Map<String, VariableInfo> nameVariableMap = new HashMap<String, VariableInfo>();

    private static ClassNode initializeProperties(ClassNode node) {
        node.getMethods().stream().filter(AccessorSupport::isGetter).forEach(methodNode -> {
            String propertyName = Introspector.decapitalize(methodNode.getName().substring(methodNode.getName().startsWith("is") ? 2 : 3));
            node.addProperty(new PropertyNode(propertyName, methodNode.getModifiers(), methodNode.getReturnType(), null, null, null, null));
        });
        return node;
    }

    public VariableScope(VariableScope parent, ASTNode enclosingNode, boolean isStatic) {
        this.parent = parent;
        this.scopeNode = enclosingNode;
        this.shared = parent != null ? parent.shared : new SharedState();
        this.enclosingCallStackDepth = this.shared.enclosingCallStack.size();
        boolean bl = this.isStaticScope = (isStatic || !(enclosingNode instanceof ClassNode) && parent != null && parent.isStaticScope) && this.getEnclosingClosureScope() == null;
        if (enclosingNode instanceof ClassNode || enclosingNode instanceof FieldNode) {
            this.shared.isRunMethod = false;
        } else if (enclosingNode instanceof MethodNode) {
            this.shared.isRunMethod = ((MethodNode)enclosingNode).isScriptBody();
        }
        if (enclosingNode instanceof ClassNode) {
            ClassNode type = (ClassNode)enclosingNode;
            this.addVariable("this", VariableScope.newClassClassNode(type), type);
        } else if (!isStatic && parent != null && parent.scopeNode instanceof ClassNode) {
            ClassNode type = (ClassNode)parent.scopeNode;
            this.addVariable("this", type, type);
        }
    }

    public Map<String, Object> getWormhole() {
        return this.shared.wormhole;
    }

    public ASTNode getEnclosingNode() {
        int n = this.shared.nodeStack.size();
        if (n > 1) {
            return (ASTNode)this.shared.nodeStack.get(n - 2);
        }
        return null;
    }

    public void setCurrentNode(ASTNode currentNode) {
        this.shared.nodeStack.add(currentNode);
    }

    public void forgetCurrentNode() {
        if (!this.shared.nodeStack.isEmpty()) {
            this.shared.nodeStack.removeLast();
        }
    }

    public ASTNode getCurrentNode() {
        if (!this.shared.nodeStack.isEmpty()) {
            return (ASTNode)this.shared.nodeStack.getLast();
        }
        return null;
    }

    public void setPrimaryNode(boolean isPrimaryNode) {
        this.isPrimaryNode = isPrimaryNode;
    }

    public boolean isPrimaryNode() {
        return this.isPrimaryNode;
    }

    public Set<ClassNode> getCategoryNames() {
        LinkedHashSet<ClassNode> categories;
        if (this.parent != null) {
            categories = this.parent.getCategoryNames();
            if (this.parent.isCategoryBeingDeclared()) {
                categories = new LinkedHashSet<ClassNode>(categories);
                categories.add(this.parent.categoryBeingDeclared);
            }
        } else {
            categories = this.scopeNode.getNodeMetaData(DefaultGroovyMethods.class, key -> {
                GroovyClassLoaderFactory.GrapeAwareGroovyClassLoader gcl = (GroovyClassLoaderFactory.GrapeAwareGroovyClassLoader)((ModuleNode)this.scopeNode).getUnit().getClassLoader();
                return gcl.getDefaultCategories().stream().map(ClassNode::new).collect(Collectors.toCollection(LinkedHashSet::new));
            });
        }
        return categories;
    }

    private boolean isCategoryBeingDeclared() {
        return this.categoryBeingDeclared != null;
    }

    public void setCategoryBeingDeclared(ClassNode categoryBeingDeclared) {
        this.categoryBeingDeclared = categoryBeingDeclared;
    }

    public boolean isDefaultCategory(ClassNode category) {
        ModuleNode module = this.getEnclosingModuleNode();
        Set defaultCategories = (Set)module.getNodeMetaData(DefaultGroovyMethods.class);
        return defaultCategories.contains(category);
    }

    public boolean isDefaultStaticCategory(ClassNode category) {
        ModuleNode module = this.getEnclosingModuleNode();
        GroovyClassLoaderFactory.GrapeAwareGroovyClassLoader loader = (GroovyClassLoaderFactory.GrapeAwareGroovyClassLoader)module.getUnit().getClassLoader();
        return loader.isDefaultStaticCategory(category.getName());
    }

    public VariableInfo lookupName(String name) {
        ClassNode type;
        if ("super".equals(name) && (type = this.getThis()) != null) {
            ClassNode superType = type;
            VariableScope scope = this.getEnclosingClosureScope();
            if (scope == null || !scope.isOwnerStatic()) {
                if (!this.isStatic()) {
                    superType = type.getSuperClass();
                    if (OBJECT_CLASS_NODE.equals(superType) && GroovyUtils.isAnonymous(type)) {
                        superType = type.getInterfaces()[0];
                    }
                } else {
                    assert (type.equals(CLASS_CLASS_NODE) && type.getGenericsTypes() != null);
                    superType = type.getGenericsTypes()[0].getType().getSuperClass();
                    if (superType != null && !superType.equals(OBJECT_CLASS_NODE)) {
                        superType = VariableScope.newClassClassNode(superType);
                    }
                }
            }
            return new VariableInfo(name, superType, superType);
        }
        VariableInfo info = this.lookupNameInCurrentScope(name);
        if (info == null && this.parent != null) {
            info = this.parent.lookupName(name);
        }
        return info;
    }

    public VariableInfo lookupNameInCurrentScope(String name) {
        VariableInfo info = this.nameVariableMap.get(name);
        if (info != null) {
            info = new VariableInfo(info, this.scopeNode);
        }
        return info;
    }

    public ClassNode getThis() {
        VariableInfo info = this.lookupName("this");
        return info != null ? info.type : null;
    }

    public ClassNode getOwner() {
        VariableInfo info = this.lookupName("getOwner");
        return info != null ? info.type : null;
    }

    public ClassNode getDelegate() {
        VariableInfo info = this.lookupName("getDelegate");
        return info != null ? info.type : null;
    }

    public ClassNode getDelegateOrThis() {
        ClassNode type = this.getDelegate();
        if (type == null) {
            type = this.getThis();
        }
        return type;
    }

    public boolean isStatic() {
        return this.isStaticScope;
    }

    public boolean isOwnerStatic() {
        VariableScope scope = this;
        do {
            if (!scope.isStatic()) continue;
            return true;
        } while (!(scope.scopeNode instanceof ClassNode) && !(scope.scopeNode instanceof FieldNode) && !(scope.scopeNode instanceof MethodNode) && (scope = scope.parent) != null);
        return false;
    }

    public boolean isFieldAccessDirect() {
        return this.getEnclosingClosureScope() == null;
    }

    public ModuleNode getEnclosingModuleNode() {
        if (this.scopeNode instanceof ModuleNode) {
            return (ModuleNode)this.scopeNode;
        }
        if (this.parent != null) {
            return this.parent.getEnclosingModuleNode();
        }
        return null;
    }

    public ClassNode getEnclosingTypeDeclaration() {
        if (this.scopeNode instanceof ClassNode) {
            return (ClassNode)this.scopeNode;
        }
        if (this.parent != null) {
            return this.parent.getEnclosingTypeDeclaration();
        }
        return null;
    }

    public FieldNode getEnclosingFieldDeclaration() {
        if (this.scopeNode instanceof FieldNode) {
            return (FieldNode)this.scopeNode;
        }
        if (this.parent != null) {
            return this.parent.getEnclosingFieldDeclaration();
        }
        return null;
    }

    public MethodNode getEnclosingMethodDeclaration() {
        if (this.scopeNode instanceof MethodNode) {
            return (MethodNode)this.scopeNode;
        }
        if (this.parent != null) {
            return this.parent.getEnclosingMethodDeclaration();
        }
        return null;
    }

    public ClosureExpression getEnclosingClosure() {
        VariableScope scope = this.getEnclosingClosureScope();
        return scope != null ? (ClosureExpression)scope.scopeNode : null;
    }

    public int getEnclosingClosureResolveStrategy() {
        CallAndType cat;
        VariableScope scope = this.getEnclosingClosureScope();
        int resolveStrategy = 0;
        if (scope != null && (cat = scope.getEnclosingMethodCallExpression()) != null) {
            resolveStrategy = cat.getResolveStrategy((ClosureExpression)scope.scopeNode);
        }
        return resolveStrategy;
    }

    VariableScope getEnclosingClosureScope() {
        VariableScope scope = this;
        while (scope != null) {
            if (scope.scopeNode instanceof ClosureExpression) {
                return scope;
            }
            if (scope.scopeNode instanceof ClassNode) break;
            scope = scope.parent;
        }
        return null;
    }

    public BinaryExpression getEnclosingAssignment() {
        Object node = this.getWormhole().get("enclosingAssignment");
        if (node instanceof BinaryExpression) {
            return (BinaryExpression)node;
        }
        return null;
    }

    public Optional<Token> getEnclosingAssignmentOperator() {
        return Optional.ofNullable(this.getEnclosingAssignment()).map(expr -> Optional.ofNullable((Token)expr.getNodeMetaData("original.operator")).orElse(expr.getOperation()));
    }

    public void addVariable(Variable var) {
        this.addVariable(var.getName(), var.getType(), ((AnnotatedNode)((Object)var)).getDeclaringClass());
    }

    public void addVariable(String name, ClassNode type, ClassNode declaringType) {
        if (declaringType == null) {
            declaringType = this.getEnclosingTypeDeclaration();
        }
        this.nameVariableMap.put(name, new VariableInfo(name, type, declaringType));
    }

    public void updateOrAddVariable(String name, ClassNode type, ClassNode declaringType) {
        if (!this.updateVariableImpl(name, type, declaringType)) {
            this.addVariable(name, type, declaringType);
        }
    }

    public void updateVariable(String name, ClassNode type, ClassNode declaringType) {
        this.updateVariableImpl(name, type, declaringType);
    }

    private boolean updateVariableImpl(String name, ClassNode type, ClassNode declaringType) {
        VariableInfo info = this.nameVariableMap.get(name);
        if (info == null && this.parent != null) {
            info = this.parent.lookupName(name);
        }
        if (info != null) {
            this.nameVariableMap.put(name, VariableScope.merge(info, type, declaringType));
            if (info.scopeNode != this.scopeNode) {
                if (this.dirtyNames == null) {
                    this.dirtyNames = new HashSet<String>();
                }
                this.dirtyNames.add(name);
            }
            return true;
        }
        return false;
    }

    void updateVariableSoft(String name, ClassNode type) {
        this.nameVariableMap.put(name, VariableScope.merge(this.parent.lookupName(name), type, null));
    }

    private static VariableInfo merge(VariableInfo base, ClassNode type, ClassNode declaringType) {
        if (declaringType == null) {
            declaringType = base.declaringType;
        }
        VariableInfo info = new VariableInfo(base.name, type, declaringType);
        info.scopeNode = base.scopeNode;
        return info;
    }

    void bubbleUpdates() {
        if (!(this.dirtyNames == null || this.dirtyNames.isEmpty() || this.isTerminal() || this.isTopLevel())) {
            for (String name : this.dirtyNames) {
                VariableInfo info = this.nameVariableMap.get(name);
                this.parent.updateVariable(name, info.type, info.declaringType);
            }
        }
        this.dirtyNames = null;
    }

    void bubbleUpdates(VariableScope defaultBranch, VariableScope ... conditionalBranches) {
        VariableScope[] nonTerminalBranches = (VariableScope[])Stream.concat(Stream.of(conditionalBranches), Stream.of(defaultBranch)).filter(it -> !it.isTerminal()).toArray(VariableScope[]::new);
        Stream.of(nonTerminalBranches).flatMap(it -> it.dirtyNames != null ? it.dirtyNames.stream() : Stream.empty()).distinct().forEach(name -> {
            ClassNode type = null;
            if (!Stream.of(nonTerminalBranches).allMatch(it -> it.dirtyNames != null && it.dirtyNames.contains(name))) {
                type = this.lookupName((String)name).type;
            }
            type = Stream.of(nonTerminalBranches).filter(it -> it.dirtyNames != null && it.dirtyNames.contains(name)).map(it -> it.nameVariableMap.get((Object)string).type).reduce(type, (t0, t1) -> t0 == null ? t1 : WideningCategories.lowestUpperBound(t0, t1));
            this.parent.updateVariable((String)name, type, this.lookupName((String)name).declaringType);
            if (this.dirtyNames != null) {
                this.dirtyNames.remove(name);
            }
        });
        this.bubbleUpdates();
    }

    public static ClassNode resolveTypeParameterization(GenericsMapper mapper, ClassNode type) {
        GenericsType[] parameterizedTypes;
        if (mapper.hasGenerics() && (parameterizedTypes = GroovyUtils.getGenericsTypes(type)).length > 0) {
            int i = 0;
            int n = parameterizedTypes.length;
            while (i < n) {
                GenericsType parameterizedType = parameterizedTypes[i];
                ClassNode maybe = VariableScope.resolveTypeParameterization(mapper, parameterizedType, type);
                if (maybe != type) {
                    assert (n == 1);
                    type = maybe;
                    break;
                }
                ++i;
            }
        }
        return type;
    }

    /*
     * Unable to fully structure code
     */
    public static ClassNode resolveTypeParameterization(GenericsMapper mapper, GenericsType generic, ClassNode unresolved) {
        block6: {
            block5: {
                if (generic.isWildcard()) break block5;
                VariableScope.resolveTypeParameterization(mapper, generic.getType());
                toParameterizeName = generic.getName();
                resolved = mapper.findParameter(toParameterizeName, generic.getType());
                if (unresolved.toString(false).equals(toParameterizeName) || !VariableScope.typeParameterExistsInRedirected(unresolved, toParameterizeName)) ** GOTO lbl19
                Assert.isLegal(unresolved.redirect() != unresolved, "Error: trying to resolve type parameters of a type declaration: " + unresolved);
                generic.setLowerBound(null);
                generic.setUpperBounds(null);
                generic.setPlaceHolder(false);
                generic.setWildcard(false);
                generic.setResolved(true);
                generic.setType(resolved);
                generic.setName(generic.getType().getName());
                break block6;
lbl-1000:
                // 1 sources

                {
                    unresolved = unresolved.getComponentType();
                    resolved = resolved.makeArray();
lbl19:
                    // 2 sources

                    ** while (unresolved.isArray())
                }
lbl20:
                // 1 sources

                return resolved;
            }
            if (generic.getLowerBound() != null) {
                resolved = VariableScope.resolveTypeParameterization(mapper, generic.getLowerBound());
                generic.setLowerBound(resolved);
                generic.setResolved(true);
            } else if (generic.getUpperBounds() != null) {
                parameterizedTypeUpperBounds = generic.getUpperBounds();
                j = 0;
                k = parameterizedTypeUpperBounds.length;
                while (j < k) {
                    parameterizedTypeUpperBounds[j] = resolved = VariableScope.resolveTypeParameterization(mapper, parameterizedTypeUpperBounds[j]);
                    ++j;
                }
                generic.setResolved(true);
            }
        }
        return unresolved;
    }

    public static MethodNode resolveTypeParameterization(GenericsMapper mapper, MethodNode method) {
        if (mapper.hasGenerics() && GroovyUtils.isUsingGenerics(method)) {
            MethodNode resolved;
            ClassNode returnType = VariableScope.resolveTypeParameterization(mapper, VariableScope.clone(method.getReturnType()));
            Parameter[] parameters = method.getParameters();
            if (parameters != null && parameters.length > 0) {
                int n = parameters.length;
                parameters = new Parameter[n];
                int i = 0;
                while (i < n) {
                    Parameter original = method.getParameters()[i];
                    ClassNode parameterType = VariableScope.resolveTypeParameterization(mapper, VariableScope.clone(original.getType()));
                    parameters[i] = new Parameter(parameterType, original.getName(), original.getInitialExpression());
                    parameters[i].addAnnotations(original.getAnnotations());
                    parameters[i].setClosureSharedVariable(original.isClosureSharedVariable());
                    parameters[i].setDeclaringClass(original.getDeclaringClass());
                    parameters[i].setHasNoRealSourcePosition(original.hasNoRealSourcePosition());
                    parameters[i].setInStaticContext(original.isInStaticContext());
                    parameters[i].setModifiers(original.getModifiers());
                    parameters[i].copyNodeMetaData(original);
                    parameters[i].setOriginType(original.getOriginType());
                    parameters[i].setSourcePosition(original);
                    parameters[i].setSynthetic(original.isSynthetic());
                    ++i;
                }
            }
            if (method instanceof JDTMethodNode) {
                resolved = new JDTMethodNode(((JDTMethodNode)method).getMethodBinding(), ((JDTMethodNode)method).getResolver(), method.getName(), method.getModifiers(), returnType, parameters, method.getExceptions(), method.getCode());
            } else {
                resolved = new MethodNode(method.getName(), method.getModifiers(), returnType, parameters, method.getExceptions(), method.getCode());
                resolved.addAnnotations(method.getAnnotations());
            }
            resolved.setAnnotationDefault(method.hasAnnotationDefault());
            resolved.setDeclaringClass(VariableScope.resolveTypeParameterization(mapper, VariableScope.clone(method.getDeclaringClass())));
            resolved.setGenericsTypes(method.getGenericsTypes());
            resolved.setHasNoRealSourcePosition(method.hasNoRealSourcePosition());
            resolved.copyNodeMetaData(method);
            resolved.setOriginal(method.getOriginal());
            resolved.setSourcePosition(method);
            resolved.setSynthetic(method.isSynthetic());
            resolved.setSyntheticPublic(method.isSyntheticPublic());
            resolved.setVariableScope(method.getVariableScope());
            method = resolved;
        }
        return method;
    }

    private static boolean typeParameterExistsInRedirected(ClassNode type, String toParameterizeName) {
        ClassNode redirect = type.redirect();
        GenericsType[] genericsTypes = redirect.getGenericsTypes();
        return genericsTypes != null;
    }

    public static ClassNode clone(ClassNode type) {
        return VariableScope.cloneInternal(type, 0);
    }

    public static GenericsType clone(GenericsType gt, int depth) {
        GenericsType newgt = new GenericsType();
        newgt.setType(VariableScope.cloneInternal(gt.getType(), depth + 1));
        newgt.setLowerBound(VariableScope.cloneInternal(gt.getLowerBound(), depth + 1));
        ClassNode[] oldUpperBounds = gt.getUpperBounds();
        if (oldUpperBounds != null) {
            int n = oldUpperBounds.length;
            ClassNode[] newUpperBounds = new ClassNode[n];
            int i = 0;
            while (i < n) {
                newUpperBounds[i] = VariableScope.cloneInternal(oldUpperBounds[i], depth + 1);
                ++i;
            }
            newgt.setUpperBounds(newUpperBounds);
        }
        newgt.setName(gt.getName());
        newgt.setPlaceholder(gt.isPlaceholder());
        newgt.setWildcard(gt.isWildcard());
        newgt.setResolved(gt.isResolved());
        newgt.setSourcePosition(gt);
        return newgt;
    }

    public static ClassNode clonedMap() {
        ClassNode clone = VariableScope.clone(MAP_CLASS_NODE);
        VariableScope.cleanGenerics(clone.getGenericsTypes()[0]);
        VariableScope.cleanGenerics(clone.getGenericsTypes()[1]);
        return clone;
    }

    public static ClassNode clonedList() {
        ClassNode clone = VariableScope.clone(LIST_CLASS_NODE);
        VariableScope.cleanGenerics(clone.getGenericsTypes()[0]);
        return clone;
    }

    public static ClassNode clonedRange() {
        ClassNode clone = VariableScope.clone(RANGE_CLASS_NODE);
        VariableScope.cleanGenerics(clone.getGenericsTypes()[0]);
        return clone;
    }

    public static ClassNode clonedClosure() {
        ClassNode clone = VariableScope.clone(CLOSURE_CLASS_NODE);
        VariableScope.cleanGenerics(clone.getGenericsTypes()[0]);
        return clone;
    }

    private static void cleanGenerics(GenericsType gt) {
        gt.getType().setGenericsTypes(null);
        gt.setName("java.lang.Object");
        gt.setPlaceholder(false);
        gt.setWildcard(false);
        gt.setResolved(true);
        gt.setUpperBounds(null);
        gt.setLowerBound(null);
    }

    private static ClassNode cloneInternal(ClassNode type, int depth) {
        GenericsType[] generics;
        if (type == null || ClassHelper.isPrimitiveType(type)) {
            return type;
        }
        ClassNode newType = type.getPlainNodeReference();
        newType.setSourcePosition(type);
        newType.setGenericsPlaceHolder(type.isGenericsPlaceHolder());
        ReflectionUtils.setPrivateField(ClassNode.class, "componentType", newType, VariableScope.cloneInternal(type.getComponentType(), depth + 1));
        if (depth < 11 && (generics = type.getGenericsTypes()) != null) {
            int n = generics.length;
            GenericsType[] clones = new GenericsType[n];
            int i = 0;
            while (i < n) {
                clones[i] = VariableScope.clone(generics[i], depth);
                ++i;
            }
            newType.setGenericsTypes(clones);
        }
        return newType;
    }

    public static ClassNode newClassClassNode(ClassNode type) {
        ClassNode classType = ClassHelper.makeWithoutCaching("java.lang.Class");
        classType.setGenericsTypes(new GenericsType[]{new GenericsType(type)});
        classType.setRedirect(CLASS_CLASS_NODE);
        return classType;
    }

    public List<CallAndType> getAllEnclosingMethodCallExpressions() {
        return this.shared.enclosingCallStack.subList(0, this.enclosingCallStackDepth);
    }

    public CallAndType getEnclosingMethodCallExpression() {
        List<CallAndType> enclosingCalls = this.getAllEnclosingMethodCallExpressions();
        return !enclosingCalls.isEmpty() ? enclosingCalls.get(enclosingCalls.size() - 1) : null;
    }

    public void addEnclosingMethodCall(CallAndType enclosingMethodCall) {
        assert (this.enclosingCallStackDepth == this.shared.enclosingCallStack.size());
        this.shared.enclosingCallStack.add(enclosingMethodCall);
        ++this.enclosingCallStackDepth;
    }

    public void forgetEnclosingMethodCall() {
        assert (this.enclosingCallStackDepth == this.shared.enclosingCallStack.size());
        this.shared.enclosingCallStack.remove(this.enclosingCallStackDepth - 1);
        --this.enclosingCallStackDepth;
    }

    public boolean containsInThisScope(String name) {
        return this.nameVariableMap.containsKey(name);
    }

    void setMethodCallArgumentTypes(List<ClassNode> methodCallArgumentTypes) {
        this.methodCallArgumentTypes = methodCallArgumentTypes;
    }

    public List<ClassNode> getMethodCallArgumentTypes() {
        return this.methodCallArgumentTypes;
    }

    void setMethodCallGenericsTypes(GenericsType[] methodCallGenericsTypes) {
        this.methodCallGenericsTypes = methodCallGenericsTypes;
    }

    public GenericsType[] getMethodCallGenericsTypes() {
        return this.methodCallGenericsTypes;
    }

    public int getMethodCallNumberOfArguments() {
        return this.isMethodCall() ? this.methodCallArgumentTypes.size() : 0;
    }

    public boolean isMethodCall() {
        return this.methodCallArgumentTypes != null;
    }

    public boolean inScriptRunMethod() {
        return this.shared.isRunMethod;
    }

    public boolean isTerminal() {
        if (this.scopeNode instanceof BlockStatement) {
            return ((BlockStatement)this.scopeNode).getStatements().stream().anyMatch(s -> s instanceof ReturnStatement);
        }
        if (this.scopeNode instanceof ReturnStatement) {
            return true;
        }
        boolean cfr_ignored_0 = this.scopeNode instanceof ThrowStatement;
        return !(!(this.scopeNode instanceof MethodNode) || this.scopeNode instanceof ConstructorNode || ((MethodNode)this.scopeNode).isStatic() && ((MethodNode)this.scopeNode).getName().equals("<clinit>") || !((MethodNode)this.scopeNode).isStatic() && GroovyUtils.getAnnotations((MethodNode)this.scopeNode, "javax.annotation.PostConstruct").anyMatch(x -> true));
    }

    public boolean isTopLevel() {
        return this.parent == null;
    }

    @Override
    public Iterator<VariableInfo> iterator() {
        return new Iterator<VariableInfo>(){
            VariableScope currentScope;
            Iterator<VariableInfo> currentIter;
            {
                this.currentScope = VariableScope.this;
                this.currentIter = this.currentScope.nameVariableMap.values().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.currentIter == null) {
                    return false;
                }
                if (!this.currentIter.hasNext()) {
                    this.currentScope = this.currentScope.parent;
                    Iterator<Object> iterator = this.currentIter = this.currentScope == null ? null : this.currentScope.nameVariableMap.values().iterator();
                }
                return this.currentIter != null && this.currentIter.hasNext();
            }

            @Override
            public VariableInfo next() {
                return new VariableInfo(this.currentIter.next(), this.currentScope.scopeNode);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static void findAllInterfaces(ClassNode type, Set<ClassNode> allInterfaces, boolean useResolved) {
        boolean isInterface;
        if (!useResolved) {
            type = type.redirect();
        }
        if (!(isInterface = type.isInterface()) || allInterfaces.add(type)) {
            ClassNode superType;
            ClassNode[] interfaces;
            ClassNode[] classNodeArray = interfaces = !useResolved ? type.getInterfaces() : type.getUnresolvedInterfaces();
            if (interfaces != null && interfaces.length > 0) {
                LinkedList<ClassNode> deque = new LinkedList<ClassNode>();
                ClassNode[] classNodeArray2 = interfaces;
                int n = interfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode face = classNodeArray2[n2];
                    if (Traits.isTrait(face)) {
                        deque.addFirst(face);
                    } else {
                        deque.addLast(face);
                    }
                    ++n2;
                }
                for (ClassNode face : deque) {
                    VariableScope.findAllInterfaces(face, allInterfaces, useResolved);
                }
            }
            if (!isInterface && (superType = type.getSuperClass()) != null && !superType.equals(OBJECT_CLASS_NODE)) {
                VariableScope.findAllInterfaces(superType, allInterfaces, useResolved);
            }
        }
    }

    public static void createTypeHierarchy(ClassNode type, Set<ClassNode> allClasses, boolean useResolved) {
        if (!useResolved) {
            type = type.redirect();
        }
        if (!allClasses.contains(type)) {
            if (!type.isInterface()) {
                allClasses.add(type);
                ClassNode superClass = useResolved ? type.getUnresolvedSuperClass() : type.getSuperClass();
                if (superClass != null) {
                    VariableScope.createTypeHierarchy(superClass, allClasses, useResolved);
                }
            }
            VariableScope.findAllInterfaces(type, allClasses, useResolved);
        }
    }

    public static ClassNode extractElementType(ClassNode type) {
        block24: {
            if (type.isArray()) {
                return type.getComponentType();
            }
            MethodNode method = GroovyUtils.getMethod(type, "iterator", Parameter.EMPTY_ARRAY);
            if (method == null) {
                if (GeneralUtils.isOrImplements(type, MAP_CLASS_NODE)) {
                    method = GroovyUtils.getMethod(type, "entrySet", Parameter.EMPTY_ARRAY);
                } else if (GeneralUtils.isOrImplements(type, ITERATOR_CLASS_NODE)) {
                    method = GroovyUtils.getMethod(type, "next", Parameter.EMPTY_ARRAY);
                } else if (GeneralUtils.isOrImplements(type, ENUMERATION_CLASS_NODE)) {
                    method = GroovyUtils.getMethod(type, "nextElement", Parameter.EMPTY_ARRAY);
                }
            }
            if (method == null) break block24;
            GenericsMapper mapper = GenericsMapper.gatherGenerics(Collections.EMPTY_LIST, type, method, new GenericsType[0]);
            ClassNode returnType = VariableScope.resolveTypeParameterization(mapper, VariableScope.clone(method.getReturnType()));
            switch (method.getName()) {
                case "iterator": {
                    if (GeneralUtils.isOrImplements(type, ITERABLE_CLASS_NODE)) {
                        GenericsType[] generics = GroovyUtils.getGenericsTypes(returnType);
                        if (generics.length == 1) {
                            return generics[0].getType();
                        }
                        return OBJECT_CLASS_NODE;
                    }
                    return VariableScope.extractElementType(returnType);
                }
                case "entrySet": {
                    GenericsType[] generics = GroovyUtils.getGenericsTypes(returnType);
                    if (generics.length == 1) {
                        return generics[0].getType();
                    }
                    return GenericsUtils.nonGeneric(ENTRY_CLASS_NODE);
                }
            }
            if (GroovyUtils.getBaseType(returnType).isGenericsPlaceHolder()) {
                return GenericsUtils.nonGeneric(returnType);
            }
            return returnType;
        }
        if (GeneralUtils.isOrImplements(type, INPUT_STREAM_CLASS_NODE) || GeneralUtils.isOrImplements(type, DATA_INPUT_STREAM_CLASS_NODE)) {
            return BYTE_CLASS_NODE;
        }
        if (GeneralUtils.isOrImplements(type, READER_CLASS_NODE)) {
            return STRING_CLASS_NODE;
        }
        if (MATCHER_CLASS_NODE.equals(type)) {
            return OBJECT_CLASS_NODE;
        }
        return type;
    }

    public static ClassNode extractSpreadType(ClassNode type) {
        ClassNode elementType = VariableScope.extractElementType(type);
        if (!GeneralUtils.isOrImplements(type, MAP_CLASS_NODE)) {
            while (GeneralUtils.isOrImplements(elementType, COLLECTION_CLASS_NODE)) {
                ClassNode collectionType = elementType;
                if ((elementType = VariableScope.extractElementType(collectionType)) == collectionType) break;
            }
        }
        return elementType;
    }

    public static boolean isPlainClosure(ClassNode type) {
        return CLOSURE_CLASS_NODE.equals(type) && type.getGenericsTypes() == null;
    }

    public static boolean isParameterizedClosure(ClassNode type) {
        return CLOSURE_CLASS_NODE.equals(type) && type.getGenericsTypes() != null;
    }

    public static boolean isThisOrSuper(Variable var) {
        return var.getName().equals("this") || var.getName().equals("super");
    }

    public static boolean isVoidOrObject(ClassNode type) {
        return VOID_CLASS_NODE.equals(type) || OBJECT_CLASS_NODE.equals(type);
    }

    public static class CallAndType {
        public final MethodCall call;
        public final ASTNode declaration;
        public final ClassNode declaringType;
        private Map<ClosureExpression, Object[]> delegatesTo;

        public CallAndType(MethodCall call, ASTNode declaration, ClassNode declaringType, ModuleNode enclosingModule) {
            MethodNode methodNode;
            Parameter[] parameters;
            this.call = call;
            this.declaration = declaration;
            this.declaringType = declaringType;
            if (declaration instanceof MethodNode && (parameters = (methodNode = (MethodNode)declaration).getParameters()) != null && parameters.length > 0) {
                List<Expression> arguments = null;
                if (call.getArguments() instanceof TupleExpression) {
                    arguments = ((TupleExpression)call.getArguments()).getExpressions();
                }
                if (arguments != null && !arguments.isEmpty()) {
                    if (!methodNode.getDeclaringClass().equals(this.getPerceivedDeclaringType())) {
                        ArrayList<Expression> categoryMethodArguments = new ArrayList<Expression>(arguments.size() + 1);
                        categoryMethodArguments.add(new ClassExpression(declaringType));
                        categoryMethodArguments.addAll(arguments);
                        arguments = categoryMethodArguments;
                    }
                    int i = 0;
                    int n = parameters.length;
                    while (i < n) {
                        List<AnnotationNode> annotations = parameters[i].getAnnotations();
                        if (annotations != null && !annotations.isEmpty()) {
                            for (AnnotationNode annotation : annotations) {
                                if (!annotation.getClassNode().getName().equals(DELEGATES_TO.getName()) || i >= arguments.size() || !(arguments.get(i) instanceof ClosureExpression)) continue;
                                ClosureExpression closure = (ClosureExpression)arguments.get(i);
                                CompilerConfiguration config = enclosingModule.getUnit().getConfig();
                                Expression delegatesToType = annotation.getMember("type");
                                Expression delegatesToValue = annotation.getMember("value");
                                Expression delegatesToTarget = annotation.getMember("target");
                                Expression delegatesToStrategy = annotation.getMember("strategy");
                                Expression delegatesToGenericTypeIndex = annotation.getMember("genericTypeIndex");
                                String typeName = delegatesToType != null ? (String)StaticTypeCheckingSupport.evaluateExpression(GeneralUtils.castX(STRING_CLASS_NODE, delegatesToType), config) : null;
                                Integer strategy = delegatesToStrategy != null ? (Integer)StaticTypeCheckingSupport.evaluateExpression(GeneralUtils.castX(INTEGER_CLASS_NODE, delegatesToStrategy), config) : null;
                                Integer generics = delegatesToGenericTypeIndex != null ? (Integer)StaticTypeCheckingSupport.evaluateExpression(GeneralUtils.castX(INTEGER_CLASS_NODE, delegatesToGenericTypeIndex), config) : null;
                                if (delegatesToValue instanceof ClassExpression && !delegatesToValue.getType().getName().equals("groovy.lang.DelegatesTo$Target")) {
                                    this.addDelegatesToClosure(closure, delegatesToValue.getType(), strategy);
                                    continue;
                                }
                                if (typeName != null && !typeName.isEmpty()) {
                                    CompilationUnit compilationUnit = null;
                                    if (enclosingModule.getContext() instanceof EclipseSourceUnit) {
                                        compilationUnit = ((EclipseSourceUnit)enclosingModule.getContext()).resolver.compilationUnit;
                                    }
                                    ClassNode[] resolved = GenericsUtils.parseClassNodesFromString(typeName, enclosingModule.getContext(), compilationUnit, methodNode, delegatesToType);
                                    this.addDelegatesToClosure(closure, resolved[0], strategy);
                                    continue;
                                }
                                if (delegatesToValue != null && (!(delegatesToValue instanceof ClassExpression) || !delegatesToValue.getType().getName().equals("groovy.lang.DelegatesTo$Target"))) continue;
                                try {
                                    String targetName = (String)(delegatesToTarget != null ? StaticTypeCheckingSupport.evaluateExpression(GeneralUtils.castX(STRING_CLASS_NODE, delegatesToTarget), config) : DelegatesTo.class.getMethod("target", new Class[0]).getDefaultValue());
                                    int j = CallAndType.indexOfDelegatesToTarget(parameters, targetName, config);
                                    if (j < 0 || j >= arguments.size()) continue;
                                    Expression target = arguments.get(j);
                                    ClassNode targetType = target.getType();
                                    if (!targetType.isDerivedFrom(parameters[j].getType())) {
                                        targetType = parameters[j].getType();
                                    }
                                    if (generics != null && generics >= 0 && targetType.getGenericsTypes() != null) {
                                        targetType.getGenericsTypes()[generics].getType();
                                    }
                                    this.addDelegatesToClosure(closure, targetType, strategy);
                                }
                                catch (NoSuchMethodException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        ++i;
                    }
                    if (this.delegatesTo == null) {
                        if (arguments.get(0) instanceof ClosureExpression && methodNode.getName().matches("build|do(Later|Outside)|edt(Builder)?") && methodNode.getDeclaringClass().getName().equals("groovy.swing.SwingBuilder")) {
                            this.addDelegatesToClosure((ClosureExpression)arguments.get(0), methodNode.getDeclaringClass(), 0);
                        } else if (arguments.size() > 1 && arguments.get(1) instanceof ClosureExpression && methodNode.getName().matches("identity|with") && DGM_CLASS_NODE.equals(methodNode.getDeclaringClass())) {
                            this.addDelegatesToClosure((ClosureExpression)arguments.get(1), declaringType, 1);
                        }
                    }
                }
            }
            if (this.delegatesTo == null) {
                this.delegatesTo = Collections.emptyMap();
            }
        }

        public ClassNode getPerceivedDeclaringType() {
            if (this.declaringType.equals(CLASS_CLASS_NODE)) {
                if (this.declaringType.getGenericsTypes() != null) {
                    GenericsType genericsType = this.declaringType.getGenericsTypes()[0];
                    return genericsType.getType();
                }
                return OBJECT_CLASS_NODE;
            }
            return this.declaringType;
        }

        public ClassNode getDelegateType(ClosureExpression closure) {
            Object[] tuple = this.delegatesTo.get(closure);
            return tuple != null ? (ClassNode)tuple[0] : null;
        }

        public int getResolveStrategy(ClosureExpression closure) {
            Object[] tuple = this.delegatesTo.get(closure);
            return tuple != null && tuple[1] != null ? (Integer)tuple[1] : 0;
        }

        private void addDelegatesToClosure(ClosureExpression closure, ClassNode delegateType, Integer resolveStrategy) {
            if (this.delegatesTo == null) {
                this.delegatesTo = new HashMap<ClosureExpression, Object[]>();
            }
            this.delegatesTo.put(closure, new Object[]{delegateType, resolveStrategy});
        }

        private static int indexOfDelegatesToTarget(Parameter[] parameters, String target, CompilerConfiguration config) throws NoSuchMethodException {
            int i = 0;
            int n = parameters.length;
            while (i < n) {
                List<AnnotationNode> annotations = parameters[i].getAnnotations();
                if (annotations != null && !annotations.isEmpty()) {
                    for (AnnotationNode annotation : annotations) {
                        String value;
                        if (!annotation.getClassNode().getName().equals("groovy.lang.DelegatesTo$Target") || !(value = (String)(annotation.getMember("value") != null ? StaticTypeCheckingSupport.evaluateExpression(GeneralUtils.castX(STRING_CLASS_NODE, annotation.getMember("value")), config) : DelegatesTo.Target.class.getMethod("value", new Class[0]).getDefaultValue())).equals(target)) continue;
                        return i;
                    }
                }
                ++i;
            }
            return -1;
        }
    }

    private static class SharedState {
        private final Map<String, Object> wormhole = new HashMap<String, Object>();
        private final List<CallAndType> enclosingCallStack = new ArrayList<CallAndType>();
        private final LinkedList<ASTNode> nodeStack = new LinkedList();
        private boolean isRunMethod;

        private SharedState() {
        }
    }

    public static class VariableInfo {
        public ASTNode scopeNode;
        public final String name;
        public final ClassNode type;
        public final ClassNode declaringType;

        public VariableInfo(String name, ClassNode type, ClassNode declaringType) {
            this.name = name;
            this.type = type;
            this.declaringType = declaringType;
        }

        private VariableInfo(VariableInfo info, ASTNode node) {
            this(info.name, info.type, info.declaringType);
            this.scopeNode = info.scopeNode != null ? info.scopeNode : node;
        }

        public String getTypeSignature() {
            return GroovyUtils.getTypeSignature(this.type, true, false);
        }
    }
}

