/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovyx.net.http.HTTPBuilder;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncHTTPBuilder
extends HTTPBuilder {
    public static final int DEFAULT_POOL_SIZE = 4;
    protected final ThreadPoolExecutor threadPool = (ThreadPoolExecutor)Executors.newCachedThreadPool();

    public AsyncHTTPBuilder(Map<String, ?> args) throws URISyntaxException {
        Object defaultContentType;
        Object poolSize = args.get("poolSize");
        if (poolSize == null) {
            poolSize = 4;
        }
        this.initThreadPools((Integer)poolSize);
        Object defaultURL = args.get("url");
        if (defaultURL != null) {
            super.setURL(defaultURL);
        }
        if ((defaultContentType = args.get("contentType")) != null) {
            super.setContentType(defaultContentType);
        }
    }

    @Override
    protected Future<?> doRequest(final HTTPBuilder.SendDelegate delegate) {
        return this.threadPool.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    return AsyncHTTPBuilder.this.doRequestSuper(delegate);
                }
                catch (Exception ex) {
                    AsyncHTTPBuilder.this.log.error((Object)("Exception thrown from request delegate: " + delegate), (Throwable)ex);
                    throw ex;
                }
            }
        });
    }

    private Object doRequestSuper(HTTPBuilder.SendDelegate delegate) throws IOException {
        return super.doRequest(delegate);
    }

    protected void initThreadPools(int poolSize) {
        if (poolSize < 1) {
            throw new IllegalArgumentException("poolSize may not be < 1");
        }
        BasicHttpParams params = this.client != null ? this.client.getParams() : new BasicHttpParams();
        ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)poolSize);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)new ConnPerRouteBean(poolSize));
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
        this.client = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)params);
        this.threadPool.setMaximumPoolSize(poolSize);
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPool;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.threadPool.shutdown();
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }
}

