/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovy.lang.Closure;
import groovy.util.XmlSlurper;
import groovy.util.slurpersupport.GPathResult;
import groovyx.net.http.ContentType;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.json.JSON;
import net.sf.json.groovy.JsonSlurper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.MethodClosure;
import org.cyberneko.html.parsers.SAXParser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserRegistry {
    protected Closure defaultParser = new MethodClosure((Object)this, "parseStream");
    protected final Log log = LogFactory.getLog(this.getClass());
    protected Map<String, Closure> registeredParsers = this.buildDefaultParserMap();

    public static String getCharset(HttpResponse resp) {
        NameValuePair charset = resp.getEntity().getContentType().getElements()[0].getParameterByName("charset");
        return charset == null || charset.getValue().trim().equals("") ? Charset.defaultCharset().name() : charset.getValue();
    }

    public static String getContentType(HttpResponse resp) {
        return resp.getEntity().getContentType().getElements()[0].getName();
    }

    public InputStream parseStream(HttpResponse resp) throws IOException {
        return resp.getEntity().getContent();
    }

    public Reader parseText(HttpResponse resp) throws IOException {
        return new InputStreamReader(resp.getEntity().getContent(), ParserRegistry.getCharset(resp));
    }

    public Map<String, String> parseForm(HttpResponse resp) throws IOException {
        List params = URLEncodedUtils.parse((HttpEntity)resp.getEntity());
        HashMap<String, String> paramMap = new HashMap<String, String>(params.size());
        for (NameValuePair param : params) {
            paramMap.put(param.getName(), param.getValue());
        }
        return paramMap;
    }

    public GPathResult parseHTML(HttpResponse resp) throws IOException, SAXException {
        return new XmlSlurper((XMLReader)new SAXParser()).parse(this.parseText(resp));
    }

    public GPathResult parseXML(HttpResponse resp) throws IOException, SAXException, ParserConfigurationException {
        return new XmlSlurper().parse(this.parseText(resp));
    }

    public JSON parseJSON(HttpResponse resp) throws IOException {
        String jsonTxt = DefaultGroovyMethods.getText((Reader)this.parseText(resp));
        return new JsonSlurper().parseText(jsonTxt);
    }

    public void register(String contentType, Closure closure) {
        this.registeredParsers.put(contentType, closure);
    }

    Closure get(String contentType) {
        Closure parser = this.registeredParsers.get(contentType);
        if (parser == null) {
            this.log.warn((Object)("Cannot find parser for content-type: " + contentType + " -- using default parser."));
            parser = this.defaultParser;
        }
        return parser;
    }

    protected Map<String, Closure> buildDefaultParserMap() {
        HashMap<String, Closure> parsers = new HashMap<String, Closure>();
        parsers.put(ContentType.BINARY.toString(), (Closure)new MethodClosure((Object)this, "parseStream"));
        parsers.put(ContentType.TEXT.toString(), (Closure)new MethodClosure((Object)this, "parseText"));
        parsers.put(ContentType.URLENC.toString(), (Closure)new MethodClosure((Object)this, "parseForm"));
        parsers.put(ContentType.HTML.toString(), (Closure)new MethodClosure((Object)this, "parseHTML"));
        MethodClosure pClosure = new MethodClosure((Object)this, "parseXML");
        for (String ct : ContentType.XML.getContentTypeStrings()) {
            parsers.put(ct, (Closure)pClosure);
        }
        pClosure = new MethodClosure((Object)this, "parseJSON");
        for (String ct : ContentType.JSON.getContentTypeStrings()) {
            parsers.put(ct, (Closure)pClosure);
        }
        return parsers;
    }
}

