/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class TimestampPropertyMojo
extends AbstractMojo {
    private MavenProject project;
    private String name;
    private String pattern;
    private String timeZone;
    private int offset;
    private String unit;
    private String locale;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        DateFormat format;
        Locale locale;
        if (this.locale != null) {
            String[] bits = this.locale.split("[,_]");
            if (bits.length == 1) {
                locale = new Locale(bits[0].trim());
            } else if (bits.length == 2) {
                locale = new Locale(bits[0].trim(), bits[1].trim());
            } else {
                if (bits.length != 3) throw new MojoExecutionException("expecting language,country,variant but got more than three parts");
                locale = new Locale(bits[0].trim(), bits[1].trim(), bits[2].trim());
            }
        } else {
            locale = Locale.getDefault();
            this.getLog().warn((CharSequence)("Using platform locale (" + locale.toString() + " actually) to format date/time, i.e. build is platform dependent!"));
        }
        if (this.pattern == null) {
            format = DateFormat.getDateTimeInstance(3, 3, locale);
        } else {
            try {
                format = new SimpleDateFormat(this.pattern, locale);
            }
            catch (IllegalArgumentException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        TimeZone timeZone = this.timeZone != null ? TimeZone.getTimeZone(this.timeZone) : TimeZone.getTimeZone("GMT");
        Date now = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(now);
        ((Calendar)calendar).setTimeZone(timeZone);
        if (this.offset != 0 && this.unit != null) {
            this.unit = this.unit.toLowerCase();
            if (this.unit.indexOf("millisecond") == 0) {
                ((Calendar)calendar).add(14, this.offset);
            } else if (this.unit.indexOf("second") == 0) {
                ((Calendar)calendar).add(13, this.offset);
            } else if (this.unit.indexOf("minute") == 0) {
                ((Calendar)calendar).add(12, this.offset);
            } else if (this.unit.indexOf("hour") == 0) {
                ((Calendar)calendar).add(10, this.offset);
            } else if (this.unit.indexOf("day") == 0) {
                ((Calendar)calendar).add(5, this.offset);
            } else if (this.unit.indexOf("week") == 0) {
                ((Calendar)calendar).add(3, this.offset);
            } else if (this.unit.indexOf("month") == 0) {
                ((Calendar)calendar).add(2, this.offset);
            } else if (this.unit.indexOf("year") == 0) {
                ((Calendar)calendar).add(1, this.offset);
            }
        }
        format.setTimeZone(timeZone);
        String value = format.format(calendar.getTime());
        this.getLog().info((CharSequence)("Setting property '" + this.name + "' to '" + value + "'."));
        this.project.getProperties().setProperty(this.name, value);
    }
}

