/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper.versioning;

import org.codehaus.mojo.buildhelper.versioning.VersionInformation;
import org.codehaus.mojo.buildhelper.versioning.Versioning;

public class DefaultVersioning
implements Versioning {
    private VersionInformation vi;
    private String version;
    private boolean snapshot;

    public DefaultVersioning(String version) {
        this.version = version;
        this.vi = new VersionInformation(version);
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean isSnapshot() {
        return this.snapshot;
    }

    @Override
    public int getMajor() {
        return this.vi.getMajor();
    }

    @Override
    public int getMinor() {
        return this.vi.getMinor();
    }

    @Override
    public int getPatch() {
        return this.vi.getPatch();
    }

    @Override
    public String getAsOSGiVersion() {
        StringBuffer osgiVersion = new StringBuffer();
        osgiVersion.append(this.getMajor());
        osgiVersion.append("." + this.getMinor());
        osgiVersion.append("." + this.getPatch());
        if (this.getQualifier() != null || this.getBuildNumber() != 0) {
            osgiVersion.append(".");
            if (this.getBuildNumber() != 0) {
                osgiVersion.append(this.getBuildNumber());
            }
            if (this.getQualifier() != null) {
                String qualifier = this.getQualifier().replaceAll("\\.", "_");
                osgiVersion.append(qualifier);
            }
        }
        return osgiVersion.toString();
    }

    @Override
    public int getBuildNumber() {
        return this.vi.getBuildNumber();
    }

    @Override
    public String getQualifier() {
        return this.vi.getQualifier();
    }
}

