/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import java.util.HashSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.buildhelper.Artifact;

@Mojo(name="attach-artifact", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class AttachArtifactMojo
extends AbstractMojo {
    @Parameter(required=true)
    private Artifact[] artifacts;
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="buildhelper.runOnlyAtExecutionRoot", defaultValue="false")
    private boolean runOnlyAtExecutionRoot;
    @Parameter(property="buildhelper.skipAttach", defaultValue="false")
    private boolean skipAttach;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipAttach) {
            this.getLog().info((CharSequence)"Skip attaching artifacts");
            return;
        }
        if (this.runOnlyAtExecutionRoot && !this.project.isExecutionRoot()) {
            this.getLog().info((CharSequence)"Skip attaching artifacts in this project because it's not the Execution Root");
        } else {
            this.validateArtifacts();
            for (Artifact artifact : this.artifacts) {
                this.projectHelper.attachArtifact(this.project, artifact.getType(), artifact.getClassifier(), artifact.getFile());
            }
        }
    }

    private void validateArtifacts() throws MojoFailureException {
        HashSet<String> extensionClassifiers = new HashSet<String>();
        for (Artifact artifact : this.artifacts) {
            String extensionClassifier = artifact.getType() + ":" + artifact.getClassifier();
            if (extensionClassifiers.add(extensionClassifier)) continue;
            throw new MojoFailureException("The artifact with same type and classifier: " + extensionClassifier + " is used more than once.");
        }
    }
}

