/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.shared.filters.pattern;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.codehaus.mojo.jaxb2.AbstractJaxbMojo;
import org.codehaus.mojo.jaxb2.shared.Validate;
import org.codehaus.mojo.jaxb2.shared.filters.AbstractFilter;
import org.codehaus.mojo.jaxb2.shared.filters.pattern.StringConverter;
import org.codehaus.mojo.jaxb2.shared.filters.pattern.ToStringConverter;

public abstract class AbstractPatternFilter<T>
extends AbstractFilter<T> {
    private boolean acceptCandidateOnPatternMatch = true;
    private StringConverter<T> converter = new ToStringConverter();
    private List<Pattern> regularExpressions;
    private String patternPrefix;
    private List<String> patterns;

    public final void setPatternPrefix(String patternPrefix) {
        this.validateDiSetterCalledBeforeInitialization("patternPrefix");
        if (patternPrefix != null) {
            this.patternPrefix = patternPrefix;
        } else {
            this.addDelayedLogMessage("warn", "Received null patternPrefix for configuring AbstractPatternFilter of type [" + this.getClass().getName() + "]. Ignoring and proceeding.");
        }
    }

    public void setPatterns(List<String> patterns) {
        this.validateDiSetterCalledBeforeInitialization("patternPrefix");
        if (patterns != null) {
            this.patterns = new ArrayList<String>();
            this.patterns.addAll(patterns);
        } else {
            this.addDelayedLogMessage("warn", "Received null patterns for configuring AbstractPatternFilter of type [" + this.getClass().getName() + "]. Ignoring and proceeding.");
        }
    }

    public final void setAcceptCandidateOnPatternMatch(boolean acceptCandidateOnPatternMatch) {
        this.validateDiSetterCalledBeforeInitialization("acceptCandidateOnPatternMatch");
        this.acceptCandidateOnPatternMatch = acceptCandidateOnPatternMatch;
    }

    public void setConverter(StringConverter<T> converter) {
        Validate.notNull(converter, "converter");
        this.validateDiSetterCalledBeforeInitialization("converter");
        this.converter = converter;
    }

    @Override
    protected void onInitialize() {
        if (this.patterns == null && this.log.isWarnEnabled()) {
            this.log.warn((CharSequence)("No Patterns configured for AbstractPatternFilter [" + this.getClass().getName() + "]. This could imply a configuration problem."));
        } else {
            this.regularExpressions = AbstractPatternFilter.convert(this.patterns, this.patternPrefix);
        }
    }

    @Override
    protected boolean onCandidate(T nonNullCandidate) {
        String candidateString = this.convert(nonNullCandidate);
        boolean atLeastOnePatternMatched = false;
        if (this.regularExpressions != null) {
            for (Pattern current : this.regularExpressions) {
                if (!current.matcher(candidateString).matches()) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("CandidateString [" + candidateString + "] matched pattern [" + current.pattern() + "]"));
                }
                atLeastOnePatternMatched = true;
                break;
            }
        }
        return this.acceptCandidateOnPatternMatch ? atLeastOnePatternMatched : !atLeastOnePatternMatched;
    }

    protected String convert(T nonNullT) {
        return this.converter.convert(nonNullT);
    }

    public static List<Pattern> convert(List<String> patternStrings, String prepend) {
        List<String> effectivePatternStrings = patternStrings;
        if (patternStrings == null) {
            effectivePatternStrings = new ArrayList<String>();
            effectivePatternStrings.add(".*");
        }
        String effectivePrepend = prepend == null ? "" : prepend;
        ArrayList<Pattern> toReturn = new ArrayList<Pattern>();
        for (String current : effectivePatternStrings) {
            toReturn.add(Pattern.compile(effectivePrepend + current, 66));
        }
        return toReturn;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("|        Accept on match: [").append(this.acceptCandidateOnPatternMatch).append("]\n");
        builder.append("|        Initialized    : [").append(this.isInitialized()).append("]\n");
        List<Pattern> effectivePatterns = this.isInitialized() ? this.regularExpressions : AbstractPatternFilter.convert(this.patterns, this.patternPrefix);
        int numPatterns = effectivePatterns != null && effectivePatterns.size() > 0 ? effectivePatterns.size() : 0;
        builder.append("|        ").append(numPatterns).append(" regularExpressions ");
        if (numPatterns > 0) {
            builder.append(":\n");
            for (int i = 0; i < effectivePatterns.size(); ++i) {
                String prefix = "|         [" + (i + 1) + "/" + effectivePatterns.size() + "]: ";
                builder.append(prefix).append(effectivePatterns.get(i).pattern()).append("\n");
            }
        } else {
            builder.append("\n");
        }
        return builder.toString().substring(0, builder.length() - 1).replace("\n", AbstractJaxbMojo.NEWLINE);
    }
}

