/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.keytool;

import java.io.File;
import org.codehaus.mojo.keytool.AbstractKeyToolRequestMojo;
import org.codehaus.mojo.keytool.KeyToolRequestWithKeyStoreParameters;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.Commandline;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractKeyToolRequestWithKeyStoreParametersMojo<R extends KeyToolRequestWithKeyStoreParameters>
extends AbstractKeyToolRequestMojo<R> {
    private String keystore;
    private String storetype;
    private String storepass;
    private String providername;
    private String providerclass;
    private String providerarg;
    private String providerpath;

    public AbstractKeyToolRequestWithKeyStoreParametersMojo(Class<R> requestType) {
        super(requestType);
    }

    @Override
    protected R createKeytoolRequest() {
        KeyToolRequestWithKeyStoreParameters request = (KeyToolRequestWithKeyStoreParameters)super.createKeytoolRequest();
        String keystoreFile = this.keystore;
        if (StringUtils.isNotEmpty((String)this.keystore)) {
            this.createParentDirIfNecessary(this.keystore);
            request.setKeystore(this.keystore);
        }
        request.setProviderarg(this.providerarg);
        request.setProviderclass(this.providerclass);
        request.setProvidername(this.providername);
        request.setProviderpath(this.providerpath);
        request.setStorepass(this.storepass);
        request.setStoretype(this.storetype);
        return (R)request;
    }

    @Override
    protected String getCommandlineInfo(Commandline commandLine) {
        String commandLineInfo = super.getCommandlineInfo(commandLine);
        commandLineInfo = StringUtils.replace((String)commandLineInfo, (String)this.storepass, (String)"'*****'");
        return commandLineInfo;
    }

    protected final void createParentDirIfNecessary(String file) {
        File fileDir;
        if (file != null && (fileDir = new File(file).getParentFile()) != null) {
            boolean mkdirs = fileDir.mkdirs();
            this.getLog().debug((CharSequence)("mdkirs: " + mkdirs + " " + fileDir));
        }
    }
}

