/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.properties;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractWritePropertiesMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(required=true)
    private File outputFile;

    protected void writeProperties(Properties properties, File file) throws MojoExecutionException {
        try {
            this.storeWithoutTimestamp(properties, file, "Properties");
        }
        catch (FileNotFoundException e) {
            this.getLog().error((CharSequence)("Could not create FileOutputStream: " + file));
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Error writing properties: " + file));
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void storeWithoutTimestamp(Properties properties, File outputFile, String comments) throws IOException {
        try (PrintWriter pw = new PrintWriter(outputFile, "ISO-8859-1");
             StringWriter sw = new StringWriter();){
            properties.store(sw, comments);
            comments = '#' + comments;
            ArrayList<String> lines = new ArrayList<String>();
            try (BufferedReader r = new BufferedReader(new StringReader(sw.toString()));){
                String line;
                while ((line = r.readLine()) != null) {
                    if (line.startsWith("#") && !line.equals(comments)) continue;
                    lines.add(line);
                }
            }
            Collections.sort(lines);
            for (String l : lines) {
                pw.println(l);
            }
        }
    }

    protected void validateOutputFile() throws MojoExecutionException {
        if (this.outputFile.isDirectory()) {
            throw new MojoExecutionException("outputFile must be a file and not a directory");
        }
        if (this.outputFile.getParentFile() != null) {
            this.outputFile.getParentFile().mkdirs();
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public File getOutputFile() {
        return this.outputFile;
    }
}

