/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.versions.AbstractVersionsReport;
import org.codehaus.mojo.versions.PluginUpdatesDetails;
import org.codehaus.mojo.versions.PluginUpdatesRenderer;
import org.codehaus.mojo.versions.PluginUpdatesXmlRenderer;
import org.codehaus.mojo.versions.utils.MiscUtils;
import org.codehaus.mojo.versions.utils.PluginComparator;

@Mojo(name="plugin-updates-report", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class PluginUpdatesReport
extends AbstractVersionsReport {
    @Parameter(property="pluginUpdatesReportFormats", defaultValue="html")
    private String[] formats = new String[]{"html"};
    @Parameter(property="onlyProjectPlugins", defaultValue="false")
    protected boolean onlyProjectPlugins;
    @Parameter(property="onlyUpgradable", defaultValue="false")
    protected boolean onlyUpgradable;

    public boolean isExternalReport() {
        return false;
    }

    public boolean canGenerateReport() {
        return this.haveBuildPlugins() || this.haveBuildPluginManagementPlugins();
    }

    private boolean haveBuildPluginManagementPlugins() {
        return this.getProject().getBuild() != null && this.getProject().getBuild().getPluginManagement() != null && this.getProject().getBuild().getPluginManagement().getPlugins() != null && !this.getProject().getBuild().getPluginManagement().getPlugins().isEmpty();
    }

    private boolean haveBuildPlugins() {
        return this.getProject().getBuild() != null && this.getProject().getBuild().getPlugins() != null && !this.getProject().getBuild().getPlugins().isEmpty();
    }

    @Override
    protected void doGenerateReport(Locale locale, Sink sink) throws MavenReportException {
        TreeSet<Object> pluginManagement = new TreeSet<Object>(new PluginComparator());
        if (this.haveBuildPluginManagementPlugins()) {
            pluginManagement.addAll(this.getProject().getBuild().getPluginManagement().getPlugins());
        }
        TreeSet<Object> plugins = new TreeSet<Object>(new PluginComparator());
        if (this.haveBuildPlugins()) {
            plugins.addAll(this.getProject().getBuild().getPlugins());
        }
        PluginComparator comparator = new PluginComparator();
        if (!this.onlyProjectPlugins) {
            plugins.removeIf(plugin -> pluginManagement.stream().anyMatch(pmPlugin -> comparator.compare(plugin, pmPlugin) == 0));
        } else {
            pluginManagement.removeIf(pmPlugin -> plugins.stream().noneMatch(plugin -> comparator.compare(plugin, pmPlugin) == 0));
        }
        try {
            Map<Plugin, PluginUpdatesDetails> pluginUpdates = this.getHelper().lookupPluginsUpdates(plugins, this.getAllowSnapshots());
            Map<Plugin, PluginUpdatesDetails> pluginManagementUpdates = this.getHelper().lookupPluginsUpdates(pluginManagement, this.getAllowSnapshots());
            if (this.onlyUpgradable) {
                pluginUpdates = MiscUtils.filter(pluginUpdates, plugin -> plugin.getArtifactVersions().getVersions().length > 1);
                pluginManagementUpdates = MiscUtils.filter(pluginManagementUpdates, plugin -> plugin.getArtifactVersions().getVersions().length > 1);
            }
            for (String format : this.formats) {
                if ("html".equals(format)) {
                    PluginUpdatesRenderer renderer = new PluginUpdatesRenderer(sink, this.getI18n(), this.getOutputName(), locale, pluginUpdates, pluginManagementUpdates);
                    renderer.render();
                    continue;
                }
                if (!"xml".equals(format)) continue;
                File outputDir = new File(this.getProject().getBuild().getDirectory());
                if (!outputDir.exists() && !outputDir.mkdirs()) {
                    throw new MavenReportException("Could not create output directory");
                }
                String outputFile = outputDir.getAbsolutePath() + File.separator + this.getOutputName() + ".xml";
                PluginUpdatesXmlRenderer xmlGenerator = new PluginUpdatesXmlRenderer(pluginUpdates, pluginManagementUpdates, outputFile);
                xmlGenerator.render();
            }
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public String getOutputName() {
        return "plugin-updates-report";
    }
}

