/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.config;

import at.spardat.properties.XProperties;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashSet;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.xml.DefaultBeanDefinitionDocumentReader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ConfigurableBeanDefinitionDocumentReader
extends DefaultBeanDefinitionDocumentReader {
    public static final String PLACEHOLDER_PREFIX = "${";
    public static final String PLACEHOLDER_SUFFIX = "}";

    protected void importBeanDefinitionResource(Element ele) {
        block11: {
            String location = ele.getAttribute("resource");
            if (!StringUtils.hasText((String)location)) {
                this.getReaderContext().error("Resource location must not be empty", (Object)ele);
                return;
            }
            location = this.resolvePlaceholders(location);
            boolean optional = this.isOptional(ele, location);
            if (ResourcePatternUtils.isUrl((String)location)) {
                try {
                    LinkedHashSet actualResources = new LinkedHashSet(4);
                    int importCount = this.getReaderContext().getReader().loadBeanDefinitions(location, actualResources);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Imported " + importCount + " bean definitions from URL location [" + location + "]"));
                    }
                    Resource[] actResArray = actualResources.toArray(new Resource[actualResources.size()]);
                    this.getReaderContext().fireImportProcessed(location, actResArray, this.extractSource(ele));
                }
                catch (BeanDefinitionStoreException ex) {
                    if (!optional) {
                        this.getReaderContext().error("Failed to import bean definitions from URL location [" + location + "]", (Object)ele, (Throwable)ex);
                    }
                    break block11;
                }
            }
            try {
                Resource relativeResource = this.getReaderContext().getResource().createRelative(location);
                int importCount = this.getReaderContext().getReader().loadBeanDefinitions(relativeResource);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Imported " + importCount + " bean definitions from relative location [" + location + "]"));
                }
                this.getReaderContext().fireImportProcessed(location, new Resource[]{relativeResource}, this.extractSource(ele));
            }
            catch (IOException ex) {
                if (!optional) {
                    this.getReaderContext().error("Invalid relative resource location [" + location + "] to import bean definitions from", (Object)ele, (Throwable)ex);
                }
            }
            catch (BeanDefinitionStoreException ex) {
                if (optional) break block11;
                this.getReaderContext().error("Failed to import bean definitions from relative location [" + location + "]", (Object)ele, (Throwable)ex);
            }
        }
    }

    public String resolvePlaceholders(String text) {
        StringBuffer buf = new StringBuffer(text);
        int startIndex = buf.indexOf(PLACEHOLDER_PREFIX);
        while (startIndex != -1) {
            int endIndex = buf.indexOf(PLACEHOLDER_SUFFIX, startIndex + PLACEHOLDER_PREFIX.length());
            if (endIndex != -1) {
                String placeholder = buf.substring(startIndex + PLACEHOLDER_PREFIX.length(), endIndex);
                int nextIndex = endIndex + PLACEHOLDER_SUFFIX.length();
                try {
                    String propVal = System.getProperty(placeholder);
                    if (propVal == null) {
                        propVal = System.getenv(placeholder);
                    }
                    if (propVal == null) {
                        XProperties.getNode(ConfigurableBeanDefinitionDocumentReader.class);
                        propVal = XProperties.getRoot().get(placeholder);
                    }
                    if (propVal != null) {
                        buf.replace(startIndex, endIndex + PLACEHOLDER_SUFFIX.length(), propVal);
                        nextIndex = startIndex + propVal.length();
                    } else {
                        System.err.println("Could not resolve placeholder '" + placeholder + "' in [" + text + "] as system property: neither system property, xproperties nor environment variable found");
                    }
                }
                catch (Throwable ex) {
                    System.err.println("Could not resolve placeholder '" + placeholder + "' in [" + text + "] as system or xproperties property: " + ex);
                }
                startIndex = buf.indexOf(PLACEHOLDER_PREFIX, nextIndex);
                continue;
            }
            startIndex = -1;
        }
        return buf.toString();
    }

    private boolean isOptional(Element ele, String location) {
        try {
            URI uri = new URI(location);
            String query = uri.getQuery();
            return query != null && query.split("=").length == 2 && query.split("=")[0].equals("optional") && Boolean.parseBoolean(query.split("=")[1]);
        }
        catch (URISyntaxException ex) {
            this.getReaderContext().warning("Failed to parse URI for location [" + location + "]", (Object)ele, (Throwable)ex);
            return false;
        }
    }
}

