/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.config;

import at.spardat.properties.PropertyData;
import at.spardat.properties.PropertyFileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class XPropertiesPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    protected Properties mergeProperties() throws IOException {
        Properties properties = super.mergeProperties();
        PropertyData propertyData = this.getPropertyData();
        if (propertyData != null) {
            for (Map.Entry entry : propertyData.getPropertiesMap().entrySet()) {
                if (!(entry.getValue() instanceof String)) continue;
                properties.put(entry.getKey(), entry.getValue());
            }
        }
        return properties;
    }

    protected PropertyData getPropertyData() {
        try {
            return PropertyData.getInstance();
        }
        catch (PropertyFileNotFoundException propertyFileNotFoundException) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Could not load XProperties from : " + propertyFileNotFoundException.getMessage()));
            }
            return null;
        }
    }
}

