/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.config;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openxma.dsl.platform.config.XPropertiesPlaceholderConfigurer;
import org.openxma.dsl.platform.config.XProperty;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.util.StringUtils;

public class XPropertyAnnotationPlaceholderConfigurer
extends XPropertiesPlaceholderConfigurer {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties properties) throws BeansException {
        for (String name : beanFactory.getBeanDefinitionNames()) {
            MutablePropertyValues mpv = beanFactory.getBeanDefinition(name).getPropertyValues();
            Class clazz = beanFactory.getType(name);
            if (!this.processClass(clazz)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Configuring properties for bean=" + name + "[" + clazz + "]"));
            }
            for (PropertyDescriptor property : BeanUtils.getPropertyDescriptors((Class)clazz)) {
                Method setter = property.getWriteMethod();
                Method getter = property.getReadMethod();
                XProperty annotation = null;
                if (setter != null && setter.isAnnotationPresent(XProperty.class)) {
                    annotation = setter.getAnnotation(XProperty.class);
                } else if (setter != null && getter != null && getter.isAnnotationPresent(XProperty.class)) {
                    annotation = getter.getAnnotation(XProperty.class);
                }
                if (annotation == null) continue;
                String key = this.getKey(clazz, property.getName(), annotation);
                String value = this.resolvePlaceholder(key, properties, 1);
                if (!StringUtils.hasText((String)value) && !key.equalsIgnoreCase(clazz.getName() + "." + property.getName())) {
                    value = this.resolvePlaceholder(clazz.getName() + "." + property.getName(), properties);
                }
                if (!StringUtils.hasText((String)value)) {
                    value = annotation.defaultValue();
                }
                if (!StringUtils.hasText((String)value)) {
                    throw new BeanDefinitionStoreException("No such property=[" + annotation.key() + "] found in properties.");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Setting property=[" + clazz.getName() + "." + property.getName() + "] value=[" + annotation.key() + "=" + value + "]"));
                }
                mpv.addPropertyValue(property.getName(), (Object)value);
            }
            for (Field field : clazz.getDeclaredFields()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Examining field=[" + clazz.getName() + "." + field.getName() + "]"));
                }
                if (!field.isAnnotationPresent(XProperty.class)) continue;
                XProperty annotation = field.getAnnotation(XProperty.class);
                PropertyDescriptor property = BeanUtils.getPropertyDescriptor((Class)clazz, (String)field.getName());
                if (property.getWriteMethod() == null) {
                    throw new BeanDefinitionStoreException("Setter for property=[" + clazz.getName() + "." + field.getName() + "] not available.");
                }
                String key = this.getKey(clazz, field.getName(), annotation);
                String value = this.resolvePlaceholder(key, properties, 1);
                if (value == null) {
                    value = annotation.defaultValue();
                }
                if (value == null) {
                    throw new BeanDefinitionStoreException("No such property=[" + annotation.key() + "] found in properties.");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Setting property=[" + clazz.getName() + "." + field.getName() + "] value=[" + annotation.key() + "=" + value + "]"));
                }
                mpv.addPropertyValue(property.getName(), (Object)value);
            }
        }
    }

    private String getKey(Class clazz, String field, XProperty annotation) {
        return StringUtils.hasText((String)annotation.key()) ? annotation.key() : clazz.getName() + "." + field;
    }

    private boolean processClass(Class clazz) {
        return clazz != null && !clazz.getName().startsWith("org.springframework");
    }
}

