/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.converter.impl;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.StringConverter;
import org.openxma.dsl.platform.converter.Converter;
import org.openxma.dsl.platform.converter.impl.DateConverter;
import org.openxma.dsl.platform.service.MapperConfig;
import org.openxma.dsl.platform.service.MapperContextHolder;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class DataTypeConverter
implements Converter {
    public static final String DEFAULT_DATE_FORMAT = "DEFAULT_DATE_FORMAT";
    private static final String DEFAULT_TIMESTAMP_FORMAT = "DEFAULT_TIMESTAMP_FORMAT";
    private static final Map<String, DateFormat> dateFormatPatternCache = new ConcurrentHashMap<String, DateFormat>(10, 10.0f, 10);
    private static final Map<String, DateFormat> timestampFormatPatternCache = new ConcurrentHashMap<String, DateFormat>(10, 10.0f, 10);
    private static final org.apache.commons.beanutils.Converter booleanConverter = new BooleanConverter();
    private static final org.apache.commons.beanutils.Converter longConverter = new LongConverter();
    private static final org.apache.commons.beanutils.Converter doubleConverter = new DoubleConverter();
    private static final org.apache.commons.beanutils.Converter floatConverter = new FloatConverter();
    private static final org.apache.commons.beanutils.Converter bigDecimalConverter = new BigDecimalConverter();
    private static final org.apache.commons.beanutils.Converter integerConverter = new IntegerConverter();
    private static final org.apache.commons.beanutils.Converter stringConverter = new StringConverter();
    private String defaultDateFormatPattern;

    @Override
    public void setDefaultDateFormatPattern(String defaultDateFormatPattern) {
        this.defaultDateFormatPattern = defaultDateFormatPattern;
        dateFormatPatternCache.put(DEFAULT_DATE_FORMAT, new SimpleDateFormat(this.defaultDateFormatPattern));
    }

    @Override
    public void resetDefaultDateFormatPattern() {
        dateFormatPatternCache.put(DEFAULT_DATE_FORMAT, new SimpleDateFormat());
    }

    @Override
    public DateFormat getCachedDateFormat(String pattern) {
        return dateFormatPatternCache.get(pattern);
    }

    @Override
    public int getDateFormatPatternCacheSize() {
        return dateFormatPatternCache.size();
    }

    @Override
    public <T> T convert(Class<T> destClass, Object sourceObject) {
        if (sourceObject instanceof Integer) {
            return this.convertInteger(destClass, sourceObject);
        }
        if (sourceObject instanceof String) {
            return this.convertString(destClass, sourceObject);
        }
        if (sourceObject instanceof Timestamp) {
            return this.convertTimestamp(destClass, sourceObject);
        }
        if (sourceObject instanceof Date) {
            return this.convertDate(destClass, sourceObject);
        }
        if (sourceObject instanceof BigDecimal) {
            return this.convertBigDecimal(destClass, sourceObject);
        }
        if (sourceObject instanceof Boolean) {
            return this.convertBoolean(destClass, sourceObject);
        }
        if (sourceObject instanceof Double) {
            return this.convertDouble(destClass, sourceObject);
        }
        if (sourceObject instanceof Float) {
            return this.convertFloat(destClass, sourceObject);
        }
        if (sourceObject instanceof Long) {
            return this.convertLong(destClass, sourceObject);
        }
        return null;
    }

    private <T> T convertInteger(Class<T> destClass, Object sourceObject) {
        return (T)integerConverter.convert(destClass, sourceObject);
    }

    private <T> T convertString(Class<T> destClass, Object sourceObject) {
        if (destClass == Date.class) {
            return (T)new DateConverter(this.getCurrentDateFormat()).convert(destClass, sourceObject);
        }
        if (destClass == Timestamp.class) {
            return (T)new DateConverter(this.getCurrentTimestampFormat()).convert(destClass, sourceObject);
        }
        if (destClass == Boolean.class) {
            return (T)booleanConverter.convert(destClass, sourceObject);
        }
        if (destClass == BigDecimal.class) {
            return (T)bigDecimalConverter.convert(destClass, sourceObject);
        }
        if (destClass == Double.class) {
            return (T)doubleConverter.convert(destClass, sourceObject);
        }
        if (destClass == Float.class) {
            return (T)floatConverter.convert(destClass, sourceObject);
        }
        if (destClass == Integer.class) {
            return (T)integerConverter.convert(destClass, sourceObject);
        }
        if (destClass == Long.class) {
            return (T)longConverter.convert(destClass, sourceObject);
        }
        return (T)stringConverter.convert(destClass, sourceObject);
    }

    private <T> T convertTimestamp(Class<T> destClass, Object sourceObject) {
        if (destClass == String.class) {
            org.apache.commons.beanutils.converters.DateConverter converter = new org.apache.commons.beanutils.converters.DateConverter();
            String timestampFormatPattern = this.getCurrentTimestampFormatPattern();
            if (null != timestampFormatPattern) {
                converter.setPattern(timestampFormatPattern);
            }
            return (T)converter.convert(destClass, sourceObject);
        }
        return (T)new DateConverter(this.getCurrentTimestampFormat()).convert(destClass, sourceObject);
    }

    private <T> T convertDate(Class<T> destClass, Object sourceObject) {
        if (destClass == String.class) {
            org.apache.commons.beanutils.converters.DateConverter converter = new org.apache.commons.beanutils.converters.DateConverter();
            String dateFormatPattern = this.getCurrentDateFormatPattern();
            if (null != dateFormatPattern) {
                converter.setPattern(dateFormatPattern);
            }
            return (T)converter.convert(destClass, sourceObject);
        }
        return (T)new DateConverter(this.getCurrentDateFormat()).convert(destClass, sourceObject);
    }

    private <T> T convertBigDecimal(Class<T> destClass, Object sourceObject) {
        if (destClass == Date.class) {
            return (T)new DateConverter(this.getCurrentDateFormat()).convert(destClass, sourceObject);
        }
        if (destClass == Timestamp.class) {
            return (T)new DateConverter(this.getCurrentTimestampFormat()).convert(destClass, sourceObject);
        }
        return (T)bigDecimalConverter.convert(destClass, sourceObject);
    }

    private <T> T convertBoolean(Class<T> destClass, Object sourceObject) {
        return (T)booleanConverter.convert(destClass, sourceObject);
    }

    private <T> T convertDouble(Class<T> destClass, Object sourceObject) {
        return (T)doubleConverter.convert(destClass, sourceObject);
    }

    private <T> T convertFloat(Class<T> destClass, Object sourceObject) {
        return (T)floatConverter.convert(destClass, sourceObject);
    }

    private <T> T convertLong(Class<T> destClass, Object sourceObject) {
        if (destClass == Date.class || destClass == Timestamp.class) {
            return (T)new DateConverter(this.getCurrentDateFormat()).convert(destClass, sourceObject);
        }
        if (destClass == Timestamp.class) {
            return (T)new DateConverter(this.getCurrentTimestampFormat()).convert(destClass, sourceObject);
        }
        return (T)longConverter.convert(destClass, sourceObject);
    }

    private DateFormat getCurrentDateFormat() {
        DateFormat currentDateFormat = this.refreshDateFormatPatternCache();
        return null == currentDateFormat ? dateFormatPatternCache.get(DEFAULT_DATE_FORMAT) : currentDateFormat;
    }

    private DateFormat getCurrentTimestampFormat() {
        DateFormat currentTimestampFormat = this.refreshTimestampFormatPatternCache();
        return null == currentTimestampFormat ? timestampFormatPatternCache.get(DEFAULT_TIMESTAMP_FORMAT) : currentTimestampFormat;
    }

    private String getCurrentTimestampFormatPattern() {
        return null == this.refreshTimestampFormatPatternCache() ? null : MapperContextHolder.getMapperConfig().getTimestampPattern();
    }

    private String getCurrentDateFormatPattern() {
        return null == this.refreshDateFormatPatternCache() ? null : MapperContextHolder.getMapperConfig().getDatePattern();
    }

    private DateFormat refreshTimestampFormatPatternCache() {
        MapperConfig mapperConfig = MapperContextHolder.getMapperConfig();
        if (null == mapperConfig || null == mapperConfig.getTimestampPattern() || mapperConfig.getTimestampPattern().trim().length() == 0) {
            return null;
        }
        if (!timestampFormatPatternCache.containsKey(mapperConfig.getTimestampPattern())) {
            timestampFormatPatternCache.put(mapperConfig.getTimestampPattern(), new SimpleDateFormat(mapperConfig.getTimestampPattern()));
        }
        return timestampFormatPatternCache.get(mapperConfig.getTimestampPattern());
    }

    private DateFormat refreshDateFormatPatternCache() {
        MapperConfig mapperConfig = MapperContextHolder.getMapperConfig();
        if (null == mapperConfig || null == mapperConfig.getDatePattern() || mapperConfig.getDatePattern().trim().length() == 0) {
            return null;
        }
        if (!dateFormatPatternCache.containsKey(mapperConfig.getDatePattern())) {
            dateFormatPatternCache.put(mapperConfig.getDatePattern(), new SimpleDateFormat(mapperConfig.getDatePattern()));
        }
        return dateFormatPatternCache.get(mapperConfig.getDatePattern());
    }

    static {
        dateFormatPatternCache.put(DEFAULT_DATE_FORMAT, new SimpleDateFormat());
        timestampFormatPatternCache.put(DEFAULT_TIMESTAMP_FORMAT, new SimpleDateFormat("yyyy-mm-dd hh:mm:ss"));
    }
}

