/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.dao.impl;

import org.openxma.dsl.platform.dao.FilterExpression;
import org.openxma.dsl.platform.dao.Filterable;
import org.openxma.dsl.platform.dao.impl.BinaryExpression;
import org.openxma.dsl.platform.dao.impl.ConstantExpression;
import org.openxma.dsl.platform.valueobject.ValueObjectString;

public abstract class ComparisonExpression
extends BinaryExpression {
    private boolean ignoreCase;

    public ComparisonExpression(FilterExpression left, FilterExpression right) {
        this(left, right, false);
    }

    public ComparisonExpression(FilterExpression left, FilterExpression right, boolean ignoreCase) {
        super(left, right);
        this.ignoreCase = ignoreCase;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public static FilterExpression createEquals(String name, Object value) {
        return ComparisonExpression.createEquals(name, value, false);
    }

    public static FilterExpression createLike(String name, Object value) {
        return ComparisonExpression.createLike(name, value, false);
    }

    public static FilterExpression createEquals(String name, Object value, boolean ignoreCase) {
        return new EqualsExpression(ConstantExpression.create(name), ConstantExpression.create(value), ignoreCase);
    }

    public static FilterExpression createGreaterThan(String name, Object value) {
        return new GreaterThanExpression(ConstantExpression.create(name), ConstantExpression.create(value));
    }

    public static FilterExpression createLessThan(String name, Object value) {
        return new LessThanExpression(ConstantExpression.create(name), ConstantExpression.create(value));
    }

    public static FilterExpression createGreaterThanOrEquals(String name, Object value) {
        return new GreaterThanOrEqualsExpression(ConstantExpression.create(name), ConstantExpression.create(value));
    }

    public static FilterExpression createLessThanOrEquals(String name, Object value) {
        return new LessThanOrEqualsExpression(ConstantExpression.create(name), ConstantExpression.create(value));
    }

    public static FilterExpression createLike(String name, Object value, boolean ignoreCase) {
        return new LikeExpression(ConstantExpression.create(name), ConstantExpression.create(value instanceof ValueObjectString ? new ValueObjectString((String)((ValueObjectString)value).getValue() + "%") : value.toString() + "%"), ignoreCase);
    }

    public static class LikeExpression
    extends ComparisonExpression {
        public LikeExpression(FilterExpression left, FilterExpression right, boolean ignoreCase) {
            super(left, right, ignoreCase);
        }

        public Object applyTo(Filterable filterable) {
            return filterable.append(this);
        }
    }

    public static class LessThanOrEqualsExpression
    extends ComparisonExpression {
        public LessThanOrEqualsExpression(FilterExpression left, FilterExpression right) {
            super(left, right);
        }

        public Object applyTo(Filterable filterable) {
            return filterable.append(this);
        }
    }

    public static class LessThanExpression
    extends ComparisonExpression {
        public LessThanExpression(FilterExpression left, FilterExpression right) {
            super(left, right);
        }

        public Object applyTo(Filterable filterable) {
            return filterable.append(this);
        }
    }

    public static class GreaterThanOrEqualsExpression
    extends ComparisonExpression {
        public GreaterThanOrEqualsExpression(FilterExpression left, FilterExpression right) {
            super(left, right);
        }

        public Object applyTo(Filterable filterable) {
            return filterable.append(this);
        }
    }

    public static class GreaterThanExpression
    extends ComparisonExpression {
        public GreaterThanExpression(FilterExpression left, FilterExpression right) {
            super(left, right);
        }

        public Object applyTo(Filterable filterable) {
            return filterable.append(this);
        }
    }

    public static class EqualsExpression
    extends ComparisonExpression {
        public EqualsExpression(FilterExpression left, FilterExpression right, boolean ignoreCase) {
            super(left, right, ignoreCase);
        }

        public Object applyTo(Filterable filterable) {
            return filterable.append(this);
        }
    }
}

