/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.dao.impl;

import java.util.ArrayList;
import java.util.List;
import org.openxma.dsl.platform.dao.FilterExpression;
import org.openxma.dsl.platform.dao.Filterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeExpression
implements FilterExpression {
    private List<FilterExpression> filterSpecifications = new ArrayList<FilterExpression>();

    public CompositeExpression(List<FilterExpression> filterSpecifications) {
        this.filterSpecifications.addAll(filterSpecifications);
    }

    public CompositeExpression addFilterSpecification(FilterExpression filterSpecification) {
        this.filterSpecifications.add(filterSpecification);
        return this;
    }

    public List<FilterExpression> getFilterExpressions() {
        return this.filterSpecifications;
    }

    public static FilterExpression createAnd(List<FilterExpression> andFilterSpecifications) {
        return new AndExpression(andFilterSpecifications);
    }

    public static FilterExpression createOr(List<FilterExpression> orFilterSpecifications) {
        return new OrExpression(orFilterSpecifications);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OrExpression
    extends CompositeExpression {
        public OrExpression(List<FilterExpression> filterSpecifications) {
            super(filterSpecifications);
        }

        @Override
        public Object applyTo(Filterable filterable) {
            return filterable.append(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AndExpression
    extends CompositeExpression {
        public AndExpression(List<FilterExpression> filterSpecifications) {
            super(filterSpecifications);
        }

        @Override
        public Object applyTo(Filterable filterable) {
            return filterable.append(this);
        }
    }
}

