/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.dao.impl;

import java.beans.PropertyDescriptor;
import java.util.Collections;
import org.openxma.dsl.platform.dao.FilterExpression;
import org.openxma.dsl.platform.dao.Filterable;
import org.openxma.dsl.platform.dao.impl.ComparisonExpression;
import org.openxma.dsl.platform.dao.impl.CompositeExpression;
import org.openxma.dsl.platform.dao.impl.ResultLimitExpression;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.InvalidPropertyException;

public class ExampleExpression
extends CompositeExpression {
    private static final String PROPERTY_MAX_RESULTS = "maxResults";
    private static final String PROPERTY_FIRST_RESULT = "firstResult";
    private static final String SUFFIX_EQUALS_IGNORE_CASE = "IgnoreCase";
    private static final String SUFFIX_LIKE = "Like";
    private final BeanWrapperImpl beanWrapper;

    public ExampleExpression(Object bean) {
        super(Collections.<FilterExpression>emptyList());
        this.beanWrapper = new BeanWrapperImpl(bean);
    }

    public Object applyTo(Filterable filterable) {
        return this.createFilterSpecificationFromBean().applyTo(filterable);
    }

    private FilterExpression createFilterSpecificationFromBean() {
        PropertyDescriptor[] propertyDescriptors = this.beanWrapper.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
            String propertyName = propertyDescriptor.getName();
            Object propertyValue = this.beanWrapper.getPropertyValue(propertyName);
            if (new ReservedPropertyNameFilter().isFiltered(propertyName) || null == propertyValue) continue;
            boolean ignoreCase = this.isEqualsIgnoreCaseProperty(propertyName);
            FilterExpression comparisonFilterSpecification = this.isLikeProperty(propertyName) ? ComparisonExpression.createLike(propertyName, propertyValue, ignoreCase) : ComparisonExpression.createEquals(propertyName, propertyValue, ignoreCase);
            this.addFilterSpecification(comparisonFilterSpecification);
        }
        if (!this.getFilterExpressions().isEmpty() && this.beanWrapper.getPropertyDescriptor(PROPERTY_FIRST_RESULT) != null && this.beanWrapper.getPropertyDescriptor(PROPERTY_MAX_RESULTS) != null) {
            Integer firstResult = (Integer)this.beanWrapper.getPropertyValue(PROPERTY_FIRST_RESULT);
            Integer maxResults = (Integer)this.beanWrapper.getPropertyValue(PROPERTY_MAX_RESULTS);
            if (firstResult != null && maxResults != null) {
                this.addFilterSpecification(new ResultLimitExpression(firstResult, maxResults));
            }
        }
        return ExampleExpression.createAnd(this.getFilterExpressions());
    }

    private boolean isEqualsIgnoreCaseProperty(String propertyName) {
        try {
            PropertyDescriptor equalsIgnoreCasePropertyDescriptor = this.beanWrapper.getPropertyDescriptor(propertyName + SUFFIX_EQUALS_IGNORE_CASE);
            return this.isPropertyValueEnabled(equalsIgnoreCasePropertyDescriptor);
        }
        catch (InvalidPropertyException invalidPropertyException) {
            return false;
        }
    }

    private boolean isLikeProperty(String propertyName) {
        try {
            PropertyDescriptor likePropertyDescriptor = this.beanWrapper.getPropertyDescriptor(propertyName + SUFFIX_LIKE);
            return this.isPropertyValueEnabled(likePropertyDescriptor);
        }
        catch (InvalidPropertyException invalidPropertyException) {
            return false;
        }
    }

    private boolean isPropertyValueEnabled(PropertyDescriptor propertyDescriptor) {
        Object propertyValue = this.beanWrapper.getPropertyValue(propertyDescriptor.getName());
        return Boolean.TRUE.equals(propertyValue);
    }

    private class ReservedPropertyNameFilter
    implements PropertyNameFilter {
        private ReservedPropertyNameFilter() {
        }

        public boolean isFiltered(String propertyName) {
            return propertyName.endsWith(ExampleExpression.SUFFIX_EQUALS_IGNORE_CASE) || propertyName.endsWith(ExampleExpression.SUFFIX_LIKE) || propertyName.equals(ExampleExpression.PROPERTY_FIRST_RESULT) || propertyName.equals(ExampleExpression.PROPERTY_MAX_RESULTS) || propertyName.equals("class");
        }
    }

    private static interface PropertyNameFilter {
        public boolean isFiltered(String var1);
    }
}

