/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.dao.impl;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.type.Type;
import org.openxma.dsl.platform.dao.FilterExpression;
import org.openxma.dsl.platform.dao.FinderArgumentTypeFactory;
import org.openxma.dsl.platform.dao.FinderExecutor;
import org.openxma.dsl.platform.dao.FinderNamingStrategy;
import org.openxma.dsl.platform.dao.GenericDao;
import org.openxma.dsl.platform.dao.SortOrder;
import org.openxma.dsl.platform.dao.SortOrderSpecification;
import org.openxma.dsl.platform.dao.impl.HibernateFilter;
import org.openxma.dsl.platform.dao.impl.SimpleFinderArgumentTypeFactory;
import org.openxma.dsl.platform.dao.impl.SimpleFinderNamingStrategy;
import org.openxma.dsl.platform.hibernate.NamedQueryFilter;
import org.openxma.dsl.platform.query.QueryObject;
import org.openxma.dsl.platform.service.Mapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcCall;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericDaoHibernateImpl<T, Pk extends Serializable>
implements GenericDao<T, Pk>,
FinderExecutor<T>,
InitializingBean {
    public static final String QUERY_NAME = "queryName";
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected DataFieldMaxValueIncrementer dataFieldMaxValueIncrementer;
    protected SessionFactory sessionFactory;
    protected DataSource dataSource;
    protected FinderNamingStrategy namingStrategy = new SimpleFinderNamingStrategy();
    protected FinderArgumentTypeFactory argumentTypeFactory = new SimpleFinderArgumentTypeFactory();
    protected final Class<? extends T> type;

    @Autowired
    public void setSessionFactory(@Qualifier(value="default") SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Autowired
    public void setDataFieldMaxValueIncrementer(@Qualifier(value="default") DataFieldMaxValueIncrementer dataFieldMaxValueIncrementer) {
        this.dataFieldMaxValueIncrementer = dataFieldMaxValueIncrementer;
    }

    @Autowired(required=false)
    public void setDataSource(@Qualifier(value="default") DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setNamingStrategy(FinderNamingStrategy finderNamingStrategy) {
        this.namingStrategy = finderNamingStrategy;
    }

    public void setArgumentTypeFactory(FinderArgumentTypeFactory finderArgumentTypeFactory) {
        this.argumentTypeFactory = finderArgumentTypeFactory;
    }

    public GenericDaoHibernateImpl(Class<? extends T> type) {
        this.type = type;
    }

    protected T createEntityInstance() {
        return (T)BeanUtils.instantiateClass(this.type);
    }

    public T read(Pk id) {
        return (T)this.sessionFactory.getCurrentSession().get(this.type, id);
    }

    @Override
    public void update(T o) {
        this.sessionFactory.getCurrentSession().update(o);
    }

    @Override
    public void delete(T o) {
        this.sessionFactory.getCurrentSession().delete(o);
    }

    @Override
    public void delete(Pk oid) {
        this.delete((Pk)this.load(oid));
    }

    @Override
    public Set<T> findAll() {
        return new LinkedHashSet(this.sessionFactory.getCurrentSession().createCriteria(this.type).list());
    }

    @Override
    public Set<T> findAll(SortOrderSpecification sortOrderSpecification) {
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(this.type);
        this.applySortOrder(sortOrderSpecification, criteria);
        return new LinkedHashSet(criteria.list());
    }

    @Override
    public List<T> findByExample(T example) {
        Criteria exmapleCriteria = this.sessionFactory.getCurrentSession().createCriteria(this.type);
        return exmapleCriteria.add((Criterion)Example.create(example)).list();
    }

    @Override
    public Set<T> find(FilterExpression filterExpression, SortOrderSpecification orderSpecification) {
        Assert.notNull((Object)filterExpression, (String)"Parameter 'filterExpression' must not be null");
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(this.type);
        Criterion criterion = (Criterion)filterExpression.applyTo(new HibernateFilter(criteria));
        criteria.add(criterion);
        if (null != orderSpecification) {
            this.applySortOrder(orderSpecification, criteria);
        }
        return new LinkedHashSet(criteria.list());
    }

    @Override
    public T get(Pk oid) {
        return (T)this.sessionFactory.getCurrentSession().get(this.type, oid);
    }

    @Override
    public T load(Pk oid) {
        Object entity = this.sessionFactory.getCurrentSession().load(this.type, oid);
        Hibernate.initialize((Object)entity);
        return (T)entity;
    }

    @Override
    public T merge(T entity) {
        return (T)this.sessionFactory.getCurrentSession().merge(entity);
    }

    @Override
    public void saveOrUpdate(T entity) {
        this.sessionFactory.getCurrentSession().saveOrUpdate(entity);
    }

    @Override
    public List<T> executeFinder(Method method, Object[] queryArgs) {
        Query namedQuery = this.prepareQuery(method, queryArgs);
        return namedQuery.list();
    }

    @Override
    public Iterator<T> iterateFinder(Method method, Object[] queryArgs) {
        Query namedQuery = this.prepareQuery(method, queryArgs);
        return namedQuery.iterate();
    }

    @Override
    public void refresh(T object) {
        this.sessionFactory.getCurrentSession().refresh(object);
    }

    @Override
    public void evict(T object) {
        this.sessionFactory.getCurrentSession().evict(object);
    }

    @Override
    public <E> Collection<E> query(QueryObject queryObject) {
        if (queryObject.getQueryName() == null) {
            throw new IllegalArgumentException("parameter 'queryObject.queryName' must not be null");
        }
        NamedQueryFilter namedQueryContext = this.createQueryContext(queryObject);
        return (Collection)queryObject.evaluate(namedQueryContext);
    }

    protected NamedQueryFilter createQueryContext(QueryObject queryObject) {
        return new NamedQueryFilter(this.sessionFactory, this.getNamedQueryMapper(queryObject.getQueryName()));
    }

    protected Criteria createCriteria(Class entityClass) {
        return this.sessionFactory.getCurrentSession().createCriteria(entityClass);
    }

    protected Criteria createCriteria() {
        return this.createCriteria(this.type);
    }

    protected Criteria createCriteria(Criterion criterion) {
        Criteria criteria = this.createCriteria(this.type);
        if (criterion != null) {
            criteria = this.add(criteria, criterion);
        }
        return criteria;
    }

    protected List<T> list(Criteria criteria) {
        if (((CriteriaImpl)criteria).iterateExpressionEntries().hasNext()) {
            return criteria.list();
        }
        return Collections.emptyList();
    }

    protected T unique(Criteria criteria) {
        if (((CriteriaImpl)criteria).iterateExpressionEntries().hasNext()) {
            return (T)criteria.uniqueResult();
        }
        return null;
    }

    protected <E> List<E> list(Query query) {
        return query.list();
    }

    protected <S> S unique(Query query) {
        return (S)query.uniqueResult();
    }

    protected void orderBy(Criteria criteria, SortOrderSpecification sortOrderSpecification) {
        for (SortOrder sortOrder : sortOrderSpecification.getSortOrders()) {
            criteria.addOrder(sortOrder.isAscending() ? Order.asc((String)sortOrder.getPropertyName()) : Order.desc((String)sortOrder.getPropertyName()));
        }
    }

    protected Criterion and(Criterion criterion, String propertyName, Object value, boolean isNullable) {
        Criterion expression = this.equal(propertyName, value, isNullable);
        return null == criterion ? expression : (null == expression ? criterion : Restrictions.and((Criterion)criterion, (Criterion)expression));
    }

    protected Criterion or(Criterion criterion, String propertyName, Object value, boolean isNullable) {
        Criterion expression = this.equal(propertyName, value, isNullable);
        return null == criterion ? expression : (null == expression ? criterion : Restrictions.or((Criterion)criterion, (Criterion)expression));
    }

    protected Criterion equal(String propertyName, Object value, boolean isNullable) {
        return null != value ? Restrictions.eq((String)propertyName, (Object)value) : (isNullable ? Restrictions.isNull((String)propertyName) : null);
    }

    protected Criteria add(Criteria criteria, Criterion criterion) {
        if (criterion != null) {
            criteria.add(criterion);
        }
        return criteria;
    }

    protected Criteria join(Criteria criteria, String reference, FilterExpression filterExpression) {
        if (filterExpression != null) {
            Criterion expression = (Criterion)filterExpression.applyTo(new HibernateFilter(criteria, reference));
            criteria.add(expression);
        }
        return criteria;
    }

    protected final void applyPagingParameters(Criteria criteria, Integer firstResult, Integer maxResults) {
        if (null != firstResult) {
            criteria.setFirstResult(firstResult.intValue());
        }
        if (null != maxResults && maxResults > 0) {
            criteria.setMaxResults(maxResults.intValue());
        }
    }

    protected Mapper getNamedQueryMapper(String queryName) {
        return new NamedQueryMapper();
    }

    protected SimpleJdbcCall createJdbcCall(String name) {
        return this.createJdbcCall(name, null);
    }

    protected SimpleJdbcCall createJdbcCall(String name, String catalog) {
        Assert.notNull((Object)name, (String)"Parameter 'name' must not be null");
        SimpleJdbcCall simpleJdbcCall = new SimpleJdbcCall(this.createJdbcTemplate());
        simpleJdbcCall.setProcedureName(name);
        simpleJdbcCall.setCatalogName(catalog);
        return simpleJdbcCall;
    }

    protected Map<String, Object> executeJdbcCall(SimpleJdbcCall jdbcCall, Map<String, Object> arguments) {
        Assert.notNull((Object)jdbcCall, (String)"Parameter 'jdbcCall' must not be null");
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource(arguments);
        return this.executeJdbcCall(jdbcCall, (SqlParameterSource)sqlParameterSource);
    }

    protected Map<String, Object> executeJdbcCall(SimpleJdbcCall jdbcCall, SqlParameterSource sqlParameterSource) {
        Assert.notNull((Object)jdbcCall, (String)"Parameter 'jdbcCall' must not be null");
        return jdbcCall.execute(sqlParameterSource);
    }

    protected JdbcTemplate createJdbcTemplate() {
        if (this.dataSource == null) {
            SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)this.sessionFactory;
            try {
                return new JdbcTemplate((DataSource)new SingleConnectionDataSource(sessionFactoryImplementor.getConnectionProvider().getConnection(), false));
            }
            catch (SQLException e) {
                throw SessionFactoryUtils.convertHibernateAccessException((HibernateException)new HibernateException((Throwable)e));
            }
        }
        return new JdbcTemplate(this.dataSource);
    }

    protected void applySortOrder(SortOrderSpecification orderSpecification, Criteria criteria) {
        Assert.notNull((Object)orderSpecification, (String)"Parameter 'orderSpecification' must not be null");
        for (SortOrder order : orderSpecification.getSortOrders()) {
            criteria.addOrder(order.isAscending() ? Order.asc((String)order.getPropertyName()) : Order.desc((String)order.getPropertyName()));
        }
    }

    protected Query prepareQuery(Method method, Object[] queryArgs) {
        String queryName = this.namingStrategy.queryNameFromMethod(this.type, method);
        Query namedQuery = this.sessionFactory.getCurrentSession().getNamedQuery(queryName);
        String[] namedParameters = namedQuery.getNamedParameters();
        if (namedParameters.length == 0) {
            this.setPositionalParams(queryArgs, namedQuery);
        } else {
            this.setNamedParams(namedParameters, queryArgs, namedQuery);
        }
        return namedQuery;
    }

    protected void setPositionalParams(Object[] queryArgs, Query namedQuery) {
        if (queryArgs != null) {
            for (int i = 0; i < queryArgs.length; ++i) {
                Object arg = queryArgs[i];
                Type argType = this.argumentTypeFactory.getArgumentType(arg);
                if (argType != null) {
                    namedQuery.setParameter(i, arg, argType);
                    continue;
                }
                namedQuery.setParameter(i, arg);
            }
        }
    }

    protected void setNamedParams(String[] namedParameters, Object[] queryArgs, Query namedQuery) {
        if (queryArgs != null) {
            for (int i = 0; i < queryArgs.length; ++i) {
                Object arg = queryArgs[i];
                Type argType = this.argumentTypeFactory.getArgumentType(arg);
                if (argType != null) {
                    namedQuery.setParameter(namedParameters[i], arg, argType);
                    continue;
                }
                if (arg instanceof Collection) {
                    namedQuery.setParameterList(namedParameters[i], (Collection)arg);
                    continue;
                }
                namedQuery.setParameter(namedParameters[i], arg);
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.dataSource == null) {
            this.logger.warn((Object)"Missing configuration for default qualified 'dataSource' property.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class NamedQueryMapper
    implements Mapper {
        protected NamedQueryMapper() {
        }

        public <E> List<E> createAndMapMany(Collection<?> sourceCollection, Class<E> targetClass) {
            throw new UnsupportedOperationException();
        }

        public <E> List<E> createAndMapMany(Collection<?> sourceCollection, Class<E> targetClass, Object context) {
            int rowNumber = 0;
            ArrayList<E> resultList = new ArrayList<E>();
            Map<Object, Object> contextMap = this.getContextAsMap(context);
            for (Object object : sourceCollection) {
                Object object2;
                if (object instanceof Object[]) {
                    object2 = object;
                } else {
                    Object[] objectArray = new Object[1];
                    object2 = objectArray;
                    objectArray[0] = object;
                }
                Object[] tuple = (Object[])object2;
                contextMap.put("rowNumber", rowNumber);
                E result = this.createAndMapOne((Object)tuple, targetClass, context);
                if (result == null) continue;
                resultList.add(result);
            }
            return resultList;
        }

        public <E> E createAndMapOne(Object sourceObject, Class<E> targetClass) {
            throw new UnsupportedOperationException();
        }

        public <E> E createAndMapOne(Object sourceObject, Class<E> targetClass, Object context) {
            Object newInstance = null;
            if (targetClass != null) {
                newInstance = BeanUtils.instantiateClass(targetClass);
            }
            return (E)this.mapOne(sourceObject, (E)newInstance, context);
        }

        public <E> E mapOne(Object sourceObject, E targetObject) {
            throw new UnsupportedOperationException();
        }

        public <E> E mapOne(Object sourceObject, E targetObject, Object context) {
            return (E)sourceObject;
        }

        protected String getQueryName(Object context) {
            return (String)this.getContextAsMap(context).get(GenericDaoHibernateImpl.QUERY_NAME);
        }

        protected Map<Object, Object> getContextAsMap(Object context) {
            Map contextAsMap = (Map)context;
            return new HashMap<Object, Object>(contextAsMap);
        }
    }
}

