/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.dao.impl;

import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.openxma.dsl.platform.dao.FilterExpression;
import org.openxma.dsl.platform.dao.Filterable;
import org.openxma.dsl.platform.dao.impl.ComparisonExpression;
import org.openxma.dsl.platform.dao.impl.CompositeExpression;
import org.openxma.dsl.platform.dao.impl.JoinExpression;
import org.openxma.dsl.platform.dao.impl.ResultLimitExpression;
import org.openxma.dsl.platform.dao.impl.UnaryExpression;

public class HibernateFilter
implements Filterable {
    private Criteria criteria;
    private String alias;

    public HibernateFilter(Criteria criteria) {
        this(criteria, "");
    }

    public HibernateFilter(Criteria criteria, String alias) {
        this.criteria = criteria;
        this.alias = alias;
    }

    public Object append(ComparisonExpression.EqualsExpression equalsExpression) {
        String propertyName = (String)equalsExpression.getLeft().applyTo(this);
        Object propertyValue = equalsExpression.getRight().applyTo(this);
        SimpleExpression eq = Restrictions.eq((String)this.getPropertyPath(propertyName), (Object)propertyValue);
        if (equalsExpression.isIgnoreCase()) {
            eq = eq.ignoreCase();
        }
        return eq;
    }

    public Object append(ComparisonExpression.LikeExpression likeExpression) {
        String propertyName = (String)likeExpression.getLeft().applyTo(this);
        Object propertyValue = likeExpression.getRight().applyTo(this);
        SimpleExpression like = Restrictions.like((String)this.getPropertyPath(propertyName), (Object)propertyValue);
        if (likeExpression.isIgnoreCase()) {
            like = like.ignoreCase();
        }
        return like;
    }

    public Object append(CompositeExpression.AndExpression andFilterExpression) {
        Conjunction conjunction = Restrictions.conjunction();
        for (FilterExpression filterExpression : andFilterExpression.getFilterExpressions()) {
            Object applyTo = filterExpression.applyTo(this);
            if (!(applyTo instanceof Criterion)) continue;
            conjunction.add((Criterion)applyTo);
        }
        return conjunction;
    }

    public Object append(CompositeExpression.OrExpression orFilterExpression) {
        Disjunction conjunction = Restrictions.disjunction();
        for (FilterExpression filterExpression : orFilterExpression.getFilterExpressions()) {
            conjunction.add((Criterion)filterExpression.applyTo(this));
        }
        return conjunction;
    }

    public Object append(ResultLimitExpression limitFilterExpression) {
        this.criteria.setFirstResult(limitFilterExpression.getFirstResult().intValue()).setMaxResults(limitFilterExpression.getMaxResults().intValue());
        return this.criteria;
    }

    public Object append(UnaryExpression.NotExpression notExpression) {
        return Restrictions.not((Criterion)((Criterion)notExpression.getFilterExpression().applyTo(this)));
    }

    public Object append(JoinExpression joinExpression) {
        this.criteria = this.criteria.createAlias(this.getPropertyPath(joinExpression.getAlias()), joinExpression.getAlias(), joinExpression.isLeftJoin() ? 1 : 0);
        this.criteria.setFetchMode(this.getPropertyPath(joinExpression.getAlias()), joinExpression.isFetch() ? FetchMode.JOIN : FetchMode.DEFAULT);
        FilterExpression filterExpression = joinExpression.getFilterExpression();
        return filterExpression.applyTo(new HibernateFilter(this.criteria, joinExpression.getAlias()));
    }

    public Object append(ComparisonExpression.GreaterThanExpression greaterThanExpression) {
        String propertyName = (String)greaterThanExpression.getLeft().applyTo(this);
        Object propertyValue = greaterThanExpression.getRight().applyTo(this);
        return Restrictions.gt((String)this.getPropertyPath(propertyName), (Object)propertyValue);
    }

    public Object append(ComparisonExpression.LessThanExpression lessThanExpression) {
        String propertyName = (String)lessThanExpression.getLeft().applyTo(this);
        Object propertyValue = lessThanExpression.getRight().applyTo(this);
        return Restrictions.lt((String)this.getPropertyPath(propertyName), (Object)propertyValue);
    }

    public Object append(ComparisonExpression.GreaterThanOrEqualsExpression greaterThanOrEqualsExpression) {
        String propertyName = (String)greaterThanOrEqualsExpression.getLeft().applyTo(this);
        Object propertyValue = greaterThanOrEqualsExpression.getRight().applyTo(this);
        return Restrictions.ge((String)this.getPropertyPath(propertyName), (Object)propertyValue);
    }

    public Object append(ComparisonExpression.LessThanOrEqualsExpression lessThanOrEqualsExpression) {
        String propertyName = (String)lessThanOrEqualsExpression.getLeft().applyTo(this);
        Object propertyValue = lessThanOrEqualsExpression.getRight().applyTo(this);
        return Restrictions.le((String)this.getPropertyPath(propertyName), (Object)propertyValue);
    }

    private String getPropertyPath(String propertyName) {
        if (null == this.alias || "".equals(this.alias)) {
            return propertyName;
        }
        return this.alias + "." + propertyName;
    }
}

