/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.dao.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.openxma.dsl.platform.assembler.DtoAssembler;
import org.openxma.dsl.platform.assembler.DtoAssemblerFactory;
import org.openxma.dsl.platform.assembler.DtoAssemblerRegistry;
import org.openxma.dsl.platform.dao.EntityFactory;
import org.openxma.dsl.platform.dao.EntityFactoryRegistry;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class MapEntityFactoryRegistry
implements EntityFactoryRegistry,
DtoAssemblerRegistry,
BeanPostProcessor {
    private Map<Class<?>, EntityFactory<?>> entityFactories = new HashMap();
    private Map<Class<?>, DtoAssembler<?>> dtoAssemblers = new HashMap();

    @Override
    public <T> EntityFactory<T> getEntityFactory(Class<T> entityClass) {
        return this.entityFactories.get(entityClass);
    }

    @Override
    public <T> DtoAssembler<T> getDtoAssembler(Class<T> dtoClass) {
        return this.dtoAssemblers.get(dtoClass);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof EntityFactory) {
            this.registerEntityFactoryForClass(bean, bean.getClass());
        } else if (bean instanceof DtoAssemblerFactory) {
            this.registerDefaultDtoAssemblersForDtoClasses((DtoAssemblerFactory)bean);
        }
        return bean;
    }

    private void registerDefaultDtoAssemblersForDtoClasses(DtoAssemblerFactory dtoAssemblerFactory) {
        for (DtoAssembler<?> dtoAssembler : dtoAssemblerFactory.getDtoAssemblers()) {
            this.dtoAssemblers.put(this.getSupportedDtoClassFromDtoAssemblerClass(dtoAssembler.getClass()), dtoAssembler);
        }
    }

    private Class<?> getSupportedDtoClassFromDtoAssemblerClass(Class<?> beanClass) {
        for (Type type : beanClass.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!(type instanceof ParameterizedType) || !DtoAssembler.class.equals((Object)(parameterizedType = (ParameterizedType)type).getRawType())) continue;
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        throw new IllegalArgumentException("missing class of raw type DtoAssembler ");
    }

    private void registerEntityFactoryForClass(Object bean, Class<?> beanClass) {
        for (Type type : beanClass.getGenericInterfaces()) {
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                if (!EntityFactory.class.equals((Object)parameterizedType.getRawType())) continue;
                EntityFactory entityFactory = (EntityFactory)bean;
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                this.entityFactories.put((Class)actualTypeArguments[0], entityFactory);
                continue;
            }
            if (!(type instanceof Class)) continue;
            this.registerEntityFactoryForClass(bean, (Class)type);
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

