/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.enums;

import at.spardat.xma.datasource.ProviderResultServer;
import at.spardat.xma.datasource.RessourceBundleProviderServer;
import at.spardat.xma.datasource.TableSpec;
import at.spardat.xma.datasource.TabularDataRow;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.openxma.dsl.platform.enums.I18nEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I18nEnums {
    private static final Map<String, TabularDataRow> EMPTY_TABLE_CACHE = new HashMap<String, TabularDataRow>();
    private static Map<String, Map<String, TabularDataRow>> cache = new HashMap<String, Map<String, TabularDataRow>>();

    static <A extends Enum<?>> Map<String, TabularDataRow> getTableCache(Class<?> enumClass, Locale l) {
        String bundleName = enumClass.getName();
        Map<String, TabularDataRow> tableCache = cache.get(bundleName);
        if (tableCache == null) {
            try {
                ResourceBundle.getBundle(bundleName, l);
            }
            catch (Exception ex) {
                cache.put(bundleName, EMPTY_TABLE_CACHE);
                return EMPTY_TABLE_CACHE;
            }
            RessourceBundleProviderServer ps = new RessourceBundleProviderServer();
            TableSpec spec = new TableSpec();
            spec.setProperty("bundle", enumClass.getName());
            spec.setLocale(l);
            ProviderResultServer result = ps.provideTable(null, spec, 0L);
            tableCache = new HashMap<String, TabularDataRow>();
            for (int i = 0; i < result.table_.size(); ++i) {
                TabularDataRow row = result.table_.getRow(i);
                tableCache.put(row.get(0).toString(), row);
            }
            cache.put(enumClass.getName(), tableCache);
        }
        return tableCache;
    }

    static TabularDataRow getTabularDataRowFor(Enum<?> value, Locale l) {
        Map<String, TabularDataRow> tableCache = I18nEnums.getTableCache(value.getClass(), l);
        if (tableCache == EMPTY_TABLE_CACHE) {
            return null;
        }
        return tableCache.get(I18nEnums.keyOf(value));
    }

    public static <A extends Enum<?>> String shortValueOf(A value, Locale l) {
        String shortValue;
        if (l == null) {
            l = Locale.getDefault();
        }
        if (value instanceof I18nEnum) {
            I18nEnum i18Enum = (I18nEnum)((Object)value);
            return i18Enum.getShortValue(l);
        }
        if (value instanceof Enum && (shortValue = I18nEnums.shortValueFromProvider(value, l)) != null) {
            return shortValue;
        }
        return value.toString();
    }

    public static <A extends Enum<?>> String longValueOf(A value, Locale l) {
        String longValue;
        if (l == null) {
            l = Locale.getDefault();
        }
        if (value instanceof I18nEnum) {
            I18nEnum i18Enum = (I18nEnum)((Object)value);
            return i18Enum.getLongValue(l);
        }
        if (value instanceof Enum && (longValue = I18nEnums.longValueFromProvider(value, l)) != null) {
            return longValue;
        }
        return value.toString();
    }

    public static <A extends Enum<?>> String shortValueFromProvider(A value, Locale l) {
        TabularDataRow row;
        if (l == null) {
            l = Locale.getDefault();
        }
        if ((row = I18nEnums.getTabularDataRowFor(value, l)) != null) {
            return row.get(1).toString();
        }
        return null;
    }

    public static <A extends Enum<?>> String longValueFromProvider(A value, Locale l) {
        TabularDataRow row;
        if (l == null) {
            l = Locale.getDefault();
        }
        if ((row = I18nEnums.getTabularDataRowFor(value, l)) != null) {
            return row.get(2).toString();
        }
        return null;
    }

    private static <A extends Enum<?>> A[] getEnumValues(Class<A> clazz) {
        try {
            Method valuesMethod = clazz.getMethod("values", new Class[0]);
            return (Enum[])valuesMethod.invoke(clazz, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Can not get enum values for '" + clazz.getName() + "'", e);
        }
    }

    public static <A extends Enum<?>> String keyOf(A value) {
        if (value == null) {
            return null;
        }
        if (value instanceof I18nEnum) {
            I18nEnum i18Enum = (I18nEnum)((Object)value);
            return i18Enum.getKey();
        }
        return value.toString();
    }

    public static <A extends Enum<?>> A valueOfKey(Class<A> clazz, String key) {
        return (A)I18nEnums.valueOfKey((Enum[])I18nEnums.getEnumValues(clazz), (String)key);
    }

    public static <A extends Enum<?>> A valueOfKey(A[] values, String code) {
        if (code == null || code.length() == 0) {
            return null;
        }
        for (A item : values) {
            String key = I18nEnums.keyOf(item);
            if (key == null || !key.equals(code)) continue;
            return item;
        }
        throw new RuntimeException("No enum const for key '" + code + "'");
    }
}

