/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.exceptions;

import org.openxma.dsl.platform.exceptions.BeanValidationException;
import org.openxma.dsl.platform.exceptions.PropertyValidationException;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class ExceptionSupport {
    public static BeanValidationException mapToValidationException(Errors errors) {
        return ExceptionSupport.mapToValidationException(errors, null);
    }

    public static BeanValidationException mapToValidationException(Errors errors, Object target) {
        if (target == null && errors instanceof BeanPropertyBindingResult) {
            target = ((BeanPropertyBindingResult)errors).getTarget();
        }
        String beanName = null;
        beanName = target != null ? target.getClass().getCanonicalName() : errors.getObjectName();
        BeanValidationException bvex = new BeanValidationException(beanName, "Invalid " + beanName + System.getProperty("line.separator") + errors);
        if (errors.hasGlobalErrors()) {
            for (ObjectError error : errors.getGlobalErrors()) {
                bvex.addValidationIssue(ExceptionSupport.mapToValidationException(error, beanName));
            }
        }
        if (errors.hasFieldErrors()) {
            for (ObjectError error : errors.getFieldErrors()) {
                bvex.addValidationIssue(ExceptionSupport.mapToValidationException((FieldError)error, beanName));
            }
        }
        return bvex;
    }

    public static BeanValidationException mapToValidationException(ObjectError error, String beanFullName) {
        BeanValidationException bvex = new BeanValidationException(beanFullName, error.getDefaultMessage());
        return bvex;
    }

    public static PropertyValidationException mapToValidationException(FieldError error, String beanFullName) {
        PropertyValidationException pvex = null;
        Object[] arguments = error.getArguments();
        pvex = arguments != null && arguments.length > 0 ? new PropertyValidationException(error.getCode(), beanFullName, error.getField(), error.getRejectedValue(), arguments, error.toString()) : new PropertyValidationException(error.getCode(), beanFullName, error.getField(), error.getRejectedValue(), error.toString());
        return pvex;
    }
}

