/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.hibernate;

import antlr.ANTLRException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.SessionFactoryImplementor;
import org.openxma.dsl.platform.hibernate.hql.HqlRewriteStrategy;
import org.openxma.dsl.platform.hibernate.hql.impl.RewritingHqlParser;
import org.openxma.dsl.platform.query.Expression;
import org.openxma.dsl.platform.query.ExpressionOperator;
import org.openxma.dsl.platform.query.QueryContext;
import org.openxma.dsl.platform.query.QueryObject;
import org.openxma.dsl.platform.query.impl.BinaryExpression;
import org.openxma.dsl.platform.query.impl.ConstantExpression;
import org.openxma.dsl.platform.query.impl.LogicalExpression;
import org.openxma.dsl.platform.query.impl.ParameterExpression;
import org.openxma.dsl.platform.query.impl.RelationalExpression;
import org.openxma.dsl.platform.query.impl.SortOrderExpression;
import org.openxma.dsl.platform.service.Mapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedQueryFilter
implements QueryContext,
HqlRewriteStrategy {
    protected static final Log logger = LogFactory.getLog(NamedQueryFilter.class);
    private static final Map<ExpressionOperator, String> HQL_OPERATOR_MAP = new HashMap<ExpressionOperator, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(ExpressionOperator.AND, "and");
            this.put(ExpressionOperator.ASC, "asc");
            this.put(ExpressionOperator.DESC, "desc");
            this.put(ExpressionOperator.EQUALS, "=");
            this.put(ExpressionOperator.IS_NULL, "is");
            this.put(ExpressionOperator.IS_NOT_NULL, "is not");
            this.put(ExpressionOperator.GREATER_THAN, ">");
            this.put(ExpressionOperator.GREATER_THAN_OR_EQUAL, ">=");
            this.put(ExpressionOperator.LESS_THAN, "<");
            this.put(ExpressionOperator.LESS_THAN_OR_EQUAL, "<=");
            this.put(ExpressionOperator.LIKE, "like");
            this.put(ExpressionOperator.NOT_EQUALS, "!=");
            this.put(ExpressionOperator.NOT_LIKE, "not like");
            this.put(ExpressionOperator.OR, "or");
        }
    };
    private StringBuilder filterExpressionBuilder = new StringBuilder();
    private StringBuilder sortOrderExpressionBuilder = new StringBuilder();
    private Map<String, Object> parameterMap = new HashMap<String, Object>();
    private int parameterIndex;
    private String currentVariableName;
    private RewritingHqlParser rewritingHqlParser;
    private SessionFactoryImplementor sessionFactoryImplementor;
    private Mapper namedQueryMapper;

    public NamedQueryFilter(SessionFactory sessionFactory, Mapper namedQueryMapper) {
        this.sessionFactoryImplementor = (SessionFactoryImplementor)sessionFactory;
        this.namedQueryMapper = namedQueryMapper;
    }

    public Map<String, Object> getParameters() {
        return this.parameterMap;
    }

    @Override
    public Object accept(QueryObject queryObject) {
        this.copyArguments(queryObject);
        this.buildFilterExpression(queryObject);
        this.buildSortOrderHql(queryObject);
        return this.list(queryObject, this.rewriteHqlQuery(queryObject));
    }

    protected void buildFilterExpression(QueryObject queryObject) {
        if (null != queryObject.getWhereExpression()) {
            queryObject.getWhereExpression().evaluate(this);
        }
    }

    protected Collection list(QueryObject queryObject, String rewrittenHqlString) throws HibernateException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)rewrittenHqlString);
        }
        Query query = this.createQuery(queryObject, rewrittenHqlString);
        query.setReadOnly(true);
        if (this.rewritingHqlParser.isPropertiesSelect()) {
            return this.namedQueryMapper.createAndMapMany(query.list(), null, Collections.singletonMap("queryName", queryObject.getQueryName()));
        }
        return this.rewritingHqlParser.getJoinAliasMap().isEmpty() ? query.list() : new LinkedHashSet(query.list());
    }

    protected Query createQuery(QueryObject queryObject, String rewrittenHqlString) throws HibernateException {
        Session currentSession = this.sessionFactoryImplementor.getCurrentSession();
        Query query = currentSession.createQuery(rewrittenHqlString);
        this.applyParameters(query);
        this.applyQueryHints(queryObject, query);
        return query;
    }

    protected void applyQueryHints(QueryObject queryObject, Query query) {
        query.setFirstResult(queryObject.getFirstResult());
        if (queryObject.getMaxResults() > 0) {
            query.setMaxResults(queryObject.getMaxResults());
        }
    }

    private void applyParameters(Query query) throws HibernateException {
        Set<String> parameterNames = this.getParameters().keySet();
        for (String parameterName : parameterNames) {
            Object val = this.getParameters().get(parameterName);
            if (val instanceof Collection) {
                query.setParameterList(parameterName, (Collection)val);
                continue;
            }
            query.setParameter(parameterName, val);
        }
    }

    private void buildSortOrderHql(QueryObject queryObject) {
        for (Expression expression : queryObject.getSortOrderExpressions()) {
            expression.evaluate(this);
        }
    }

    private String rewriteHqlQuery(QueryObject queryObject) {
        NamedQueryDefinition namedQueryDefinition = this.sessionFactoryImplementor.getNamedQuery(queryObject.getQueryName());
        if (namedQueryDefinition == null) {
            throw new QueryException("NameQuery '" + queryObject.getQueryName() + "' not found");
        }
        String hqlQueryString = namedQueryDefinition.getQueryString();
        this.rewritingHqlParser = RewritingHqlParser.getInstance(hqlQueryString, this.sessionFactoryImplementor);
        this.rewritingHqlParser.setRewritingStrategy(this);
        try {
            this.rewritingHqlParser.statement();
        }
        catch (ANTLRException e) {
            throw new QueryException(e.getMessage(), hqlQueryString);
        }
        return this.rewritingHqlParser.rewriteHqlQuery();
    }

    protected void copyArguments(QueryObject queryObject) {
        Set<String> parameterNames = queryObject.getArguments().keySet();
        for (String parameterName : parameterNames) {
            this.getParameters().put(parameterName, queryObject.getArguments().get(parameterName));
        }
    }

    @Override
    public Object accept(RelationalExpression relationalExpression) {
        Object name = relationalExpression.getLeft().evaluate(this);
        this.currentVariableName = name + String.valueOf(this.parameterIndex++);
        this.appendOperator(relationalExpression);
        Object value = relationalExpression.getRight().evaluate(this);
        this.parameterMap.put(this.toParameterName(this.currentVariableName), value);
        return null;
    }

    @Override
    public Object accept(LogicalExpression logicalExpression) {
        if (logicalExpression.getParent() != null) {
            this.filterExpressionBuilder.append("(");
        }
        logicalExpression.getLeft().evaluate(this);
        this.appendOperator(logicalExpression);
        logicalExpression.getRight().evaluate(this);
        if (logicalExpression.getParent() != null) {
            this.filterExpressionBuilder.append(")");
        }
        return null;
    }

    @Override
    public Object accept(ConstantExpression constantExpression) {
        if (ConstantExpression.NULL.equals(constantExpression)) {
            this.filterExpressionBuilder.append(ConstantExpression.NULL.toString());
        } else {
            this.filterExpressionBuilder.append(":").append(this.toParameterName(this.currentVariableName));
        }
        return constantExpression.getValue();
    }

    @Override
    public Object accept(ParameterExpression parameterExpression) {
        this.filterExpressionBuilder.append(this.prefixWithAliasPlaceHolder(parameterExpression.getName()));
        return parameterExpression.getName();
    }

    @Override
    public Object accept(SortOrderExpression sortOrderExpression) {
        ParameterExpression parameterExpression = (ParameterExpression)sortOrderExpression.getExpression();
        String fieldName = parameterExpression.getName();
        if (this.sortOrderExpressionBuilder.length() > 0) {
            this.sortOrderExpressionBuilder.append(",");
        }
        this.sortOrderExpressionBuilder.append(this.prefixWithAliasPlaceHolder(fieldName)).append(" ").append(HQL_OPERATOR_MAP.get((Object)sortOrderExpression.getOperator()));
        return null;
    }

    @Override
    public String getFilter() {
        return this.filterExpressionBuilder.toString();
    }

    @Override
    public String getSortOrder() {
        return this.sortOrderExpressionBuilder.toString();
    }

    protected String toParameterName(String path) {
        return path.replaceAll("\\.", "_");
    }

    private Object prefixWithAliasPlaceHolder(String fieldName) {
        return String.format("%s.%s", "{alias}", fieldName);
    }

    private void appendOperator(BinaryExpression binaryExpression) {
        this.filterExpressionBuilder.append(" ");
        this.filterExpressionBuilder.append(HQL_OPERATOR_MAP.get((Object)binaryExpression.getOperator()));
        this.filterExpressionBuilder.append(" ");
    }
}

