/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.hibernate.dialect;

import org.hibernate.HibernateException;
import org.hibernate.dialect.Oracle10gDialect;
import org.springframework.beans.factory.config.FieldRetrievingFactoryBean;

public class OpenXmaOracleDialect
extends Oracle10gDialect {
    private static final String XMLTYPE_CLASS = "oracle.xdb.XMLType";
    private static final String XMLTYPE_FIELD_TYPECODE = "_SQL_TYPECODE";
    private static Class xmltypeClass = null;
    private static Integer xmltypeCode = null;
    private static boolean xmlTypeRegistered = false;

    public OpenXmaOracleDialect() {
        try {
            this.registerColumnType(OpenXmaOracleDialect.getXmlTypeSqlCode(), "XMLType");
            xmlTypeRegistered = true;
        }
        catch (Exception exception) {
            throw new HibernateException("Field '_SQL_TYPECODE' of xml type class 'oracle.xdb.XMLType' not found");
        }
    }

    public static final boolean isXmlTypeRegistered() {
        return xmlTypeRegistered;
    }

    public static final int getXmlTypeSqlCode() {
        if (xmltypeCode == null) {
            try {
                FieldRetrievingFactoryBean fieldRetrievingFactoryBean = new FieldRetrievingFactoryBean();
                fieldRetrievingFactoryBean.setStaticField("oracle.xdb.XMLType._SQL_TYPECODE");
                fieldRetrievingFactoryBean.afterPropertiesSet();
                xmltypeCode = new Integer(fieldRetrievingFactoryBean.getObject().toString());
            }
            catch (Exception exception) {
                throw new HibernateException("Field '_SQL_TYPECODE' of xml type class 'oracle.xdb.XMLType' not found");
            }
        }
        return xmltypeCode;
    }

    public static final Class loadXmlTypeClass() {
        if (xmltypeClass == null) {
            try {
                xmltypeClass = Thread.currentThread().getContextClassLoader().loadClass(XMLTYPE_CLASS);
            }
            catch (ClassNotFoundException e) {
                throw new HibernateException("Oracle xml type class 'oracle.xdb.XMLType' not found");
            }
        }
        return xmltypeClass;
    }
}

