/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.hibernate.hql.impl;

import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamRewriteEngine;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.openxma.dsl.platform.hibernate.hql.RewritingHqlParserGen;
import org.openxma.dsl.platform.hibernate.hql.impl.HqlTokenWithIndex;
import org.openxma.dsl.platform.hibernate.hql.impl.RewritingHqlLexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RewritingHqlParser
extends RewritingHqlParserGen {
    private static final Log log = LogFactory.getLog(RewritingHqlParser.class);
    public static final String ALIAS_REPLACEMENT = "{alias}";
    public static final String ALIAS_REPLACEMENT_ESCAPED = "\\{alias\\}";
    private static final Pattern ALIAS_PATTERN = Pattern.compile("(\\{alias\\}.\\w+)");
    private SessionFactoryImplementor sessionFactoryImplementor;

    private RewritingHqlParser(TokenStreamRewriteEngine lexer, SessionFactoryImplementor sessionFactoryImplementor) {
        super(lexer);
        this.sessionFactoryImplementor = sessionFactoryImplementor;
    }

    public static RewritingHqlParser getInstance(String hqlString, SessionFactoryImplementor sessionFactoryImplementor) {
        RewritingHqlLexer lexer = new RewritingHqlLexer(new StringReader(hqlString));
        TokenStreamRewriteEngine rewriteEngine = new TokenStreamRewriteEngine((TokenStream)lexer);
        rewriteEngine.discard(124);
        return new RewritingHqlParser(rewriteEngine, sessionFactoryImplementor);
    }

    public String rewriteHqlQuery() {
        Map<String, List<String>> propertyToAliasMap = this.getPropertyToAliasMap();
        StringBuffer hqlBuilder = new StringBuffer();
        Matcher matcher = ALIAS_PATTERN.matcher(this.getRewrittenHql());
        while (matcher.find()) {
            String aliasPath = matcher.group(1);
            String[] split = aliasPath.split("\\.");
            String propertyName = split[1];
            if (this.getPropertyAliasMap().containsKey(propertyName)) {
                matcher.appendReplacement(hqlBuilder, this.getPropertyAliasMap().get(propertyName));
                continue;
            }
            if (this.getSelectedPropertiesPathMap().containsKey(propertyName)) {
                List<String> identifierList = this.getSelectedPropertiesPathMap().get(propertyName);
                this.assertPropertyName(propertyName, identifierList);
                matcher.appendReplacement(hqlBuilder, this.getSelectedPropertiesPathMap().get(propertyName).get(0));
                continue;
            }
            List<String> aliasList = propertyToAliasMap.get(propertyName);
            this.assertPropertyName(propertyName, aliasList);
            matcher.appendReplacement(hqlBuilder, aliasPath.replaceAll(ALIAS_REPLACEMENT_ESCAPED, aliasList.get(0)));
        }
        matcher.appendTail(hqlBuilder);
        return hqlBuilder.toString();
    }

    private void assertPropertyName(String propertyName, List<String> matches) {
        if (matches == null || matches.size() > 1) {
            throw new QueryException("Ambiguous or unassignable property aliases for property '" + propertyName + "' in hql '" + this.getRewrittenHql().trim() + "' matching query aliases '" + matches + "'");
        }
    }

    protected Map<String, List<String>> getPropertyToAliasMap() {
        HashMap<String, List<String>> propertyToAliasMap = new HashMap<String, List<String>>();
        for (String alias : this.getClassAliasMap().keySet()) {
            String className = this.getClassAliasMap().get(alias);
            ClassMetadata classMetadata = this.getClassMetaData(className);
            this.addPropertyNames(alias, classMetadata, propertyToAliasMap);
        }
        for (String alias : this.getJoinAliasMap().keySet()) {
            ClassMetadata classMetadata = this.getJoinedClassMetaData(alias);
            this.addPropertyNames(alias, classMetadata, propertyToAliasMap);
        }
        return propertyToAliasMap;
    }

    protected void addPropertyNames(String alias, ClassMetadata classMetadata, Map<String, List<String>> propertyToAliasMap) {
        if (classMetadata == null) {
            return;
        }
        for (String propertyName : classMetadata.getPropertyNames()) {
            this.addPropertyAlias(alias, propertyName, propertyToAliasMap);
        }
    }

    protected void addPropertyAlias(String alias, String propertyName, Map<String, List<String>> propertyToAliasMap) {
        List<String> aliasList = propertyToAliasMap.get(propertyName);
        if (aliasList == null) {
            aliasList = new ArrayList<String>();
            propertyToAliasMap.put(propertyName, aliasList);
        }
        aliasList.add(alias);
    }

    protected ClassMetadata getJoinedClassMetaData(String joinAlias) throws HibernateException {
        String joinPath = this.getJoinAliasMap().get(joinAlias);
        String[] segments = joinPath.split("\\.");
        String joinOrClassAlias = segments[0];
        String joinedPropertyName = segments[1];
        if (this.getClassAliasMap().containsKey(segments[0])) {
            return this.getClassMetaData(joinOrClassAlias, joinedPropertyName);
        }
        List<String> propertyPathList = this.getPropertyPathSegments(joinOrClassAlias, joinedPropertyName);
        Iterator<String> iterator = propertyPathList.iterator();
        ClassMetadata classMetaData = this.getClassMetaData(iterator.next());
        while (iterator.hasNext()) {
            classMetaData = this.getClassMetaData(classMetaData.getEntityName(), iterator.next());
        }
        return classMetaData;
    }

    protected List<String> getPropertyPathSegments(String joinOrClassAlias, String joinedPropertyName) {
        ArrayList<String> propertyPathList = new ArrayList<String>(Arrays.asList(joinedPropertyName));
        String alias = joinOrClassAlias;
        while (this.getJoinAliasMap().containsKey(alias)) {
            String joinPath = this.getJoinAliasMap().get(alias);
            String[] segments = joinPath.split("\\.");
            alias = segments[0];
            propertyPathList.add(0, segments[1]);
        }
        propertyPathList.add(0, alias);
        return propertyPathList;
    }

    protected ClassMetadata getClassMetaData(String classNameOrAlias, String propertyName) throws HibernateException, MappingException {
        ClassMetadata classMetadata = this.getClassMetaData(classNameOrAlias);
        Type propertyType = classMetadata.getPropertyType(propertyName);
        if (propertyType instanceof EntityType) {
            return this.getClassMetaData(((EntityType)propertyType).getAssociatedEntityName());
        }
        if (propertyType instanceof CollectionType) {
            return this.getClassMetaData(((CollectionType)propertyType).getAssociatedEntityName(this.sessionFactoryImplementor));
        }
        throw new IllegalStateException("unexpected hibernate type");
    }

    protected ClassMetadata getClassMetaData(String classNameOrAlias) throws HibernateException {
        String importedClassName = this.getEntityName(classNameOrAlias);
        return this.sessionFactoryImplementor.getClassMetadata(importedClassName);
    }

    protected String getEntityName(String classNameOrAlias) {
        String className = this.getClassAliasMap().containsKey(classNameOrAlias) ? this.getClassAliasMap().get(classNameOrAlias) : classNameOrAlias;
        return this.sessionFactoryImplementor.getImportedClassName(className);
    }

    @Override
    public void weakKeywords() throws TokenStreamException {
        int t = this.LA(1);
        switch (t) {
            case 24: 
            case 41: {
                if (this.LA(2) == 100) break;
                this.LT(1).setType(120);
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("weakKeywords() : new LT(1) token - " + this.LT(1)));
                break;
            }
            default: {
                HqlTokenWithIndex hqlToken;
                if (this.LA(0) != 22 || t == 120 || this.LA(2) != 15 || !(hqlToken = (HqlTokenWithIndex)this.LT(1)).isPossibleID()) break;
                hqlToken.setType(120);
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("weakKeywords() : new LT(1) token - " + this.LT(1)));
            }
        }
    }

    @Override
    public void handleDotIdent() throws TokenStreamException {
        HqlTokenWithIndex t;
        if (this.LA(1) == 15 && this.LA(2) != 120 && (t = (HqlTokenWithIndex)this.LT(2)).isPossibleID()) {
            this.LT(2).setType(120);
            if (log.isDebugEnabled()) {
                log.debug((Object)("handleDotIdent() : new LT(2) token - " + this.LT(1)));
            }
        }
    }
}

