/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.hibernate.type;

import java.io.IOException;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;
import org.openxma.dsl.platform.util.ByteArrayContainer;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class ByteArrayUserType
implements UserType,
Serializable {
    private static final long serialVersionUID = -2496895380400888283L;
    private static final Class returnedClass = ByteArrayContainer.class;
    private static final int[] SQL_TYPES = new int[]{-3};

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public Class returnedClass() {
        return returnedClass;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == null && y == null) {
            return true;
        }
        if (x == null && y != null) {
            return false;
        }
        return x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        byte[] bytes = rs.getBytes(names[0]);
        if (bytes != null) {
            return new ByteArrayContainer(bytes);
        }
        return null;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        ByteArrayContainer bac = (ByteArrayContainer)value;
        byte[] b = null;
        if (bac != null) {
            b = bac.getData();
            st.setBytes(index, b);
        } else {
            st.setNull(index, -3);
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        ByteArrayContainer bac = (ByteArrayContainer)value;
        byte[] data = bac.getData();
        byte[] copy = new byte[data.length];
        System.arraycopy(data, 0, copy, 0, data.length);
        return new ByteArrayContainer(copy);
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return new BASE64Encoder().encode((byte[])value);
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        try {
            return new BASE64Decoder().decodeBuffer((String)((Object)cached));
        }
        catch (IOException e) {
            throw new HibernateException("Could not assemble String to byte[] (Base64)", (Throwable)e);
        }
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return this.deepCopy(original);
    }
}

