/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.hibernate.type;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.BasicType;
import org.hibernate.type.TypeResolver;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;
import org.hibernate.util.EqualsHelper;
import org.openxma.dsl.platform.hibernate.dialect.OpenXmaOracleDialect;
import org.openxma.dsl.platform.valueobject.XmlPersistenceObject;
import org.openxma.dsl.platform.xml.XmlParserFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.orm.hibernate3.support.BlobByteArrayType;
import org.springframework.orm.hibernate3.support.BlobStringType;
import org.springframework.util.ClassUtils;

public class OpenXmaHibernateType
implements UserType,
ParameterizedType {
    protected Class objectClass = null;
    private final BlobByteArrayType blobArrayType = new BlobByteArrayType();
    private final BlobStringType blobStringType = new BlobStringType();

    public OpenXmaHibernateType() {
    }

    public OpenXmaHibernateType(Class objectClass) {
        this.objectClass = objectClass;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        if (this.classInstanceOfClass(this.objectClass, XmlPersistenceObject.class)) {
            return this.fromXml(cached.toString());
        }
        return cached;
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        if (this.classInstanceOfClass(this.objectClass, XmlPersistenceObject.class)) {
            return this.toXml((XmlPersistenceObject)value);
        }
        return (Serializable)value;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return EqualsHelper.equals((Object)x, (Object)y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public boolean isMutable() {
        return this.classInstanceOfClass(this.objectClass, byte[].class) || this.classInstanceOfClass(this.objectClass, Timestamp.class) || this.classInstanceOfClass(this.objectClass, java.util.Date.class);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        if (this.classInstanceOfClass(this.objectClass, byte[].class)) {
            return (byte[])this.blobArrayType.nullSafeGet(rs, names, owner);
        }
        if (this.classInstanceOfClass(this.objectClass, XmlPersistenceObject.class)) {
            if (OpenXmaOracleDialect.isXmlTypeRegistered()) {
                Object xmlType = rs.getObject(names[0]);
                BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl(xmlType);
                return xmlType != null ? this.fromXml((String)beanWrapperImpl.getPropertyValue("stringVal")) : null;
            }
            return this.blobStringType.nullSafeGet(rs, names, owner);
        }
        return JdbcUtils.getResultSetValue((ResultSet)rs, (int)rs.findColumn(names[0]), (Class)this.objectClass);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (this.classInstanceOfClass(this.objectClass, byte[].class)) {
            this.blobArrayType.nullSafeSet(st, value, index);
        } else if (this.classInstanceOfClass(this.objectClass, XmlPersistenceObject.class)) {
            String xml = value.toString();
            if (value instanceof XmlPersistenceObject) {
                xml = this.toXml((XmlPersistenceObject)value);
            }
            if (OpenXmaOracleDialect.isXmlTypeRegistered()) {
                try {
                    Constructor constructor = OpenXmaOracleDialect.loadXmlTypeClass().getConstructor(Connection.class, String.class);
                    Object xmlType = constructor.newInstance(st.getConnection(), xml);
                    st.setObject(index, xmlType);
                }
                catch (Exception e) {
                    throw new SQLException("Could not marshall Component object to String for storage");
                }
            } else {
                this.blobStringType.nullSafeSet(st, (Object)xml, index);
            }
        } else if (null == value) {
            st.setNull(index, this.sqlTypes()[0]);
        } else {
            switch (this.sqlTypes()[0]) {
                case 91: {
                    st.setObject(index, (Object)new Date(((java.util.Date)value).getTime()), this.sqlTypes()[0]);
                    break;
                }
                case 93: {
                    st.setObject(index, (Object)new Timestamp(((java.util.Date)value).getTime()), this.sqlTypes()[0]);
                    break;
                }
                case 92: {
                    st.setObject(index, (Object)new Time(((java.util.Date)value).getTime()), this.sqlTypes()[0]);
                    break;
                }
                default: {
                    st.setObject(index, value, this.sqlTypes()[0]);
                }
            }
        }
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public Class returnedClass() {
        return this.objectClass;
    }

    public int[] sqlTypes() {
        if (this.classInstanceOfClass(this.objectClass, byte[].class)) {
            return this.blobArrayType.sqlTypes();
        }
        if (this.classInstanceOfClass(this.objectClass, XmlPersistenceObject.class)) {
            if (OpenXmaOracleDialect.isXmlTypeRegistered()) {
                return new int[]{OpenXmaOracleDialect.getXmlTypeSqlCode()};
            }
            return this.blobStringType.sqlTypes();
        }
        TypeResolver typeResolver = new TypeResolver();
        BasicType basicType = typeResolver.basic(this.objectClass.getName());
        return basicType.sqlTypes(null);
    }

    public void setParameterValues(Properties parameters) {
        String objectClassName = parameters.getProperty("objectClass");
        try {
            this.objectClass = ClassUtils.getDefaultClassLoader().loadClass(objectClassName);
        }
        catch (ClassNotFoundException e) {
            throw new HibernateException("Objectclass '" + objectClassName + "' not found");
        }
    }

    protected boolean classInstanceOfClass(Class clazz1, Class clazz2) {
        if (clazz1 == null || clazz2 == null) {
            return false;
        }
        if (clazz1.equals(clazz2)) {
            return true;
        }
        for (int i = 0; i < clazz1.getInterfaces().length; ++i) {
            if (!clazz2.equals(clazz1.getInterfaces()[i])) continue;
            return true;
        }
        if (clazz1.getSuperclass() != null && clazz1.getSuperclass() instanceof Class) {
            return this.classInstanceOfClass(clazz1.getSuperclass(), clazz2);
        }
        return false;
    }

    protected String toXml(XmlPersistenceObject value) {
        return XmlParserFactory.getDefaultXmlParser().toXml(value);
    }

    protected XmlPersistenceObject fromXml(String objectAsString) {
        return (XmlPersistenceObject)XmlParserFactory.getDefaultXmlParser().fromXml(objectAsString);
    }

    public Object nullSafeGet(ResultSet arg0, String[] arg1, SessionImplementor arg2, Object arg3) throws HibernateException, SQLException {
        return null;
    }

    public void nullSafeSet(PreparedStatement arg0, Object arg1, int arg2, SessionImplementor arg3) throws HibernateException, SQLException {
    }
}

