/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.hibernate.type;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.openxma.dsl.platform.hibernate.type.OpenXmaHibernateType;
import org.openxma.dsl.platform.valueobject.ValueObject;
import org.openxma.dsl.platform.valueobject.ValueObjectXml;
import org.openxma.dsl.platform.valueobject.XmlPersistenceObject;
import org.springframework.util.ClassUtils;

public class ValueObjectHibernateType
extends OpenXmaHibernateType {
    private Class valueObjectClass = null;

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        if (this.classInstanceOfClass(this.valueObjectClass, ValueObjectXml.class)) {
            return new ValueObjectXml(this.fromXml(this.getInternalValue(cached).toString()));
        }
        return cached;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        if (this.classInstanceOfClass(this.valueObjectClass, ValueObjectXml.class)) {
            return this.toXml((XmlPersistenceObject)this.getInternalValue(value));
        }
        return (Serializable)value;
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        Object result = super.nullSafeGet(rs, names, owner);
        if (rs.wasNull()) {
            return null;
        }
        try {
            return this.valueObjectClass.getConstructor(this.objectClass).newInstance(result);
        }
        catch (IllegalArgumentException e) {
            throw new HibernateException("There seems to be no constructor(" + this.objectClass + ") method on the Type used: " + this.valueObjectClass.getName(), (Throwable)e);
        }
        catch (SecurityException e) {
            throw new HibernateException("Security settings problem.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new HibernateException("constructor(" + this.objectClass + ") seems not to be public on the Type used: " + this.valueObjectClass.getName(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new HibernateException("constructor(" + this.objectClass + ") threw an exception on the Type used: " + this.valueObjectClass.getName(), e.getTargetException());
        }
        catch (NoSuchMethodException e) {
            throw new HibernateException("There seems to be no constructor(" + this.objectClass + ") method on the Type used: " + this.valueObjectClass.getName(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new HibernateException("The type you use does no seem to be an instantiable class: " + this.valueObjectClass.getName(), (Throwable)e);
        }
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        super.nullSafeSet(st, this.getInternalValue(value), index);
    }

    public Class returnedClass() {
        return this.valueObjectClass;
    }

    public void setParameterValues(Properties parameters) {
        String valueObjectClassName = parameters.getProperty("valueObjectClass");
        try {
            this.valueObjectClass = ClassUtils.getDefaultClassLoader().loadClass(valueObjectClassName);
        }
        catch (ClassNotFoundException e) {
            throw new HibernateException("ValueObject-Class '" + valueObjectClassName + "' not found");
        }
        if (!this.classInstanceOfClass(this.valueObjectClass, ValueObject.class)) {
            throw new IllegalStateException("valueObjectClass " + this.valueObjectClass.getName() + " must be of Type ValueObject");
        }
        this.objectClass = this.getInternalClass(this.valueObjectClass);
    }

    public Class getInternalClass(Class valueObjectClass) {
        Class<?> tempInternal = null;
        Constructor<?>[] constructors = valueObjectClass.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterTypes().length != 1) continue;
            tempInternal = constructors[i].getParameterTypes()[0];
        }
        if (tempInternal == null) {
            throw new IllegalStateException("No internal Type found for Value Object (Constructor with 1 Param)");
        }
        return tempInternal;
    }

    private Object getInternalValue(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof ValueObject)) {
            return value;
        }
        try {
            return this.valueObjectClass.getMethod("getValue", new Class[0]).invoke(value, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new HibernateException("There seems to be no getValue() method without parameters on the Type used: " + this.valueObjectClass.getName(), (Throwable)e);
        }
        catch (SecurityException e) {
            throw new HibernateException("Seccurity settings problem.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new HibernateException("getValue() method seems not to be public on the Type used: " + this.valueObjectClass.getName(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new HibernateException("getValue() threw an exception on the Type used: " + this.valueObjectClass.getName(), e.getTargetException());
        }
        catch (NoSuchMethodException e) {
            throw new HibernateException("There seems to be no getValue() method on the Type used: " + this.valueObjectClass.getName(), (Throwable)e);
        }
    }
}

