/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.i18n;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityHelper {
    public static String getAttributeTitle(Class<?> modelClass, String attributeName) {
        return EntityHelper.getAttributeTitle(modelClass, attributeName, Locale.getDefault());
    }

    public static String getAttributeTitle(Class<?> modelClass, String attributeName, Locale locale, ClassLoader classLoader) {
        String result = attributeName;
        String fqn = EntityHelper.getFQNForBundle(modelClass);
        ResourceBundle bundle = null;
        try {
            bundle = EntityHelper.getBundle(locale, classLoader, fqn);
            result = bundle.getString(attributeName + ".title");
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        return result;
    }

    private static ResourceBundle getBundle(Locale locale, ClassLoader classLoader, String fqn) {
        return PropertyResourceBundle.getBundle(fqn, locale, classLoader);
    }

    private static String getFQNForBundle(Class<?> modelClass) {
        String fqn = modelClass.getPackage().getName() + "." + modelClass.getSimpleName();
        return fqn;
    }

    public static String getAttributeTitle(Class<?> modelClass, String attributeName, Locale locale) {
        return EntityHelper.getAttributeTitle(modelClass, attributeName, locale, EntityHelper.class.getClassLoader());
    }
}

