/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.i18n;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openxma.dsl.platform.exceptions.BeanValidationException;
import org.openxma.dsl.platform.exceptions.ErrorCodedException;
import org.openxma.dsl.platform.i18n.MessageProvider;
import org.openxma.dsl.platform.i18n.MessageResolvable;

public class SimpleErrorMessageProvider
implements MessageProvider {
    protected final Log logger = LogFactory.getLog(this.getClass());
    public static String ERROR_MESSAGE_BUNDLE = "ErrorMessage";
    private List<String> bundleNames = new LinkedList<String>();
    private final String defaultBundleName = ErrorCodedException.class.getPackage().getName() + "." + ERROR_MESSAGE_BUNDLE;

    public SimpleErrorMessageProvider() {
    }

    public SimpleErrorMessageProvider(String[] bundleNames) {
        this.setBundleNames(bundleNames);
    }

    public String getMessage(String key, Object[] params, Locale locale, String defaultMessage) {
        String message = null;
        if (params != null) {
            params = this.prepareParamsForOutput(params);
        }
        for (int i = 0; message == null && i < this.bundleNames.size(); ++i) {
            message = this.resolveMessageForBundle(this.bundleNames.get(i), key, params, locale);
        }
        if (message == null) {
            message = this.resolveMessageForBundle(this.getDefaultBundleName(), key, params, locale);
        }
        return message != null ? message : defaultMessage;
    }

    public String getMessage(MessageResolvable resolvable, Locale locale) {
        return this.getMessage(resolvable.getKey(), resolvable.getArguments(), locale, resolvable.getDefaultMessage());
    }

    public String getMessage(BeanValidationException ex, Locale locale) {
        StringBuilder message = new StringBuilder();
        message.append(this.getMessage((MessageResolvable)ex, locale));
        for (BeanValidationException valIssue : ex.getValidationIssues()) {
            message.append(System.getProperty("line.separator"));
            message.append(this.getMessage((MessageResolvable)valIssue, locale));
        }
        return message.toString();
    }

    public void setBundleNames(String[] bundleNames) {
        for (String bundleName : bundleNames) {
            if (bundleName == null || bundleName.trim().length() == 0) {
                throw new IllegalArgumentException();
            }
            if (this.bundleNames.contains(bundleName = bundleName.trim())) continue;
            this.bundleNames.add(bundleName);
        }
    }

    public void setPreferredBundleName(String preferredBundleName) {
        if (this.bundleNames.indexOf(preferredBundleName) > 0) {
            this.bundleNames.remove(preferredBundleName);
        }
        if (!this.bundleNames.contains(preferredBundleName)) {
            this.bundleNames.add(preferredBundleName);
        }
    }

    protected Object[] prepareParamsForOutput(Object[] params) {
        Object[] preparedParams = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            preparedParams[i] = params[i] instanceof Object[] ? this.formatParam((Object[])params[i]) : this.formatParam(params[i]);
        }
        return preparedParams;
    }

    protected Object formatParam(Object[] param) {
        return Arrays.toString(param);
    }

    protected Object formatParam(Object param) {
        return param;
    }

    protected String getDefaultBundleName() {
        return this.defaultBundleName;
    }

    protected ResourceBundle getResourceBundle(String bundleName, Locale locale) throws MissingResourceException {
        return ResourceBundle.getBundle(bundleName, locale);
    }

    protected String resolveMessage(ResourceBundle bundle, String key, Object[] params) {
        try {
            return MessageFormat.format(bundle.getString(key), params);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    protected String resolveMessageForBundle(String bundleName, String key, Object[] params, Locale locale) {
        ResourceBundle bundle = this.getResourceBundle(bundleName, locale);
        if (bundle != null) {
            return this.resolveMessage(bundle, key, params);
        }
        return null;
    }
}

