/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.jdbc;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcUtils2
extends JdbcUtils {
    public static <T> T getResultSetValue(ResultSet rs, String columName, Class<T> requiredType) throws SQLException {
        Assert.notNull((Object)rs, (String)"parameter 'resultSet' must not be null");
        Assert.notNull((Object)columName, (String)"parameter 'columName' must not be null");
        Assert.notNull(requiredType, (String)"parameter 'requiredType' must not be null");
        Object value = null;
        boolean wasNullCheck = false;
        if (String.class.equals(requiredType)) {
            value = rs.getString(columName);
        } else if (Boolean.TYPE.equals(requiredType) || Boolean.class.equals(requiredType)) {
            value = rs.getBoolean(columName);
            wasNullCheck = true;
        } else if (Byte.TYPE.equals(requiredType) || Byte.class.equals(requiredType)) {
            value = new Byte(rs.getByte(columName));
            wasNullCheck = true;
        } else if (Short.TYPE.equals(requiredType) || Short.class.equals(requiredType)) {
            value = new Short(rs.getShort(columName));
            wasNullCheck = true;
        } else if (Integer.TYPE.equals(requiredType) || Integer.class.equals(requiredType)) {
            value = new Integer(rs.getInt(columName));
            wasNullCheck = true;
        } else if (Long.TYPE.equals(requiredType) || Long.class.equals(requiredType)) {
            value = new Long(rs.getLong(columName));
            wasNullCheck = true;
        } else if (Float.TYPE.equals(requiredType) || Float.class.equals(requiredType)) {
            value = new Float(rs.getFloat(columName));
            wasNullCheck = true;
        } else if (Double.TYPE.equals(requiredType) || Double.class.equals(requiredType) || Number.class.equals(requiredType)) {
            value = new Double(rs.getDouble(columName));
            wasNullCheck = true;
        } else {
            value = byte[].class.equals(requiredType) ? (Object)rs.getBytes(columName) : (java.sql.Date.class.equals(requiredType) ? rs.getDate(columName) : (Time.class.equals(requiredType) ? rs.getTime(columName) : (Timestamp.class.equals(requiredType) || Date.class.equals(requiredType) ? rs.getTimestamp(columName) : (BigDecimal.class.equals(requiredType) ? rs.getBigDecimal(columName) : (Blob.class.equals(requiredType) ? rs.getBlob(columName) : (Clob.class.equals(requiredType) ? rs.getClob(columName) : JdbcUtils2.getResultSetValue(rs, columName)))))));
        }
        if (wasNullCheck && value != null && rs.wasNull()) {
            value = null;
        }
        return (T)value;
    }

    public static Object getResultSetValue(ResultSet rs, String columName) throws SQLException {
        Object obj = rs.getObject(columName);
        String className = null;
        if (obj != null) {
            className = obj.getClass().getName();
        }
        if (obj instanceof Blob) {
            obj = rs.getBytes(columName);
        } else if (obj instanceof Clob) {
            obj = rs.getString(columName);
        } else if (className != null && ("oracle.sql.TIMESTAMP".equals(className) || "oracle.sql.TIMESTAMPTZ".equals(className))) {
            obj = rs.getTimestamp(columName);
        } else if (className != null && className.startsWith("oracle.sql.DATE")) {
            int columnIndex = JdbcUtils2.lookupColumnIndex(rs.getMetaData(), columName);
            String metaDataClassName = rs.getMetaData().getColumnClassName(columnIndex);
            obj = "java.sql.Timestamp".equals(metaDataClassName) || "oracle.sql.TIMESTAMP".equals(metaDataClassName) ? rs.getTimestamp(columName) : rs.getDate(columName);
        } else if (obj != null && obj instanceof java.sql.Date) {
            int columnIndex = JdbcUtils2.lookupColumnIndex(rs.getMetaData(), columName);
            if ("java.sql.Timestamp".equals(rs.getMetaData().getColumnClassName(columnIndex))) {
                obj = rs.getTimestamp(columName);
            }
        }
        return obj;
    }

    public static int lookupColumnIndex(ResultSetMetaData resultSetMetaData, String name) throws SQLException {
        int columnCount = resultSetMetaData.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = resultSetMetaData.getColumnName(i);
            if (!columnName.equals(name)) continue;
            return i;
        }
        return -1;
    }
}

