/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.query;

import java.io.Serializable;
import org.openxma.dsl.platform.query.ExpressionOperator;
import org.openxma.dsl.platform.query.QueryContext;
import org.openxma.dsl.platform.query.impl.BinaryExpression;
import org.openxma.dsl.platform.query.impl.ConstantExpression;
import org.openxma.dsl.platform.query.impl.ParameterExpression;

public abstract class Expression
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected Expression parent;

    public Expression() {
    }

    public Expression(Expression parent) {
        this.parent = parent;
    }

    public void setParent(Expression parent) {
        this.parent = parent;
    }

    public Expression getParent() {
        return this.parent;
    }

    public abstract Object evaluate(QueryContext var1);

    public Expression and(Expression expression) {
        return ExpressionOperator.AND.with(this, expression);
    }

    public Expression or(Expression expression) {
        return ExpressionOperator.OR.with(this, expression);
    }

    public Expression isNull() {
        return ExpressionOperator.IS_NULL.with(this, ConstantExpression.NULL);
    }

    public Expression isNotNull() {
        return ExpressionOperator.IS_NOT_NULL.with(this, ConstantExpression.NULL);
    }

    public Expression eq(Object value) {
        return ExpressionOperator.EQUALS.with(this, value);
    }

    public Expression neq(Object value) {
        return ExpressionOperator.NOT_EQUALS.with(this, value);
    }

    public Expression gt(Object value) {
        return ExpressionOperator.GREATER_THAN.with(this, value);
    }

    public Expression gte(Object value) {
        return ExpressionOperator.GREATER_THAN_OR_EQUAL.with(this, value);
    }

    public Expression lt(Object value) {
        return ExpressionOperator.LESS_THAN.with(this, value);
    }

    public Expression lte(Object value) {
        return ExpressionOperator.LESS_THAN_OR_EQUAL.with(this, value);
    }

    public Expression get(String field) {
        return new ParameterExpression(this, field);
    }

    public Expression like(Object value) {
        return ExpressionOperator.LIKE.with(this, value);
    }

    public Expression notLike(Object value) {
        return ExpressionOperator.NOT_LIKE.with(this, value);
    }

    public Expression asc() {
        return ExpressionOperator.ASC.with(this, new Object[0]);
    }

    public Expression desc() {
        return ExpressionOperator.DESC.with(this, new Object[0]);
    }

    public static String print(Expression expression) {
        String result = "";
        if (!(expression instanceof BinaryExpression)) {
            result = result + expression.toString();
        } else {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            if (binaryExpression.parent != null) {
                result = result + "(";
            }
            result = result + Expression.print(binaryExpression.getLeft());
            result = result + " ";
            result = result + (Object)((Object)binaryExpression.getOperator());
            result = result + " ";
            result = result + Expression.print(binaryExpression.getRight());
            if (binaryExpression.parent != null) {
                result = result + ")";
            }
        }
        return result;
    }
}

