/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.query;

import org.openxma.dsl.platform.query.Expression;
import org.openxma.dsl.platform.query.impl.ConstantExpression;
import org.openxma.dsl.platform.query.impl.LogicalExpression;
import org.openxma.dsl.platform.query.impl.RelationalExpression;
import org.openxma.dsl.platform.query.impl.SortOrderExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ExpressionOperator {
    ASC{

        public Expression with(Expression expression, Object ... arguments) {
            return new SortOrderExpression(expression, this);
        }
    }
    ,
    DESC{

        public Expression with(Expression expression, Object ... arguments) {
            return new SortOrderExpression(expression, this);
        }
    }
    ,
    LIKE{

        public Expression with(Expression expression, Object ... arguments) {
            return new RelationalExpression(expression, this, ExpressionOperator.toExpression(expression, arguments));
        }
    }
    ,
    IS_NULL{

        public Expression with(Expression expression, Object ... arguments) {
            return new LogicalExpression(expression, this, ExpressionOperator.toExpression(expression, arguments));
        }
    }
    ,
    IS_NOT_NULL{

        public Expression with(Expression expression, Object ... arguments) {
            return new LogicalExpression(expression, this, ExpressionOperator.toExpression(expression, arguments));
        }
    }
    ,
    EQUALS{

        public Expression with(Expression expression, Object ... arguments) {
            return new RelationalExpression(expression, this, ExpressionOperator.toExpression(expression, arguments));
        }
    }
    ,
    GREATER_THAN{

        public Expression with(Expression expression, Object ... arguments) {
            return new RelationalExpression(expression, this, ExpressionOperator.toExpression(expression, arguments));
        }
    }
    ,
    GREATER_THAN_OR_EQUAL{

        public Expression with(Expression expression, Object ... arguments) {
            return new RelationalExpression(expression, this, ExpressionOperator.toExpression(expression, arguments));
        }
    }
    ,
    LESS_THAN{

        public Expression with(Expression expression, Object ... arguments) {
            return new RelationalExpression(expression, this, ExpressionOperator.toExpression(expression, arguments));
        }
    }
    ,
    LESS_THAN_OR_EQUAL{

        public Expression with(Expression expression, Object ... arguments) {
            return new RelationalExpression(expression, this, ExpressionOperator.toExpression(expression, arguments));
        }
    }
    ,
    AND{

        public Expression with(Expression expression, Object ... arguments) {
            return new LogicalExpression(expression, this, ExpressionOperator.toExpression(expression, arguments));
        }
    }
    ,
    OR{

        public Expression with(Expression expression, Object ... arguments) {
            return new LogicalExpression(expression, this, ExpressionOperator.toExpression(expression, arguments));
        }
    }
    ,
    NOT_EQUALS{

        public Expression with(Expression expression, Object ... arguments) {
            return new RelationalExpression(expression, this, ExpressionOperator.toExpression(expression, arguments));
        }
    }
    ,
    NOT_LIKE{

        public Expression with(Expression expression, Object ... arguments) {
            return new RelationalExpression(expression, this, ExpressionOperator.toExpression(expression, arguments));
        }
    };


    public abstract Expression with(Expression var1, Object ... var2);

    private static Expression toExpression(Expression expression, Object ... arguments) {
        if (ExpressionOperator.isSingleArgument(arguments)) {
            return ExpressionOperator.toExpression(expression, arguments[0]);
        }
        throw new IllegalStateException("multiple arguments not supported!");
    }

    private static Expression toExpression(Expression expression, Object argument) {
        if (argument instanceof Expression) {
            return (Expression)argument;
        }
        return new ConstantExpression(expression, argument);
    }

    private static boolean isSingleArgument(Object[] arguments) {
        return null != arguments && arguments.length == 1;
    }
}

