/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openxma.dsl.platform.query.Expression;
import org.openxma.dsl.platform.query.QueryContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryObject
extends Expression {
    private static final long serialVersionUID = 1L;
    private String queryName;
    private int firstResult;
    private int maxResults;
    private Expression whereExpression;
    private List<Expression> sortOrderExpressions;
    private Map<String, Object> queryArguments;

    public QueryObject() {
    }

    public QueryObject(String queryName) {
        this.queryName = queryName;
    }

    public static QueryObject createNamedQuery(String queryName) {
        return new QueryObject(queryName);
    }

    public static QueryObject createNamedQuery(String queryName, Expression expression) {
        QueryObject result = new QueryObject(queryName);
        if (expression instanceof QueryObject) {
            QueryObject queryObject = (QueryObject)expression;
            result.firstResult = queryObject.firstResult;
            result.maxResults = queryObject.maxResults;
            result.whereExpression = queryObject.whereExpression;
            result.sortOrderExpressions = queryObject.sortOrderExpressions;
        }
        return result;
    }

    public List<Expression> getSortOrderExpressions() {
        if (this.sortOrderExpressions == null) {
            this.sortOrderExpressions = new ArrayList<Expression>();
        }
        return this.sortOrderExpressions;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }

    public Map<String, Object> getArguments() {
        if (this.queryArguments == null) {
            this.queryArguments = new HashMap<String, Object>();
        }
        return this.queryArguments;
    }

    public Expression getWhereExpression() {
        return this.whereExpression;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public QueryObject setFirstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public QueryObject setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public QueryObject where(Expression expression) {
        this.whereExpression = expression;
        return this;
    }

    public QueryObject orderBy(Expression expression) {
        this.getSortOrderExpressions().add(expression);
        return this;
    }

    public QueryObject withArgs(String name, Object value) {
        this.getArguments().put(name, value);
        return this;
    }

    @Override
    public Object evaluate(QueryContext queryContext) {
        return queryContext.accept(this);
    }
}

