/*
 * Decompiled with CFR 0.152.
 */
package org.openxma.dsl.platform.service;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.openxma.dsl.platform.dao.EntityFactory;
import org.openxma.dsl.platform.dao.EntityFactoryRegistry;
import org.openxma.dsl.platform.service.MapperConfig;
import org.openxma.dsl.platform.service.MapperContext;
import org.openxma.dsl.platform.service.impl.SimpleMapperContext;
import org.springframework.core.NamedInheritableThreadLocal;
import org.springframework.core.NamedThreadLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapperContextHolder {
    private static final ThreadLocal<MapperContext> mapperContextHolder = new NamedThreadLocal("Mapper context");
    private static final ThreadLocal<MapperContext> inheritableMapperContextHolder = new NamedInheritableThreadLocal("Mapper context");
    public static final String MAPPER_OPERATION_PREFIX = "mapper:";
    public static final String CONTEXT = "context";

    public static void reset() {
        mapperContextHolder.set(null);
        inheritableMapperContextHolder.set(null);
    }

    public static void setMapperContext(MapperContext mapperContext) {
        MapperContextHolder.setMapperContext(mapperContext, false);
    }

    public static void setMapperContext(MapperContext mapperContext, boolean inheritable) {
        if (inheritable) {
            inheritableMapperContextHolder.set(mapperContext);
            mapperContextHolder.set(null);
        } else {
            mapperContextHolder.set(mapperContext);
            inheritableMapperContextHolder.set(null);
        }
    }

    public static MapperContext getMapperContext() {
        MapperContext mapperContext = mapperContextHolder.get();
        if (mapperContext == null) {
            mapperContext = inheritableMapperContextHolder.get();
        }
        return mapperContext;
    }

    public static void setRegistry(EntityFactoryRegistry registry) {
        MapperContextHolder.setRegistryWithContext(registry, new HashMap(), false);
    }

    public static void setRegistryWithContext(EntityFactoryRegistry registry, Map context, boolean inheritable) {
        SimpleMapperContext mapperContext = registry != null ? new SimpleMapperContext(registry, context) : null;
        MapperContextHolder.setMapperContext(mapperContext, inheritable);
    }

    public static EntityFactoryRegistry getEntityFactoryRegistry() {
        MapperContext mapperContext = MapperContextHolder.getMapperContext();
        return mapperContext != null ? mapperContext.getEntityFactoryRegistry() : null;
    }

    public static <T> T createEntity(Class<T> entityClass) {
        return MapperContextHolder.getEntityFactoryRegistry().getEntityFactory(entityClass).createEntity(null);
    }

    public static <T> T createComplexType(Class<T> complexTypeClass) {
        EntityFactory<T> ef = MapperContextHolder.getEntityFactoryRegistry().getEntityFactory(complexTypeClass);
        if (null != ef) {
            return ef.createEntity(null);
        }
        try {
            return complexTypeClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException("no arg constructor not allowed for class: '" + complexTypeClass.getName() + "' message: '" + e.getMessage() + "'");
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("missing constructor for class: '" + complexTypeClass.getName() + "' message: '" + e.getMessage() + "'");
        }
        catch (InstantiationException e) {
            throw new RuntimeException("InstantiationException while constructing class: '" + complexTypeClass.getName() + "' message: '" + e.getMessage() + "'");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("IllegalAccessException while constructing class: '" + complexTypeClass.getName() + "' message: '" + e.getMessage() + "'");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("InvocationTargetException while constructing class: '" + complexTypeClass.getName() + "' message: '" + e.getMessage() + "'");
        }
    }

    public static Map getStateMap() {
        return MapperContextHolder.getContext();
    }

    public static Map<Object, Object> getContext() {
        MapperContext mapperContext = MapperContextHolder.getMapperContext();
        return mapperContext != null ? mapperContext.getContext() : null;
    }

    public static boolean isContext(String contextName) {
        return contextName.equals(MapperContextHolder.getContext().get(CONTEXT));
    }

    public static boolean isMapperOperation() {
        if (null == MapperContextHolder.getContext() || MapperContextHolder.getContext().size() == 0) {
            return false;
        }
        for (Map.Entry<Object, Object> next : MapperContextHolder.getContext().entrySet()) {
            String key;
            if (!(next.getKey() instanceof String) || !(key = (String)next.getKey()).startsWith(MAPPER_OPERATION_PREFIX)) continue;
            return true;
        }
        return false;
    }

    public static MapperConfig getMapperConfig() {
        if (null == MapperContextHolder.getContext() || MapperContextHolder.getContext().size() == 0) {
            return null;
        }
        for (Map.Entry<Object, Object> next : MapperContextHolder.getContext().entrySet()) {
            String key;
            if (!(next.getKey() instanceof String) || !(key = (String)next.getKey()).startsWith(MAPPER_OPERATION_PREFIX) || !(next.getValue() instanceof MapperConfig)) continue;
            return (MapperConfig)next.getValue();
        }
        return null;
    }

    public static void setMapperContext(String mapperName, MapperConfig mapperConfig) {
        if (null == mapperName || mapperName.trim().length() == 0) {
            throw new IllegalArgumentException("missing mapperName");
        }
        HashMap<String, MapperConfig> ctx = new HashMap<String, MapperConfig>(1);
        ctx.put(MAPPER_OPERATION_PREFIX + mapperName, mapperConfig);
        MapperContextHolder.setMapperContext(new SimpleMapperContext(null, ctx));
    }
}

